/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.automaton;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import org.apache.pinot.segment.local.utils.nativefst.automaton.State;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Transition;

public final class StringUnionOperations {
    public static final Comparator<CharSequence> LEXICOGRAPHIC_ORDER = (s1, s2) -> {
        int lens1 = s1.length();
        int lens2 = s2.length();
        int max = Math.min(lens1, lens2);
        for (int i = 0; i < max; ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i))) continue;
            return c1 - c2;
        }
        return lens1 - lens2;
    };
    private HashMap<StateWithTransitionLabels, StateWithTransitionLabels> _register = new HashMap();
    private StateWithTransitionLabels _root = new StateWithTransitionLabels();
    private StringBuilder _previous;

    private static State convert(StateWithTransitionLabels s, IdentityHashMap<StateWithTransitionLabels, State> visited) {
        State converted = visited.get(s);
        if (converted != null) {
            return converted;
        }
        converted = new State();
        converted.setAccept(s._isFinal);
        visited.put(s, converted);
        int i = 0;
        char[] labels = s._labels;
        for (StateWithTransitionLabels target : s._stateWithTransitionLables) {
            converted.addTransition(new Transition(labels[i++], StringUnionOperations.convert(target, visited)));
        }
        return converted;
    }

    public static State build(CharSequence[] input) {
        StringUnionOperations builder = new StringUnionOperations();
        for (CharSequence chs : input) {
            builder.add(chs);
        }
        return StringUnionOperations.convert(builder.complete(), new IdentityHashMap<StateWithTransitionLabels, State>());
    }

    public void add(CharSequence current) {
        StateWithTransitionLabels next;
        int pos;
        assert (this._register != null) : "Automaton already built.";
        assert (current.length() > 0) : "Input sequences must not be empty.";
        assert (this._previous == null || LEXICOGRAPHIC_ORDER.compare(this._previous, current) <= 0) : "Input must be sorted: " + this._previous + " >= " + current;
        assert (this.setPrevious(current));
        int max = current.length();
        StateWithTransitionLabels stateWithTransitionLabels = this._root;
        for (pos = 0; pos < max && (next = stateWithTransitionLabels.lastChild(current.charAt(pos))) != null; ++pos) {
            stateWithTransitionLabels = next;
        }
        if (stateWithTransitionLabels.hasChildren()) {
            this.replaceOrRegister(stateWithTransitionLabels);
        }
        this.addSuffix(stateWithTransitionLabels, current, pos);
    }

    public StateWithTransitionLabels complete() {
        if (this._register == null) {
            throw new IllegalStateException();
        }
        if (this._root.hasChildren()) {
            this.replaceOrRegister(this._root);
        }
        this._register = null;
        return this._root;
    }

    private boolean setPrevious(CharSequence current) {
        if (this._previous == null) {
            this._previous = new StringBuilder();
        }
        this._previous.setLength(0);
        this._previous.append(current);
        return true;
    }

    private void replaceOrRegister(StateWithTransitionLabels stateWithTransitionLabels) {
        StateWithTransitionLabels registered;
        StateWithTransitionLabels child = stateWithTransitionLabels.lastChild();
        if (child.hasChildren()) {
            this.replaceOrRegister(child);
        }
        if ((registered = this._register.get(child)) != null) {
            stateWithTransitionLabels.replaceLastChild(registered);
        } else {
            this._register.put(child, child);
        }
    }

    private void addSuffix(StateWithTransitionLabels stateWithTransitionLabels, CharSequence current, int fromIndex) {
        int len = current.length();
        for (int i = fromIndex; i < len; ++i) {
            stateWithTransitionLabels = stateWithTransitionLabels.newState(current.charAt(i));
        }
        stateWithTransitionLabels._isFinal = true;
    }

    static final class StateWithTransitionLabels {
        private static final char[] NO_LABELS = new char[0];
        private static final StateWithTransitionLabels[] NO_STATE_WITH_TRANSITION_LABLES = new StateWithTransitionLabels[0];
        char[] _labels = NO_LABELS;
        StateWithTransitionLabels[] _stateWithTransitionLables = NO_STATE_WITH_TRANSITION_LABLES;
        boolean _isFinal;

        StateWithTransitionLabels() {
        }

        private static char[] copyOf(char[] original, int newLength) {
            char[] copy = new char[newLength];
            System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
            return copy;
        }

        public static StateWithTransitionLabels[] copyOf(StateWithTransitionLabels[] original, int newLength) {
            StateWithTransitionLabels[] copy = new StateWithTransitionLabels[newLength];
            System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
            return copy;
        }

        private static boolean referenceEquals(Object[] a1, Object[] a2) {
            if (a1.length != a2.length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }

        public StateWithTransitionLabels getState(char label) {
            int index = Arrays.binarySearch(this._labels, label);
            return index >= 0 ? this._stateWithTransitionLables[index] : null;
        }

        public boolean equals(Object obj) {
            StateWithTransitionLabels other = (StateWithTransitionLabels)obj;
            return this._isFinal == other._isFinal && Arrays.equals(this._labels, other._labels) && StateWithTransitionLabels.referenceEquals(this._stateWithTransitionLables, other._stateWithTransitionLables);
        }

        public boolean hasChildren() {
            return this._labels.length > 0;
        }

        public boolean isFinal() {
            return this._isFinal;
        }

        public int hashCode() {
            int hash = this._isFinal ? 1 : 0;
            hash ^= hash * 31 + this._labels.length;
            for (char c : this._labels) {
                hash ^= hash * 31 + c;
            }
            for (StateWithTransitionLabels s : this._stateWithTransitionLables) {
                hash ^= System.identityHashCode(s);
            }
            return hash;
        }

        StateWithTransitionLabels newState(char label) {
            assert (Arrays.binarySearch(this._labels, label) < 0) : "State already has transition labeled: " + label;
            this._labels = StateWithTransitionLabels.copyOf(this._labels, this._labels.length + 1);
            this._stateWithTransitionLables = StateWithTransitionLabels.copyOf(this._stateWithTransitionLables, this._stateWithTransitionLables.length + 1);
            this._labels[this._labels.length - 1] = label;
            this._stateWithTransitionLables[this._stateWithTransitionLables.length - 1] = new StateWithTransitionLabels();
            return this._stateWithTransitionLables[this._stateWithTransitionLables.length - 1];
        }

        StateWithTransitionLabels lastChild() {
            assert (this.hasChildren()) : "No outgoing transitions.";
            return this._stateWithTransitionLables[this._stateWithTransitionLables.length - 1];
        }

        StateWithTransitionLabels lastChild(char label) {
            int index = this._labels.length - 1;
            StateWithTransitionLabels s = null;
            if (index >= 0 && this._labels[index] == label) {
                s = this._stateWithTransitionLables[index];
            }
            assert (s == this.getState(label));
            return s;
        }

        void replaceLastChild(StateWithTransitionLabels stateWithTransitionLabels) {
            assert (this.hasChildren()) : "No outgoing transitions.";
            this._stateWithTransitionLables[this._stateWithTransitionLables.length - 1] = stateWithTransitionLabels;
        }
    }
}

