/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.builder;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.pinot.segment.local.utils.nativefst.ConstantArcSizeFST;
import org.apache.pinot.segment.local.utils.nativefst.FST;
import org.apache.pinot.spi.utils.ByteArray;

public final class FSTBuilder {
    public static final Comparator<byte[]> LEXICAL_ORDERING = ByteArray::compare;
    private static final int MB = 0x100000;
    private static final int BUFFER_GROWTH_SIZE = 0x500000;
    private static final int MAX_LABELS = 256;
    private final int _bufferGrowthSize;
    private byte[] _serialized = new byte[0];
    private Map<Integer, Integer> _outputSymbols = new HashMap<Integer, Integer>();
    private int _size;
    private int[] _activePath = new int[0];
    private int _activePathLen;
    private int[] _nextArcOffset = new int[0];
    private int _root;
    private int _epsilon;
    private int[] _hashSet = new int[2];
    private int _hashSize = 0;
    private byte[] _previous;
    private TreeMap<InfoEntry, Object> _info;
    private int _previousLength;
    private int _serializationBufferReallocations;

    public FSTBuilder() {
        this(0x500000);
    }

    public FSTBuilder(int bufferGrowthSize) {
        this._bufferGrowthSize = Math.max(bufferGrowthSize, 1536);
        this._epsilon = this.allocateState(1);
        int n = this._epsilon + 0;
        this._serialized[n] = (byte)(this._serialized[n] | 1);
        this.expandActivePath(1);
        this._root = this._activePath[0];
    }

    public static FST buildFST(SortedMap<String, Integer> input) {
        FSTBuilder fstbuilder = new FSTBuilder();
        for (Map.Entry<String, Integer> entry : input.entrySet()) {
            fstbuilder.add(entry.getKey().getBytes(), 0, entry.getKey().length(), entry.getValue());
        }
        return fstbuilder.complete();
    }

    public static FST build(byte[][] input, int[] outputSymbols) {
        FSTBuilder builder = new FSTBuilder();
        int i = 0;
        for (byte[] chs : input) {
            builder.add(chs, 0, chs.length, i < outputSymbols.length ? outputSymbols[i] : -1);
            ++i;
        }
        return builder.complete();
    }

    public static FST build(Iterable<byte[]> input, int[] outputSymbols) {
        FSTBuilder builder = new FSTBuilder();
        int i = 0;
        for (byte[] chs : input) {
            builder.add(chs, 0, chs.length, i < outputSymbols.length ? outputSymbols[i] : -1);
            ++i;
        }
        return builder.complete();
    }

    private static int compare(byte[] s1, int start1, int lens1, byte[] s2, int start2, int lens2) {
        int max = Math.min(lens1, lens2);
        for (int i = 0; i < max; ++i) {
            byte c2;
            byte c1;
            if ((c1 = s1[start1++]) == (c2 = s2[start2++])) continue;
            return (c1 & 0xFF) - (c2 & 0xFF);
        }
        return lens1 - lens2;
    }

    public void add(byte[] sequence, int start, int len, int outputSymbol) {
        assert (this._serialized != null) : "Automaton already built.";
        assert (this._previous == null || len == 0 || ByteArray.compare((byte[])this._previous, (int)0, (int)this._previousLength, (byte[])sequence, (int)start, (int)(start + len)) <= 0) : "Input must be sorted: " + Arrays.toString(Arrays.copyOf(this._previous, this._previousLength)) + " >= " + Arrays.toString(Arrays.copyOfRange(sequence, start, len));
        assert (this.setPrevious(sequence, start, len));
        int commonPrefix = this.commonPrefix(sequence, start, len);
        this.expandActivePath(len);
        for (int i = this._activePathLen - 1; i > commonPrefix; --i) {
            int frozenState = this.freezeState(i);
            this.setArcTarget(this._nextArcOffset[i - 1] - 6, frozenState);
            this._nextArcOffset[i] = this._activePath[i];
        }
        int prevArc = -1;
        int j = start + commonPrefix;
        for (int i = commonPrefix + 1; i <= len; ++i) {
            int p = this._nextArcOffset[i - 1];
            this._serialized[p + 0] = (byte)(i == len ? 2 : 0);
            this._serialized[p + 1] = sequence[j++];
            this.setArcTarget(p, i == len ? 0 : this._activePath[i]);
            this._nextArcOffset[i - 1] = p + 6;
            prevArc = p;
        }
        if (prevArc != -1) {
            this._outputSymbols.put(prevArc, outputSymbol);
        }
        this._activePathLen = len;
    }

    public FST complete() {
        this.add(new byte[0], 0, 0, -1);
        if (this._nextArcOffset[0] - this._activePath[0] == 0) {
            this.setArcTarget(this._epsilon, 0);
        } else {
            this._root = this.freezeState(0);
            this.setArcTarget(this._epsilon, this._root);
        }
        this._info = new TreeMap();
        this._info.put(InfoEntry.SERIALIZATION_BUFFER_SIZE, this._serialized.length);
        this._info.put(InfoEntry.SERIALIZATION_BUFFER_REALLOCATIONS, this._serializationBufferReallocations);
        this._info.put(InfoEntry.CONSTANT_ARC_AUTOMATON_SIZE, this._size);
        this._info.put(InfoEntry.MAX_ACTIVE_PATH_LENGTH, this._activePath.length);
        this._info.put(InfoEntry.STATE_REGISTRY_TABLE_SLOTS, this._hashSet.length);
        this._info.put(InfoEntry.STATE_REGISTRY_SIZE, this._hashSize);
        this._info.put(InfoEntry.ESTIMATED_MEMORY_CONSUMPTION_MB, (double)(this._serialized.length + this._hashSet.length * 4) / 1048576.0);
        ConstantArcSizeFST fst = new ConstantArcSizeFST(Arrays.copyOf(this._serialized, this._size), this._epsilon, this._outputSymbols);
        this._serialized = null;
        this._hashSet = null;
        return fst;
    }

    private boolean isArcLast(int arc) {
        return (this._serialized[arc + 0] & 1) != 0;
    }

    private boolean isArcFinal(int arc) {
        return (this._serialized[arc + 0] & 2) != 0;
    }

    private byte getArcLabel(int arc) {
        return this._serialized[arc + 1];
    }

    private void setArcTarget(int arc, int state) {
        arc += 6;
        for (int i = 0; i < 4; ++i) {
            this._serialized[--arc] = (byte)state;
            state >>>= 8;
        }
    }

    private int getArcTarget(int arc) {
        return this._serialized[arc += 2] << 24 | (this._serialized[arc + 1] & 0xFF) << 16 | (this._serialized[arc + 2] & 0xFF) << 8 | this._serialized[arc + 3] & 0xFF;
    }

    private int commonPrefix(byte[] sequence, int start, int len) {
        int lastArc;
        int i;
        int max = Math.min(len, this._activePathLen);
        for (i = 0; i < max && sequence[start++] == this.getArcLabel(lastArc = this._nextArcOffset[i] - 6); ++i) {
        }
        return i;
    }

    private int freezeState(int activePathIndex) {
        int start = this._activePath[activePathIndex];
        int end = this._nextArcOffset[activePathIndex];
        int len = end - start;
        int n = end - 6 + 0;
        this._serialized[n] = (byte)(this._serialized[n] | 1);
        int state = 0;
        if (!this.equivalent(state, start, len)) {
            state = this.serialize(activePathIndex);
            if (++this._hashSize > this._hashSet.length / 2) {
                this.expandAndRehash();
            }
            this.replaceOutputSymbol(start, state);
        }
        return state;
    }

    private void replaceOutputSymbol(int target, int state) {
        if (!this._outputSymbols.containsKey(target)) {
            return;
        }
        int outputSymbol = this._outputSymbols.get(target);
        this._outputSymbols.put(state, outputSymbol);
        this._outputSymbols.remove(target);
    }

    private void expandAndRehash() {
        int[] newHashSet = new int[this._hashSet.length * 2];
        int bucketMask = newHashSet.length - 1;
        for (int j = 0; j < this._hashSet.length; ++j) {
            int state = this._hashSet[j];
            if (state <= 0) continue;
            int slot = this.hash(state, this.stateLength(state)) & bucketMask;
            int i = 0;
            while (newHashSet[slot] > 0) {
                slot = slot + ++i & bucketMask;
            }
            newHashSet[slot] = state;
        }
        this._hashSet = newHashSet;
    }

    private int stateLength(int state) {
        int arc = state;
        while (!this.isArcLast(arc)) {
            arc += 6;
        }
        return arc - state + 6;
    }

    private boolean equivalent(int start1, int start2, int len) {
        if (start1 + len > this._size || start2 + len > this._size) {
            return false;
        }
        while (len-- > 0) {
            if (this._serialized[start1++] == this._serialized[start2++]) continue;
            return false;
        }
        return true;
    }

    private int serialize(int activePathIndex) {
        this.expandBuffers();
        int newState = this._size;
        int start = this._activePath[activePathIndex];
        int len = this._nextArcOffset[activePathIndex] - start;
        if (len > 6) {
            assert (len % 6 == 0);
            int i = 0;
            int j = 0;
            while (i < len) {
                Integer currentOutputSymbol = this._outputSymbols.get(this._activePath[activePathIndex] + j * 6);
                if (currentOutputSymbol != null) {
                    this._outputSymbols.put(newState + j * 6, this._outputSymbols.get(this._activePath[activePathIndex] + j * 6));
                }
                i += 6;
                ++j;
            }
        }
        System.arraycopy(this._serialized, start, this._serialized, newState, len);
        this._size += len;
        return newState;
    }

    private int hash(int start, int byteCount) {
        assert (byteCount % 6 == 0) : "Not an arc multiply?";
        int h = 0;
        int arcs = byteCount / 6;
        while (--arcs >= 0) {
            h = 17 * h + this.getArcLabel(start);
            h = 17 * h + this.getArcTarget(start);
            if (this.isArcFinal(start)) {
                h += 17;
            }
            start += 6;
        }
        return h;
    }

    private void expandActivePath(int size) {
        if (this._activePath.length < size) {
            int p = this._activePath.length;
            this._activePath = Arrays.copyOf(this._activePath, size);
            this._nextArcOffset = Arrays.copyOf(this._nextArcOffset, size);
            for (int i = p; i < size; ++i) {
                int newState;
                this._nextArcOffset[i] = newState = this.allocateState(256);
                this._activePath[i] = newState;
            }
        }
    }

    private void expandBuffers() {
        if (this._serialized.length < this._size + 1536) {
            this._serialized = Arrays.copyOf(this._serialized, this._serialized.length + this._bufferGrowthSize);
            ++this._serializationBufferReallocations;
        }
    }

    private int allocateState(int labels) {
        this.expandBuffers();
        int state = this._size;
        this._size += labels * 6;
        return state;
    }

    private boolean setPrevious(byte[] sequence, int start, int length) {
        if (this._previous == null || this._previous.length < length) {
            this._previous = new byte[length];
        }
        System.arraycopy(sequence, start, this._previous, 0, length);
        this._previousLength = length;
        return true;
    }

    public static enum InfoEntry {
        SERIALIZATION_BUFFER_SIZE("Serialization buffer size"),
        SERIALIZATION_BUFFER_REALLOCATIONS("Serialization buffer reallocs"),
        CONSTANT_ARC_AUTOMATON_SIZE("Constant arc FST size"),
        MAX_ACTIVE_PATH_LENGTH("Max active path"),
        STATE_REGISTRY_TABLE_SLOTS("Registry hash slots"),
        STATE_REGISTRY_SIZE("Registry hash entries"),
        ESTIMATED_MEMORY_CONSUMPTION_MB("Estimated mem consumption (MB)");

        private final String _stringified;

        private InfoEntry(String stringified) {
            this._stringified = stringified;
        }

        public String toString() {
            return this._stringified;
        }
    }
}

