/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.builder;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.io.Writer;
import java.util.BitSet;
import java.util.TreeMap;
import org.apache.pinot.segment.local.utils.nativefst.FST;
import org.apache.pinot.segment.local.utils.nativefst.FSTFlags;
import org.apache.pinot.segment.local.utils.nativefst.ImmutableFST;

final class FSTUtils {
    private FSTUtils() {
    }

    public static void toDot(Writer w, FST fst, int node) throws IOException {
        w.write("digraph Automaton {\n");
        w.write("  rankdir = LR;\n");
        BitSet visited = new BitSet();
        w.write("  stop [shape=doublecircle,label=\"\"];\n");
        w.write("  initial [shape=plaintext,label=\"\"];\n");
        w.write("  initial -> " + node + "\n\n");
        FSTUtils.visitNode(w, 0, fst, node, visited);
        w.write("}\n");
    }

    private static void visitNode(Writer w, int d, FST fst, int s, BitSet visited) throws IOException {
        visited.set(s);
        w.write("  ");
        w.write(Integer.toString(s));
        if (fst.getFlags().contains((Object)FSTFlags.NUMBERS)) {
            int nodeNumber = fst.getRightLanguageCount(s);
            w.write(" [shape=circle,label=\"" + nodeNumber + "\"];\n");
        } else {
            w.write(" [shape=circle,label=\"\"];\n");
        }
        int arc = fst.getFirstArc(s);
        while (arc != 0) {
            w.write("  ");
            w.write(Integer.toString(s));
            w.write(" -> ");
            if (fst.isArcTerminal(arc)) {
                w.write("stop");
            } else {
                w.write(Integer.toString(fst.getEndNode(arc)));
            }
            byte label = fst.getArcLabel(arc);
            w.write(" [label=\"");
            if (Character.isLetterOrDigit(label)) {
                w.write((char)label);
            } else {
                w.write("0x");
                w.write(Integer.toHexString(label & 0xFF));
            }
            w.write("\"");
            if (fst.isArcFinal(arc)) {
                w.write(" arrowhead=\"tee\"");
            }
            if (fst instanceof ImmutableFST && ((ImmutableFST)fst).isNextSet(arc)) {
                w.write(" color=\"blue\"");
            }
            w.write("]\n");
            arc = fst.getNextArc(arc);
        }
        arc = fst.getFirstArc(s);
        while (arc != 0) {
            int endNode;
            if (!fst.isArcTerminal(arc) && !visited.get(endNode = fst.getEndNode(arc))) {
                FSTUtils.visitNode(w, d + 1, fst, endNode, visited);
            }
            arc = fst.getNextArc(arc);
        }
    }

    public static TreeMap<Integer, Integer> calculateFanOuts(FST fst) {
        int high;
        int[] result = new int[256];
        fst.visitInPreOrder(state -> {
            int count = 0;
            int arc = fst.getFirstArc(state);
            while (arc != 0) {
                ++count;
                arc = fst.getNextArc(arc);
            }
            int n = count;
            result[n] = result[n] + 1;
            return true;
        });
        TreeMap<Integer, Integer> output = new TreeMap<Integer, Integer>();
        for (int low = 1; low < result.length && result[low] == 0; ++low) {
        }
        for (high = result.length - 1; high >= 0 && result[high] == 0; --high) {
        }
        for (int i = low; i <= high; ++i) {
            output.put(i, result[i]);
        }
        return output;
    }

    public static Int2IntOpenHashMap rightLanguageForAllStates(FST fst) {
        Int2IntOpenHashMap numbers = new Int2IntOpenHashMap();
        fst.visitInPostOrder(state -> {
            int thisNodeNumber = 0;
            int arc = fst.getFirstArc(state);
            while (arc != 0) {
                thisNodeNumber += (fst.isArcFinal(arc) ? 1 : 0) + (fst.isArcTerminal(arc) ? 0 : numbers.get(fst.getEndNode(arc)));
                arc = fst.getNextArc(arc);
            }
            numbers.put(state, thisNodeNumber);
            return true;
        });
        return numbers;
    }
}

