/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.indexsegment.immutable;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.segment.local.dedup.PartitionDedupMetadataManager;
import org.apache.pinot.segment.local.segment.index.datasource.ImmutableDataSource;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeIndexContainer;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.mutable.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableSegmentImpl
implements ImmutableSegment {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableSegmentImpl.class);
    private final SegmentDirectory _segmentDirectory;
    private final SegmentMetadataImpl _segmentMetadata;
    private final Map<String, ColumnIndexContainer> _indexContainerMap;
    private final StarTreeIndexContainer _starTreeIndexContainer;
    private final Map<String, DataSource> _dataSources;
    private PartitionDedupMetadataManager _partitionDedupMetadataManager;
    private PartitionUpsertMetadataManager _partitionUpsertMetadataManager;
    private ThreadSafeMutableRoaringBitmap _validDocIds;
    private PinotSegmentRecordReader _pinotSegmentRecordReader;

    public ImmutableSegmentImpl(SegmentDirectory segmentDirectory, SegmentMetadataImpl segmentMetadata, Map<String, ColumnIndexContainer> columnIndexContainerMap, @Nullable StarTreeIndexContainer starTreeIndexContainer) {
        this._segmentDirectory = segmentDirectory;
        this._segmentMetadata = segmentMetadata;
        this._indexContainerMap = columnIndexContainerMap;
        this._starTreeIndexContainer = starTreeIndexContainer;
        this._dataSources = new HashMap<String, DataSource>(HashUtil.getHashMapCapacity((int)segmentMetadata.getColumnMetadataMap().size()));
        for (Map.Entry entry : segmentMetadata.getColumnMetadataMap().entrySet()) {
            String colName = (String)entry.getKey();
            this._dataSources.put(colName, new ImmutableDataSource((ColumnMetadata)entry.getValue(), this._indexContainerMap.get(colName)));
        }
    }

    public void enableDedup(PartitionDedupMetadataManager partitionDedupMetadataManager) {
        this._partitionDedupMetadataManager = partitionDedupMetadataManager;
    }

    public void enableUpsert(PartitionUpsertMetadataManager partitionUpsertMetadataManager, ThreadSafeMutableRoaringBitmap validDocIds) {
        this._partitionUpsertMetadataManager = partitionUpsertMetadataManager;
        this._validDocIds = validDocIds;
    }

    public Dictionary getDictionary(String column) {
        ColumnIndexContainer container = this._indexContainerMap.get(column);
        if (container == null) {
            throw new NullPointerException("Invalid column: " + column);
        }
        return container.getDictionary();
    }

    public ForwardIndexReader getForwardIndex(String column) {
        return this._indexContainerMap.get(column).getForwardIndex();
    }

    public InvertedIndexReader getInvertedIndex(String column) {
        return this._indexContainerMap.get(column).getInvertedIndex();
    }

    public long getSegmentSizeBytes() {
        return this._segmentDirectory.getDiskSizeBytes();
    }

    @Nullable
    public String getTier() {
        return this._segmentDirectory.getTier();
    }

    public String getSegmentName() {
        return this._segmentMetadata.getName();
    }

    public SegmentMetadataImpl getSegmentMetadata() {
        return this._segmentMetadata;
    }

    public DataSource getDataSource(String column) {
        DataSource result = this._dataSources.get(column);
        Preconditions.checkNotNull((Object)result, (String)"DataSource for %s should not be null. Potentially invalid column name specified.", (Object)column);
        return result;
    }

    public Set<String> getColumnNames() {
        return this._segmentMetadata.getSchema().getColumnNames();
    }

    public Set<String> getPhysicalColumnNames() {
        return this._segmentMetadata.getSchema().getPhysicalColumnNames();
    }

    public void prefetch(FetchContext fetchContext) {
        this._segmentDirectory.prefetch(fetchContext);
    }

    public void acquire(FetchContext fetchContext) {
        this._segmentDirectory.acquire(fetchContext);
    }

    public void release(FetchContext fetchContext) {
        this._segmentDirectory.release(fetchContext);
    }

    public void destroy() {
        String segmentName = this.getSegmentName();
        LOGGER.info("Trying to destroy segment : {}", (Object)segmentName);
        if (this._partitionUpsertMetadataManager != null) {
            this._partitionUpsertMetadataManager.removeSegment((IndexSegment)this);
        }
        if (this._partitionDedupMetadataManager != null) {
            this._partitionDedupMetadataManager.removeSegment((IndexSegment)this);
        }
        for (Map.Entry<String, ColumnIndexContainer> entry : this._indexContainerMap.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close indexes for column: {}. Continuing with error.", (Object)entry.getKey(), (Object)e);
            }
        }
        try {
            this._segmentDirectory.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to close segment directory: {}. Continuing with error.", (Object)this._segmentDirectory, (Object)e);
        }
        if (this._starTreeIndexContainer != null) {
            try {
                this._starTreeIndexContainer.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close star-tree. Continuing with error.", (Throwable)e);
            }
        }
        if (this._pinotSegmentRecordReader != null) {
            try {
                this._pinotSegmentRecordReader.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close record reader. Continuing with error.", (Throwable)e);
            }
        }
    }

    public List<StarTreeV2> getStarTrees() {
        return this._starTreeIndexContainer != null ? this._starTreeIndexContainer.getStarTrees() : null;
    }

    @Nullable
    public ThreadSafeMutableRoaringBitmap getValidDocIds() {
        return this._validDocIds;
    }

    public GenericRow getRecord(int docId, GenericRow reuse) {
        try {
            if (this._pinotSegmentRecordReader == null) {
                this._pinotSegmentRecordReader = new PinotSegmentRecordReader();
                this._pinotSegmentRecordReader.init(this);
            }
            this._pinotSegmentRecordReader.getRecord(reuse, docId);
            return reuse;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to use PinotSegmentRecordReader to read immutable segment");
        }
    }

    public Object getValue(int docId, String column) {
        try {
            if (this._pinotSegmentRecordReader == null) {
                this._pinotSegmentRecordReader = new PinotSegmentRecordReader();
                this._pinotSegmentRecordReader.init(this);
            }
            return this._pinotSegmentRecordReader.getValue(docId, column);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to use PinotSegmentRecordReader to read value from immutable segment");
        }
    }
}

