/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.indexsegment.mutable;

import org.apache.pinot.segment.local.realtime.impl.dictionary.MutableDictionaryFactory;
import org.apache.pinot.segment.local.realtime.impl.forward.FixedByteMVMutableForwardIndex;
import org.apache.pinot.segment.local.realtime.impl.forward.FixedByteSVMutableForwardIndex;
import org.apache.pinot.segment.local.realtime.impl.forward.VarByteSVMutableForwardIndex;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeInvertedIndex;
import org.apache.pinot.segment.local.realtime.impl.json.MutableJsonIndexImpl;
import org.apache.pinot.segment.spi.index.mutable.MutableDictionary;
import org.apache.pinot.segment.spi.index.mutable.MutableForwardIndex;
import org.apache.pinot.segment.spi.index.mutable.MutableInvertedIndex;
import org.apache.pinot.segment.spi.index.mutable.MutableJsonIndex;
import org.apache.pinot.segment.spi.index.mutable.MutableTextIndex;
import org.apache.pinot.segment.spi.index.mutable.provider.MutableIndexContext;
import org.apache.pinot.segment.spi.index.mutable.provider.MutableIndexProvider;
import org.apache.pinot.spi.data.FieldSpec;

public class DefaultMutableIndexProvider
implements MutableIndexProvider {
    private static final int MAX_MULTI_VALUES_PER_ROW = 1000;
    private static final int NODICT_VARIABLE_WIDTH_ESTIMATED_AVERAGE_VALUE_LENGTH_DEFAULT = 100;
    private static final int NODICT_VARIABLE_WIDTH_ESTIMATED_NUMBER_OF_VALUES_DEFAULT = 100000;

    public MutableForwardIndex newForwardIndex(MutableIndexContext.Forward context) {
        String column = context.getFieldSpec().getName();
        String segmentName = context.getSegmentName();
        FieldSpec.DataType storedType = context.getFieldSpec().getDataType().getStoredType();
        boolean isSingleValue = context.getFieldSpec().isSingleValueField();
        if (!context.hasDictionary()) {
            if (isSingleValue) {
                String allocationContext = DefaultMutableIndexProvider.buildAllocationContext(context.getSegmentName(), context.getFieldSpec().getName(), ".sv.raw.fwd");
                if (storedType.isFixedWidth()) {
                    return new FixedByteSVMutableForwardIndex(false, storedType, context.getCapacity(), context.getMemoryManager(), allocationContext);
                }
                int initialCapacity = Math.min(context.getCapacity(), 100000);
                return new VarByteSVMutableForwardIndex(storedType, context.getMemoryManager(), allocationContext, initialCapacity, 100);
            }
            assert (storedType.isFixedWidth());
            String allocationContext = DefaultMutableIndexProvider.buildAllocationContext(context.getSegmentName(), context.getFieldSpec().getName(), ".mv.raw.fwd");
            return new FixedByteMVMutableForwardIndex(1000, context.getAvgNumMultiValues(), context.getCapacity(), storedType.size(), context.getMemoryManager(), allocationContext, false, storedType);
        }
        if (isSingleValue) {
            String allocationContext = DefaultMutableIndexProvider.buildAllocationContext(segmentName, column, ".sv.unsorted.fwd");
            return new FixedByteSVMutableForwardIndex(true, FieldSpec.DataType.INT, context.getCapacity(), context.getMemoryManager(), allocationContext);
        }
        String allocationContext = DefaultMutableIndexProvider.buildAllocationContext(segmentName, column, ".mv.fwd");
        return new FixedByteMVMutableForwardIndex(1000, context.getAvgNumMultiValues(), context.getCapacity(), 4, context.getMemoryManager(), allocationContext, true, FieldSpec.DataType.INT);
    }

    public MutableInvertedIndex newInvertedIndex(MutableIndexContext.Inverted context) {
        return new RealtimeInvertedIndex();
    }

    public MutableJsonIndex newJsonIndex(MutableIndexContext.Json context) {
        return new MutableJsonIndexImpl();
    }

    public MutableTextIndex newTextIndex(MutableIndexContext.Text context) {
        return null;
    }

    public MutableDictionary newDictionary(MutableIndexContext.Dictionary context) {
        String column = context.getFieldSpec().getName();
        String segmentName = context.getSegmentName();
        FieldSpec.DataType storedType = context.getFieldSpec().getDataType().getStoredType();
        int dictionaryColumnSize = storedType.isFixedWidth() ? storedType.size() : context.getEstimatedColSize();
        int estimatedCardinality = (int)((double)context.getEstimatedCardinality() * 1.1);
        String dictionaryAllocationContext = DefaultMutableIndexProvider.buildAllocationContext(segmentName, column, ".dict");
        return MutableDictionaryFactory.getMutableDictionary(storedType, context.isOffHeap(), context.getMemoryManager(), dictionaryColumnSize, Math.min(estimatedCardinality, context.getCapacity()), dictionaryAllocationContext);
    }

    private static String buildAllocationContext(String segmentName, String columnName, String indexType) {
        return segmentName + ":" + columnName + indexType;
    }
}

