/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.inv.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.spi.index.creator.JsonIndexCreator;
import org.apache.pinot.segment.spi.memory.CleanerUtil;
import org.apache.pinot.spi.utils.JsonUtils;
import org.roaringbitmap.Container;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.RoaringBitmapWriter;

public abstract class BaseJsonIndexCreator
implements JsonIndexCreator {
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int HEADER_LENGTH = 32;
    static final String TEMP_DIR_SUFFIX = ".json.idx.tmp";
    static final String DICTIONARY_FILE_NAME = "dictionary.buf";
    static final String INVERTED_INDEX_FILE_NAME = "inverted.index.buf";
    final File _indexFile;
    final File _tempDir;
    final File _dictionaryFile;
    final File _invertedIndexFile;
    final IntList _numFlattenedRecordsList = new IntArrayList();
    final Map<String, RoaringBitmapWriter<RoaringBitmap>> _postingListMap = new TreeMap<String, RoaringBitmapWriter<RoaringBitmap>>();
    final RoaringBitmapWriter.Wizard<Container, RoaringBitmap> _bitmapWriterWizard = RoaringBitmapWriter.writer();
    int _nextFlattenedDocId;
    int _maxValueLength;

    BaseJsonIndexCreator(File indexDir, String columnName) throws IOException {
        this._indexFile = new File(indexDir, columnName + ".json.idx");
        this._tempDir = new File(indexDir, columnName + TEMP_DIR_SUFFIX);
        if (this._tempDir.exists()) {
            FileUtils.cleanDirectory((File)this._tempDir);
        } else {
            FileUtils.forceMkdir((File)this._tempDir);
        }
        this._dictionaryFile = new File(this._tempDir, DICTIONARY_FILE_NAME);
        this._invertedIndexFile = new File(this._tempDir, INVERTED_INDEX_FILE_NAME);
    }

    public void add(String jsonString) throws IOException {
        this.addFlattenedRecords(JsonUtils.flatten((JsonNode)JsonUtils.stringToJsonNode((String)jsonString)));
    }

    void addFlattenedRecords(List<Map<String, String>> records) throws IOException {
        int numRecords = records.size();
        Preconditions.checkState((this._nextFlattenedDocId + numRecords >= 0 ? 1 : 0) != 0, (String)"Got more than %s flattened records", (int)Integer.MAX_VALUE);
        this._numFlattenedRecordsList.add(numRecords);
        for (Map<String, String> record : records) {
            for (Map.Entry<String, String> entry : record.entrySet()) {
                String key = entry.getKey();
                this.addToPostingList(key);
                String keyValue = key + "\u0000" + entry.getValue();
                this.addToPostingList(keyValue);
            }
            ++this._nextFlattenedDocId;
        }
    }

    void addToPostingList(String value) {
        RoaringBitmapWriter bitmapWriter = this._postingListMap.get(value);
        if (bitmapWriter == null) {
            bitmapWriter = this._bitmapWriterWizard.get();
            this._postingListMap.put(value, (RoaringBitmapWriter<RoaringBitmap>)bitmapWriter);
        }
        bitmapWriter.add(this._nextFlattenedDocId);
    }

    void generateIndexFile() throws IOException {
        ByteBuffer headerBuffer = ByteBuffer.allocate(32);
        headerBuffer.putInt(2);
        headerBuffer.putInt(this._maxValueLength);
        long dictionaryFileLength = this._dictionaryFile.length();
        long invertedIndexFileLength = this._invertedIndexFile.length();
        long docIdMappingFileLength = (long)this._nextFlattenedDocId << 2;
        headerBuffer.putLong(dictionaryFileLength);
        headerBuffer.putLong(invertedIndexFileLength);
        headerBuffer.putLong(docIdMappingFileLength);
        headerBuffer.position(0);
        try (FileChannel indexFileChannel = new RandomAccessFile(this._indexFile, "rw").getChannel();
             FileChannel dictionaryFileChannel = new RandomAccessFile(this._dictionaryFile, "r").getChannel();
             FileChannel invertedIndexFileChannel = new RandomAccessFile(this._invertedIndexFile, "r").getChannel();){
            indexFileChannel.write(headerBuffer);
            dictionaryFileChannel.transferTo(0L, dictionaryFileLength, indexFileChannel);
            invertedIndexFileChannel.transferTo(0L, invertedIndexFileLength, indexFileChannel);
            ByteBuffer docIdMappingBuffer = indexFileChannel.map(FileChannel.MapMode.READ_WRITE, indexFileChannel.position(), docIdMappingFileLength).order(ByteOrder.LITTLE_ENDIAN);
            int numDocs = this._numFlattenedRecordsList.size();
            for (int i = 0; i < numDocs; ++i) {
                int numRecords = this._numFlattenedRecordsList.getInt(i);
                for (int j = 0; j < numRecords; ++j) {
                    docIdMappingBuffer.putInt(i);
                }
            }
            if (CleanerUtil.UNMAP_SUPPORTED) {
                CleanerUtil.BufferCleaner cleaner = CleanerUtil.getCleaner();
                cleaner.freeBuffer(docIdMappingBuffer);
            }
        }
    }

    public void close() throws IOException {
        FileUtils.deleteDirectory((File)this._tempDir);
    }
}

