/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.bloomfilter;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.loader.IndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.local.segment.index.readers.BytesDictionary;
import org.apache.pinot.segment.local.segment.index.readers.DoubleDictionary;
import org.apache.pinot.segment.local.segment.index.readers.FloatDictionary;
import org.apache.pinot.segment.local.segment.index.readers.IntDictionary;
import org.apache.pinot.segment.local.segment.index.readers.LongDictionary;
import org.apache.pinot.segment.local.segment.index.readers.StringDictionary;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.BloomFilterCreatorProvider;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.IndexCreatorProvider;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.creator.BloomFilterCreator;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.BloomFilterConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BytesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterHandler
implements IndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BloomFilterHandler.class);
    private final SegmentMetadata _segmentMetadata;
    private final Map<String, BloomFilterConfig> _bloomFilterConfigs;

    public BloomFilterHandler(SegmentMetadata segmentMetadata, IndexLoadingConfig indexLoadingConfig) {
        this._segmentMetadata = segmentMetadata;
        this._bloomFilterConfigs = indexLoadingConfig.getBloomFilterConfigs();
    }

    @Override
    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentMetadata.getName();
        HashSet<String> columnsToAddBF = new HashSet<String>(this._bloomFilterConfigs.keySet());
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.BLOOM_FILTER);
        for (String column : existingColumns) {
            if (columnsToAddBF.remove(column)) continue;
            LOGGER.info("Need to remove existing bloom filter from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : columnsToAddBF) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateBloomFilter(columnMetadata)) continue;
            LOGGER.info("Need to create new bloom filter for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    @Override
    public void updateIndices(SegmentDirectory.Writer segmentWriter, IndexCreatorProvider indexCreatorProvider) throws Exception {
        HashSet<String> columnsToAddBF = new HashSet<String>(this._bloomFilterConfigs.keySet());
        String segmentName = this._segmentMetadata.getName();
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.BLOOM_FILTER);
        for (String column : existingColumns) {
            if (columnsToAddBF.remove(column)) continue;
            LOGGER.info("Removing existing bloom filter from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, ColumnIndexType.BLOOM_FILTER);
            LOGGER.info("Removed existing bloom filter from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : columnsToAddBF) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateBloomFilter(columnMetadata)) continue;
            this.createBloomFilterForColumn(segmentWriter, columnMetadata, (BloomFilterCreatorProvider)indexCreatorProvider);
        }
    }

    private boolean shouldCreateBloomFilter(ColumnMetadata columnMetadata) {
        return columnMetadata != null;
    }

    private void createAndSealBloomFilterForDictionaryColumn(BloomFilterCreatorProvider indexCreatorProvider, File indexDir, ColumnMetadata columnMetadata, BloomFilterConfig bloomFilterConfig, SegmentDirectory.Writer segmentWriter) throws Exception {
        try (BloomFilterCreator bloomFilterCreator = indexCreatorProvider.newBloomFilterCreator(IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build().forBloomFilter(bloomFilterConfig));
             BaseImmutableDictionary dictionary = this.getDictionaryReader(columnMetadata, segmentWriter);){
            int length = dictionary.length();
            for (int i = 0; i < length; ++i) {
                bloomFilterCreator.add(dictionary.getStringValue(i));
            }
            bloomFilterCreator.seal();
        }
    }

    private void createAndSealBloomFilterForNonDictionaryColumn(BloomFilterCreatorProvider indexCreatorProvider, File indexDir, ColumnMetadata columnMetadata, BloomFilterConfig bloomFilterConfig, SegmentDirectory.Writer segmentWriter) throws Exception {
        int numDocs = columnMetadata.getTotalDocs();
        try (BloomFilterCreator bloomFilterCreator = indexCreatorProvider.newBloomFilterCreator(IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build().forBloomFilter(bloomFilterConfig));
             ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();){
            if (columnMetadata.isSingleValue()) {
                switch (columnMetadata.getDataType()) {
                    case INT: {
                        for (int i = 0; i < numDocs; ++i) {
                            bloomFilterCreator.add(Integer.toString(forwardIndexReader.getInt(i, readerContext)));
                        }
                        break;
                    }
                    case LONG: {
                        for (int i = 0; i < numDocs; ++i) {
                            bloomFilterCreator.add(Long.toString(forwardIndexReader.getLong(i, readerContext)));
                        }
                        break;
                    }
                    case FLOAT: {
                        for (int i = 0; i < numDocs; ++i) {
                            bloomFilterCreator.add(Float.toString(forwardIndexReader.getFloat(i, readerContext)));
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (int i = 0; i < numDocs; ++i) {
                            bloomFilterCreator.add(Double.toString(forwardIndexReader.getDouble(i, readerContext)));
                        }
                        break;
                    }
                    case STRING: {
                        for (int i = 0; i < numDocs; ++i) {
                            bloomFilterCreator.add(forwardIndexReader.getString(i, readerContext));
                        }
                        break;
                    }
                    case BYTES: {
                        for (int i = 0; i < numDocs; ++i) {
                            bloomFilterCreator.add(BytesUtils.toHexString((byte[])forwardIndexReader.getBytes(i, readerContext)));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported data type: " + columnMetadata.getDataType() + " for column: " + columnMetadata.getColumnName());
                    }
                }
                bloomFilterCreator.seal();
            } else {
                switch (columnMetadata.getDataType()) {
                    case INT: {
                        for (int i = 0; i < numDocs; ++i) {
                            int[] buffer = new int[columnMetadata.getMaxNumberOfMultiValues()];
                            int length = forwardIndexReader.getIntMV(i, buffer, readerContext);
                            for (int j = 0; j < length; ++j) {
                                bloomFilterCreator.add(Integer.toString(buffer[j]));
                            }
                        }
                        break;
                    }
                    case LONG: {
                        for (int i = 0; i < numDocs; ++i) {
                            long[] buffer = new long[columnMetadata.getMaxNumberOfMultiValues()];
                            int length = forwardIndexReader.getLongMV(i, buffer, readerContext);
                            for (int j = 0; j < length; ++j) {
                                bloomFilterCreator.add(Long.toString(buffer[j]));
                            }
                        }
                        break;
                    }
                    case FLOAT: {
                        for (int i = 0; i < numDocs; ++i) {
                            float[] buffer = new float[columnMetadata.getMaxNumberOfMultiValues()];
                            int length = forwardIndexReader.getFloatMV(i, buffer, readerContext);
                            for (int j = 0; j < length; ++j) {
                                bloomFilterCreator.add(Float.toString(buffer[j]));
                            }
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (int i = 0; i < numDocs; ++i) {
                            double[] buffer = new double[columnMetadata.getMaxNumberOfMultiValues()];
                            int length = forwardIndexReader.getDoubleMV(i, buffer, readerContext);
                            for (int j = 0; j < length; ++j) {
                                bloomFilterCreator.add(Double.toString(buffer[j]));
                            }
                        }
                        break;
                    }
                    case STRING: {
                        for (int i = 0; i < numDocs; ++i) {
                            String[] buffer = new String[columnMetadata.getMaxNumberOfMultiValues()];
                            int length = forwardIndexReader.getStringMV(i, buffer, readerContext);
                            for (int j = 0; j < length; ++j) {
                                bloomFilterCreator.add(buffer[j]);
                            }
                        }
                        break;
                    }
                    case BYTES: {
                        for (int i = 0; i < numDocs; ++i) {
                            byte[][] buffer = new byte[columnMetadata.getMaxNumberOfMultiValues()][];
                            int length = forwardIndexReader.getBytesMV(i, (byte[][])buffer, readerContext);
                            for (int j = 0; j < length; ++j) {
                                bloomFilterCreator.add(BytesUtils.toHexString((byte[])buffer[j]));
                            }
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported data type: " + columnMetadata.getDataType() + " for column: " + columnMetadata.getColumnName());
                    }
                }
                bloomFilterCreator.seal();
            }
        }
    }

    private void createBloomFilterForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, BloomFilterCreatorProvider indexCreatorProvider) throws Exception {
        File indexDir = this._segmentMetadata.getIndexDir();
        String segmentName = this._segmentMetadata.getName();
        String columnName = columnMetadata.getColumnName();
        File bloomFilterFileInProgress = new File(indexDir, columnName + ".bloom.inprogress");
        File bloomFilterFile = new File(indexDir, columnName + ".bloom");
        if (!bloomFilterFileInProgress.exists()) {
            FileUtils.touch((File)bloomFilterFileInProgress);
        } else {
            FileUtils.deleteQuietly((File)bloomFilterFile);
        }
        BloomFilterConfig bloomFilterConfig = this._bloomFilterConfigs.get(columnName);
        LOGGER.info("Creating new bloom filter for segment: {}, column: {} with config: {}", new Object[]{segmentName, columnName, bloomFilterConfig});
        if (columnMetadata.hasDictionary()) {
            this.createAndSealBloomFilterForDictionaryColumn(indexCreatorProvider, indexDir, columnMetadata, bloomFilterConfig, segmentWriter);
        } else {
            this.createAndSealBloomFilterForNonDictionaryColumn(indexCreatorProvider, indexDir, columnMetadata, bloomFilterConfig, segmentWriter);
        }
        if (this._segmentMetadata.getVersion() == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(segmentWriter, columnName, bloomFilterFile, ColumnIndexType.BLOOM_FILTER);
        }
        FileUtils.deleteQuietly((File)bloomFilterFileInProgress);
        LOGGER.info("Created bloom filter for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
    }

    private BaseImmutableDictionary getDictionaryReader(ColumnMetadata columnMetadata, SegmentDirectory.Writer segmentWriter) throws IOException {
        PinotDataBuffer dictionaryBuffer = segmentWriter.getIndexFor(columnMetadata.getColumnName(), ColumnIndexType.DICTIONARY);
        int cardinality = columnMetadata.getCardinality();
        FieldSpec.DataType dataType = columnMetadata.getDataType();
        switch (dataType) {
            case INT: {
                return new IntDictionary(dictionaryBuffer, cardinality);
            }
            case LONG: {
                return new LongDictionary(dictionaryBuffer, cardinality);
            }
            case FLOAT: {
                return new FloatDictionary(dictionaryBuffer, cardinality);
            }
            case DOUBLE: {
                return new DoubleDictionary(dictionaryBuffer, cardinality);
            }
            case STRING: {
                return new StringDictionary(dictionaryBuffer, cardinality, columnMetadata.getColumnMaxLength(), (byte)columnMetadata.getPaddingCharacter());
            }
            case BYTES: {
                return new BytesDictionary(dictionaryBuffer, cardinality, columnMetadata.getColumnMaxLength());
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType + " for column: " + columnMetadata.getColumnName());
    }
}

