/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue;

import com.google.common.base.Preconditions;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.segment.local.segment.index.readers.BytesDictionary;
import org.apache.pinot.segment.local.segment.index.readers.DoubleDictionary;
import org.apache.pinot.segment.local.segment.index.readers.FloatDictionary;
import org.apache.pinot.segment.local.segment.index.readers.IntDictionary;
import org.apache.pinot.segment.local.segment.index.readers.LongDictionary;
import org.apache.pinot.segment.local.segment.index.readers.StringDictionary;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class ColumnMinMaxValueGenerator {
    private final SegmentMetadataImpl _segmentMetadata;
    private final PropertiesConfiguration _segmentProperties;
    private final SegmentDirectory.Writer _segmentWriter;
    private final ColumnMinMaxValueGeneratorMode _columnMinMaxValueGeneratorMode;
    private boolean _minMaxValueAdded;

    public ColumnMinMaxValueGenerator(SegmentMetadataImpl segmentMetadata, SegmentDirectory.Writer segmentWriter, ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode) {
        this._segmentMetadata = segmentMetadata;
        this._segmentWriter = segmentWriter;
        this._segmentProperties = segmentMetadata.getPropertiesConfiguration();
        this._columnMinMaxValueGeneratorMode = columnMinMaxValueGeneratorMode;
    }

    public boolean needAddColumnMinMaxValue() {
        for (String column : this.getColumnsToAddMinMaxValue()) {
            if (!this.needAddColumnMinMaxValueForColumn(column)) continue;
            return true;
        }
        return false;
    }

    public void addColumnMinMaxValue() throws Exception {
        Preconditions.checkState((this._columnMinMaxValueGeneratorMode != ColumnMinMaxValueGeneratorMode.NONE ? 1 : 0) != 0);
        for (String column : this.getColumnsToAddMinMaxValue()) {
            this.addColumnMinMaxValueForColumn(column);
        }
        this.saveMetadata();
    }

    private Set<String> getColumnsToAddMinMaxValue() {
        Schema schema = this._segmentMetadata.getSchema();
        HashSet<String> columnsToAddMinMaxValue = new HashSet<String>(schema.getPhysicalColumnNames());
        switch (this._columnMinMaxValueGeneratorMode) {
            case TIME: {
                columnsToAddMinMaxValue.removeAll(schema.getDimensionNames());
                columnsToAddMinMaxValue.removeAll(schema.getMetricNames());
                break;
            }
            case NON_METRIC: {
                columnsToAddMinMaxValue.removeAll(schema.getMetricNames());
                break;
            }
        }
        return columnsToAddMinMaxValue;
    }

    private boolean needAddColumnMinMaxValueForColumn(String columnName) {
        ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(columnName);
        return columnMetadata.hasDictionary() && columnMetadata.getMinValue() == null && columnMetadata.getMaxValue() == null;
    }

    private void addColumnMinMaxValueForColumn(String columnName) throws Exception {
        ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(columnName);
        if (!columnMetadata.hasDictionary() || columnMetadata.getMinValue() != null || columnMetadata.getMaxValue() != null) {
            return;
        }
        PinotDataBuffer dictionaryBuffer = this._segmentWriter.getIndexFor(columnName, ColumnIndexType.DICTIONARY);
        FieldSpec.DataType dataType = columnMetadata.getDataType().getStoredType();
        int length = columnMetadata.getCardinality();
        switch (dataType) {
            case INT: {
                try (IntDictionary intDictionary = new IntDictionary(dictionaryBuffer, length);){
                    SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, intDictionary.getStringValue(0), intDictionary.getStringValue(length - 1));
                    break;
                }
            }
            case LONG: {
                try (LongDictionary longDictionary = new LongDictionary(dictionaryBuffer, length);){
                    SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, longDictionary.getStringValue(0), longDictionary.getStringValue(length - 1));
                    break;
                }
            }
            case FLOAT: {
                try (FloatDictionary floatDictionary = new FloatDictionary(dictionaryBuffer, length);){
                    SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, floatDictionary.getStringValue(0), floatDictionary.getStringValue(length - 1));
                    break;
                }
            }
            case DOUBLE: {
                try (DoubleDictionary doubleDictionary = new DoubleDictionary(dictionaryBuffer, length);){
                    SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, doubleDictionary.getStringValue(0), doubleDictionary.getStringValue(length - 1));
                    break;
                }
            }
            case STRING: {
                try (StringDictionary stringDictionary = new StringDictionary(dictionaryBuffer, length, columnMetadata.getColumnMaxLength(), (byte)columnMetadata.getPaddingCharacter());){
                    SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, stringDictionary.getStringValue(0), stringDictionary.getStringValue(length - 1));
                    break;
                }
            }
            case BYTES: {
                try (BytesDictionary bytesDictionary = new BytesDictionary(dictionaryBuffer, length, columnMetadata.getColumnMaxLength());){
                    SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, bytesDictionary.getStringValue(0), bytesDictionary.getStringValue(length - 1));
                    break;
                }
            }
            default: {
                throw new IllegalStateException("Unsupported data type: " + dataType + " for column: " + columnName);
            }
        }
        this._minMaxValueAdded = true;
    }

    private void saveMetadata() throws Exception {
        if (this._minMaxValueAdded) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(this._segmentProperties.getFile());){
                this._segmentProperties.save((OutputStream)fileOutputStream);
            }
        }
    }
}

