/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.loader.IndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.IndexCreatorProvider;
import org.apache.pinot.segment.spi.creator.JsonIndexCreatorProvider;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.creator.JsonIndexCreator;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonIndexHandler
implements IndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonIndexHandler.class);
    private final SegmentMetadata _segmentMetadata;
    private final HashSet<String> _columnsToAddIdx;

    public JsonIndexHandler(SegmentMetadata segmentMetadata, IndexLoadingConfig indexLoadingConfig) {
        this._segmentMetadata = segmentMetadata;
        this._columnsToAddIdx = new HashSet<String>(indexLoadingConfig.getJsonIndexColumns());
    }

    @Override
    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentMetadata.getName();
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.JSON_INDEX);
        for (String column : existingColumns) {
            if (this._columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Need to remove existing json index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : this._columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateJsonIndex(columnMetadata)) continue;
            LOGGER.info("Need to create new json index for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    @Override
    public void updateIndices(SegmentDirectory.Writer segmentWriter, IndexCreatorProvider indexCreatorProvider) throws Exception {
        String segmentName = this._segmentMetadata.getName();
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.JSON_INDEX);
        for (String column : existingColumns) {
            if (this._columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Removing existing json index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, ColumnIndexType.JSON_INDEX);
            LOGGER.info("Removed existing json index from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : this._columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateJsonIndex(columnMetadata)) continue;
            this.createJsonIndexForColumn(segmentWriter, columnMetadata, (JsonIndexCreatorProvider)indexCreatorProvider);
        }
    }

    private boolean shouldCreateJsonIndex(ColumnMetadata columnMetadata) {
        return columnMetadata != null;
    }

    private void createJsonIndexForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, JsonIndexCreatorProvider indexCreatorProvider) throws Exception {
        File indexDir = this._segmentMetadata.getIndexDir();
        String segmentName = this._segmentMetadata.getName();
        String columnName = columnMetadata.getColumnName();
        File inProgress = new File(indexDir, columnName + ".json.idx.inprogress");
        File jsonIndexFile = new File(indexDir, columnName + ".json.idx");
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)jsonIndexFile);
        }
        LOGGER.info("Creating new json index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
        Preconditions.checkState((columnMetadata.isSingleValue() && (columnMetadata.getDataType() == FieldSpec.DataType.STRING || columnMetadata.getDataType() == FieldSpec.DataType.JSON) ? 1 : 0) != 0, (Object)"Json index can only be applied to single-value STRING or JSON columns");
        if (columnMetadata.hasDictionary()) {
            this.handleDictionaryBasedColumn(segmentWriter, columnMetadata, indexCreatorProvider);
        } else {
            this.handleNonDictionaryBasedColumn(segmentWriter, columnMetadata, indexCreatorProvider);
        }
        if (this._segmentMetadata.getVersion() == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(segmentWriter, columnName, jsonIndexFile, ColumnIndexType.JSON_INDEX);
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created json index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
    }

    private void handleDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, JsonIndexCreatorProvider indexCreatorProvider) throws IOException {
        File indexDir = this._segmentMetadata.getIndexDir();
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             BaseImmutableDictionary dictionary = LoaderUtils.getDictionary((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             JsonIndexCreator jsonIndexCreator = indexCreatorProvider.newJsonIndexCreator(IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build().forJsonIndex());){
            int numDocs = columnMetadata.getTotalDocs();
            for (int i = 0; i < numDocs; ++i) {
                int dictId = forwardIndexReader.getDictId(i, readerContext);
                jsonIndexCreator.add(dictionary.getStringValue(dictId));
            }
            jsonIndexCreator.seal();
        }
    }

    private void handleNonDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, JsonIndexCreatorProvider indexCreatorProvider) throws IOException {
        File indexDir = this._segmentMetadata.getIndexDir();
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             JsonIndexCreator jsonIndexCreator = indexCreatorProvider.newJsonIndexCreator(IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build().forJsonIndex());){
            int numDocs = columnMetadata.getTotalDocs();
            for (int i = 0; i < numDocs; ++i) {
                jsonIndexCreator.add(forwardIndexReader.getString(i, readerContext));
            }
            jsonIndexCreator.seal();
        }
    }
}

