/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.store;

import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.config.table.FSTType;

public class TextIndexUtils {
    private TextIndexUtils() {
    }

    static void cleanupTextIndex(File segDir, String column) {
        File luceneIndexFile = new File(segDir, column + ".lucene.index");
        FileUtils.deleteQuietly((File)luceneIndexFile);
        File luceneMappingFile = new File(segDir, column + ".lucene.mapping");
        FileUtils.deleteQuietly((File)luceneMappingFile);
        File nativeIndexFile = new File(segDir, column + ".nativetext.idx");
        FileUtils.deleteQuietly((File)nativeIndexFile);
    }

    static boolean hasTextIndex(File segDir, String column) {
        return new File(segDir, column + ".lucene.index").exists() || new File(segDir, column + ".nativetext.idx").exists();
    }

    public static boolean isFstTypeNative(@Nullable Map<String, String> textIndexProperties) {
        if (textIndexProperties == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : textIndexProperties.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase("fstType")) continue;
            return entry.getValue().equalsIgnoreCase("native");
        }
        return false;
    }

    public static FSTType getFSTTypeOfIndex(File indexDir, String column) {
        return SegmentDirectoryPaths.findTextIndexIndexFile((File)indexDir, (String)column) != null ? FSTType.LUCENE : FSTType.NATIVE;
    }
}

