/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.segment.local.upsert.merger.PartialUpsertMerger;
import org.apache.pinot.segment.local.upsert.merger.PartialUpsertMergerFactory;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class PartialUpsertHandler {
    private final Map<String, PartialUpsertMerger> _column2Mergers = new HashMap<String, PartialUpsertMerger>();

    public PartialUpsertHandler(Schema schema, Map<String, UpsertConfig.Strategy> partialUpsertStrategies, UpsertConfig.Strategy defaultPartialUpsertStrategy, String comparisonColumn) {
        for (Map.Entry<String, UpsertConfig.Strategy> entry : partialUpsertStrategies.entrySet()) {
            this._column2Mergers.put(entry.getKey(), PartialUpsertMergerFactory.getMerger(entry.getValue()));
        }
        for (String columnName : schema.getPhysicalColumnNames()) {
            if (schema.getPrimaryKeyColumns().contains(columnName) || this._column2Mergers.containsKey(columnName) || comparisonColumn.equals(columnName)) continue;
            this._column2Mergers.put(columnName, PartialUpsertMergerFactory.getMerger(defaultPartialUpsertStrategy));
        }
    }

    public GenericRow merge(GenericRow previousRecord, GenericRow newRecord) {
        for (Map.Entry<String, PartialUpsertMerger> entry : this._column2Mergers.entrySet()) {
            String column = entry.getKey();
            if (previousRecord.isNullValue(column)) continue;
            if (newRecord.isNullValue(column)) {
                newRecord.putValue(column, previousRecord.getValue(column));
                newRecord.removeNullValueField(column);
                continue;
            }
            newRecord.putValue(column, entry.getValue().merge(previousRecord.getValue(column), newRecord.getValue(column)));
        }
        return newRecord;
    }
}

