/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.uber.h3core.H3CoreV3;
import com.uber.h3core.util.LatLng;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class H3Utils {
    public static final H3CoreV3 H3_CORE;

    private H3Utils() {
    }

    private static LongSet coverLineInH3(LineString lineString, int resolution) {
        LongOpenHashSet coveringH3Cells = new LongOpenHashSet();
        LongArrayList endpointH3Cells = new LongArrayList();
        for (Coordinate endpoint : lineString.getCoordinates()) {
            endpointH3Cells.add(H3_CORE.geoToH3(endpoint.y, endpoint.x, resolution));
        }
        for (int i = 0; i < endpointH3Cells.size() - 1; ++i) {
            try {
                coveringH3Cells.addAll((Collection)H3_CORE.h3Line(endpointH3Cells.getLong(i), endpointH3Cells.getLong(i + 1)));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return coveringH3Cells;
    }

    private static Pair<LongSet, LongSet> coverPolygonInH3(Polygon polygon, int resolution) {
        List polyfillCells = H3_CORE.polyfill(Arrays.stream(polygon.getExteriorRing().getCoordinates()).map(coordinate -> new LatLng(coordinate.y, coordinate.x)).collect(Collectors.toList()), Collections.emptyList(), resolution);
        LongOpenHashSet potentialH3Cells = new LongOpenHashSet();
        if (polyfillCells.isEmpty()) {
            Coordinate represent = polygon.getCoordinate();
            potentialH3Cells.add(H3_CORE.geoToH3(represent.getY(), represent.getX(), resolution));
        } else {
            potentialH3Cells.addAll((Collection)polyfillCells);
        }
        LongOpenHashSet fullyContainedCell = new LongOpenHashSet((Collection)potentialH3Cells.stream().filter(h3Cell -> polygon.contains((Geometry)H3Utils.createPolygonFromH3Cell(h3Cell))).collect(Collectors.toSet()));
        potentialH3Cells.addAll((Collection)potentialH3Cells.stream().flatMap(cell -> H3_CORE.kRing(cell.longValue(), 1).stream()).collect(Collectors.toSet()));
        return Pair.of((Object)fullyContainedCell, (Object)potentialH3Cells);
    }

    private static Polygon createPolygonFromH3Cell(long h3Cell) {
        List boundary = H3_CORE.h3ToGeoBoundary(h3Cell);
        boundary.add((LatLng)boundary.get(0));
        return GeometryUtils.GEOMETRY_FACTORY.createPolygon((Coordinate[])boundary.stream().map(geoCoord -> new Coordinate(geoCoord.lng, geoCoord.lat)).toArray(Coordinate[]::new));
    }

    public static Pair<LongSet, LongSet> coverGeometryInH3(Geometry geometry, int resolution) {
        if (geometry instanceof Point) {
            LongOpenHashSet potentialCover = new LongOpenHashSet();
            potentialCover.add(H3_CORE.geoToH3(geometry.getCoordinate().y, geometry.getCoordinate().x, resolution));
            return Pair.of((Object)new LongOpenHashSet(), (Object)potentialCover);
        }
        if (geometry instanceof LineString) {
            LongOpenHashSet potentialCover = new LongOpenHashSet();
            potentialCover.addAll((LongCollection)H3Utils.coverLineInH3((LineString)geometry, resolution));
            return Pair.of((Object)new LongOpenHashSet(), (Object)potentialCover);
        }
        if (geometry instanceof Polygon) {
            return H3Utils.coverPolygonInH3((Polygon)geometry, resolution);
        }
        if (geometry instanceof GeometryCollection) {
            LongOpenHashSet fullCover = new LongOpenHashSet();
            LongOpenHashSet potentialCover = new LongOpenHashSet();
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                fullCover.addAll((LongCollection)H3Utils.coverGeometryInH3(geometry.getGeometryN(i), resolution).getLeft());
                potentialCover.addAll((LongCollection)H3Utils.coverGeometryInH3(geometry.getGeometryN(i), resolution).getRight());
            }
            return Pair.of((Object)fullCover, (Object)potentialCover);
        }
        throw new UnsupportedOperationException("Unexpected type: " + geometry.getGeometryType());
    }

    static {
        try {
            H3_CORE = H3CoreV3.newInstance();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to instantiate H3 V3 instance", e);
        }
    }
}

