/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.customobject;

import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class CovarianceTuple
implements Comparable<CovarianceTuple> {
    private double _sumX;
    private double _sumY;
    private double _sumXY;
    private long _count;

    public CovarianceTuple(double sumX, double sumY, double sumXY, long count) {
        this._sumX = sumX;
        this._sumY = sumY;
        this._sumXY = sumXY;
        this._count = count;
    }

    public void apply(double sumX, double sumY, double sumXY, long count) {
        this._sumX += sumX;
        this._sumY += sumY;
        this._sumXY += sumXY;
        this._count += count;
    }

    public void apply(@Nonnull CovarianceTuple covarianceTuple) {
        this._sumX += covarianceTuple._sumX;
        this._sumY += covarianceTuple._sumY;
        this._sumXY += covarianceTuple._sumXY;
        this._count += covarianceTuple._count;
    }

    public double getSumX() {
        return this._sumX;
    }

    public double getSumY() {
        return this._sumY;
    }

    public double getSumXY() {
        return this._sumXY;
    }

    public long getCount() {
        return this._count;
    }

    @Nonnull
    public byte[] toBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(32);
        byteBuffer.putDouble(this._sumX);
        byteBuffer.putDouble(this._sumY);
        byteBuffer.putDouble(this._sumXY);
        byteBuffer.putLong(this._count);
        return byteBuffer.array();
    }

    @Nonnull
    public static CovarianceTuple fromBytes(byte[] bytes) {
        return CovarianceTuple.fromByteBuffer(ByteBuffer.wrap(bytes));
    }

    @Nonnull
    public static CovarianceTuple fromByteBuffer(ByteBuffer byteBuffer) {
        return new CovarianceTuple(byteBuffer.getDouble(), byteBuffer.getDouble(), byteBuffer.getDouble(), byteBuffer.getLong());
    }

    @Override
    public int compareTo(@Nonnull CovarianceTuple covarianceTuple) {
        if (this._count == 0L) {
            if (covarianceTuple._count == 0L) {
                return 0;
            }
            return -1;
        }
        if (covarianceTuple._count == 0L) {
            return 1;
        }
        double cov1 = this._sumXY / (double)this._count - this._sumX / (double)this._count * (this._sumY / (double)this._count);
        double cov2 = covarianceTuple._sumXY / (double)covarianceTuple._count - covarianceTuple._sumX / (double)covarianceTuple._count * (covarianceTuple._sumY / (double)covarianceTuple._count);
        if (cov1 > cov2) {
            return 1;
        }
        if (cov1 < cov2) {
            return -1;
        }
        return 0;
    }
}

