/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.data.manager;

import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.helix.HelixManager;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManagerConfig;
import org.apache.pinot.segment.local.data.manager.TableDataManagerParams;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.spi.data.Schema;

@ThreadSafe
public interface TableDataManager {
    public void init(TableDataManagerConfig var1, String var2, ZkHelixPropertyStore<ZNRecord> var3, ServerMetrics var4, HelixManager var5, LoadingCache<Pair<String, String>, SegmentErrorInfo> var6, TableDataManagerParams var7);

    public void start();

    public void shutDown();

    public void addSegment(ImmutableSegment var1);

    public void addSegment(File var1, IndexLoadingConfig var2) throws Exception;

    public void addSegment(String var1, IndexLoadingConfig var2, SegmentZKMetadata var3) throws Exception;

    public void reloadSegment(String var1, IndexLoadingConfig var2, SegmentZKMetadata var3, SegmentMetadata var4, @Nullable Schema var5, boolean var6) throws Exception;

    public void addOrReplaceSegment(String var1, IndexLoadingConfig var2, SegmentZKMetadata var3, @Nullable SegmentMetadata var4) throws Exception;

    public void removeSegment(String var1);

    public boolean isSegmentDeletedRecently(String var1);

    public List<SegmentDataManager> acquireAllSegments();

    public List<SegmentDataManager> acquireSegments(List<String> var1, List<String> var2);

    @Nullable
    public SegmentDataManager acquireSegment(String var1);

    public void releaseSegment(SegmentDataManager var1);

    public int getNumSegments();

    public String getTableName();

    public File getTableDataDir();

    public TableDataManagerConfig getTableDataManagerConfig();

    public void addSegmentError(String var1, SegmentErrorInfo var2);

    public Map<String, SegmentErrorInfo> getSegmentErrors();
}

