/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.pinot.segment.local.io.util.ValueReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public final class FixedByteValueReaderWriter
implements ValueReader {
    private final PinotDataBuffer _dataBuffer;

    public FixedByteValueReaderWriter(PinotDataBuffer dataBuffer) {
        this._dataBuffer = dataBuffer;
    }

    @Override
    public int getInt(int index) {
        return this._dataBuffer.getInt((long)index * 4L);
    }

    @Override
    public long getLong(int index) {
        return this._dataBuffer.getLong((long)index * 8L);
    }

    @Override
    public float getFloat(int index) {
        return this._dataBuffer.getFloat((long)index * 4L);
    }

    @Override
    public double getDouble(int index) {
        return this._dataBuffer.getDouble((long)index * 8L);
    }

    private int readUnpaddedBytes(int index, int numBytesPerValue, byte paddingByte, byte[] buffer) {
        byte b;
        assert (buffer.length >= numBytesPerValue);
        long startOffset = (long)index * (long)numBytesPerValue;
        long pattern = ((long)paddingByte & 0xFFL) * 0x101010101010101L;
        ByteBuffer wrapper = ByteBuffer.wrap(buffer);
        if (this._dataBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            wrapper.order(ByteOrder.LITTLE_ENDIAN);
        }
        int position = 0;
        int endIndex = numBytesPerValue & 0xFFFFFFF8;
        for (int i = 0; i < endIndex; i += 8) {
            long word = this._dataBuffer.getLong(startOffset + (long)i);
            wrapper.putLong(i, word);
            long zeroed = word ^ pattern;
            long tmp = (zeroed & 0x7F7F7F7F7F7F7F7FL) + 0x7F7F7F7F7F7F7F7FL;
            tmp = (tmp | zeroed | 0x7F7F7F7F7F7F7F7FL) ^ 0xFFFFFFFFFFFFFFFFL;
            if (tmp == 0L) {
                position += 8;
                continue;
            }
            return position += this._dataBuffer.order() == ByteOrder.LITTLE_ENDIAN ? Long.numberOfTrailingZeros(tmp) >>> 3 : Long.numberOfLeadingZeros(tmp) >>> 3;
        }
        while (position < numBytesPerValue && (b = this._dataBuffer.getByte(startOffset + (long)position)) != paddingByte) {
            buffer[position] = b;
            ++position;
        }
        return position;
    }

    @Override
    public byte[] getUnpaddedBytes(int index, int numBytesPerValue, byte paddingByte, byte[] buffer) {
        int length = this.readUnpaddedBytes(index, numBytesPerValue, paddingByte, buffer);
        byte[] bytes = new byte[length];
        System.arraycopy(buffer, 0, bytes, 0, length);
        return bytes;
    }

    @Override
    public String getUnpaddedString(int index, int numBytesPerValue, byte paddingByte, byte[] buffer) {
        int length = this.readUnpaddedBytes(index, numBytesPerValue, paddingByte, buffer);
        return new String(buffer, 0, length, StandardCharsets.UTF_8);
    }

    @Override
    public String getPaddedString(int index, int numBytesPerValue, byte[] buffer) {
        assert (buffer.length >= numBytesPerValue);
        long startOffset = (long)index * (long)numBytesPerValue;
        this._dataBuffer.copyTo(startOffset, buffer, 0, numBytesPerValue);
        return new String(buffer, 0, numBytesPerValue, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] getBytes(int index, int numBytesPerValue) {
        long startOffset = (long)index * (long)numBytesPerValue;
        byte[] value = new byte[numBytesPerValue];
        this._dataBuffer.copyTo(startOffset, value, 0, numBytesPerValue);
        return value;
    }

    public void writeInt(int index, int value) {
        this._dataBuffer.putInt((long)index * 4L, value);
    }

    public void writeLong(int index, long value) {
        this._dataBuffer.putLong((long)index * 8L, value);
    }

    public void writeFloat(int index, float value) {
        this._dataBuffer.putFloat((long)index * 4L, value);
    }

    public void writeDouble(int index, double value) {
        this._dataBuffer.putDouble((long)index * 8L, value);
    }

    public void writeBytes(int index, int numBytesPerValue, byte[] value) {
        assert (value.length <= numBytesPerValue);
        long startIndex = (long)index * (long)numBytesPerValue;
        if (value.length < numBytesPerValue) {
            value = Arrays.copyOf(value, numBytesPerValue);
        }
        this._dataBuffer.readFrom(startIndex, value);
    }

    @Override
    public void close() {
    }
}

