/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.dictionary;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BaseOnHeapMutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class DoubleOnHeapMutableDictionary
extends BaseOnHeapMutableDictionary {
    private volatile double _min = Double.MAX_VALUE;
    private volatile double _max = Double.MIN_VALUE;

    public int index(Object value) {
        Double doubleValue = (Double)value;
        this.updateMinMax(doubleValue);
        return this.indexValue(doubleValue);
    }

    public int[] index(Object[] values) {
        int numValues = values.length;
        int[] dictIds = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            Double doubleValue = (Double)values[i];
            this.updateMinMax(doubleValue);
            dictIds[i] = this.indexValue(doubleValue);
        }
        return dictIds;
    }

    public int compare(int dictId1, int dictId2) {
        return Double.compare(this.getDoubleValue(dictId1), this.getDoubleValue(dictId2));
    }

    public IntSet getDictIdsInRange(String lower, String upper, boolean includeLower, boolean includeUpper) {
        int numValues = this.length();
        if (numValues == 0) {
            return IntSets.EMPTY_SET;
        }
        IntOpenHashSet dictIds = new IntOpenHashSet();
        if (lower.equals("*")) {
            double upperValue = Double.parseDouble(upper);
            if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    double value = this.getDoubleValue(dictId);
                    if (!(value <= upperValue)) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    double value = this.getDoubleValue(dictId);
                    if (!(value < upperValue)) continue;
                    dictIds.add(dictId);
                }
            }
        } else if (upper.equals("*")) {
            double lowerValue = Double.parseDouble(lower);
            if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    double value = this.getDoubleValue(dictId);
                    if (!(value >= lowerValue)) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    double value = this.getDoubleValue(dictId);
                    if (!(value > lowerValue)) continue;
                    dictIds.add(dictId);
                }
            }
        } else {
            double lowerValue = Double.parseDouble(lower);
            double upperValue = Double.parseDouble(upper);
            if (includeLower && includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    double value = this.getDoubleValue(dictId);
                    if (!(value >= lowerValue) || !(value <= upperValue)) continue;
                    dictIds.add(dictId);
                }
            } else if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    double value = this.getDoubleValue(dictId);
                    if (!(value >= lowerValue) || !(value < upperValue)) continue;
                    dictIds.add(dictId);
                }
            } else if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    double value = this.getDoubleValue(dictId);
                    if (!(value > lowerValue) || !(value <= upperValue)) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    double value = this.getDoubleValue(dictId);
                    if (!(value > lowerValue) || !(value < upperValue)) continue;
                    dictIds.add(dictId);
                }
            }
        }
        return dictIds;
    }

    public Double getMinVal() {
        return this._min;
    }

    public Double getMaxVal() {
        return this._max;
    }

    public double[] getSortedValues() {
        int numValues = this.length();
        double[] sortedValues = new double[numValues];
        for (int dictId = 0; dictId < numValues; ++dictId) {
            sortedValues[dictId] = this.getDoubleValue(dictId);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.DOUBLE;
    }

    public int indexOf(String stringValue) {
        return this.getDictId(Double.valueOf(stringValue));
    }

    public int indexOf(double doubleValue) {
        return this.getDictId(doubleValue);
    }

    public int getIntValue(int dictId) {
        return (int)this.getDoubleValue(dictId);
    }

    public long getLongValue(int dictId) {
        return (long)this.getDoubleValue(dictId);
    }

    public float getFloatValue(int dictId) {
        return (float)this.getDoubleValue(dictId);
    }

    public double getDoubleValue(int dictId) {
        return (Double)this.get(dictId);
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return BigDecimal.valueOf(this.getDoubleValue(dictId));
    }

    public String getStringValue(int dictId) {
        return Double.toString(this.getDoubleValue(dictId));
    }

    private void updateMinMax(double value) {
        if (value < this._min) {
            this._min = value;
        }
        if (value > this._max) {
            this._max = value;
        }
    }
}

