/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.dictionary;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BaseOnHeapMutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class StringOnHeapMutableDictionary
extends BaseOnHeapMutableDictionary {
    private volatile String _min = null;
    private volatile String _max = null;

    public int index(Object value) {
        String stringValue = (String)value;
        this.updateMinMax(stringValue);
        return this.indexValue(stringValue);
    }

    public int[] index(Object[] values) {
        int numValues = values.length;
        int[] dictIds = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            String stringValue = (String)values[i];
            this.updateMinMax(stringValue);
            dictIds[i] = this.indexValue(stringValue);
        }
        return dictIds;
    }

    public int compare(int dictId1, int dictId2) {
        return this.getStringValue(dictId1).compareTo(this.getStringValue(dictId2));
    }

    public IntSet getDictIdsInRange(String lower, String upper, boolean includeLower, boolean includeUpper) {
        int upperCompareThreshold;
        int numValues = this.length();
        if (numValues == 0) {
            return IntSets.EMPTY_SET;
        }
        IntOpenHashSet dictIds = new IntOpenHashSet();
        int lowerCompareThreshold = includeLower ? 0 : 1;
        int n = upperCompareThreshold = includeUpper ? 0 : -1;
        if (lower.equals("*")) {
            for (int dictId = 0; dictId < numValues; ++dictId) {
                String value = this.getStringValue(dictId);
                if (value.compareTo(upper) > upperCompareThreshold) continue;
                dictIds.add(dictId);
            }
        } else if (upper.equals("*")) {
            for (int dictId = 0; dictId < numValues; ++dictId) {
                String value = this.getStringValue(dictId);
                if (value.compareTo(lower) < lowerCompareThreshold) continue;
                dictIds.add(dictId);
            }
        } else {
            for (int dictId = 0; dictId < numValues; ++dictId) {
                String value = this.getStringValue(dictId);
                if (value.compareTo(lower) < lowerCompareThreshold || value.compareTo(upper) > upperCompareThreshold) continue;
                dictIds.add(dictId);
            }
        }
        return dictIds;
    }

    public String getMinVal() {
        return this._min;
    }

    public String getMaxVal() {
        return this._max;
    }

    public String[] getSortedValues() {
        int numValues = this.length();
        Object[] sortedValues = new String[numValues];
        for (int dictId = 0; dictId < numValues; ++dictId) {
            sortedValues[dictId] = this.getStringValue(dictId);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.STRING;
    }

    public int indexOf(String stringValue) {
        return this.getDictId(stringValue);
    }

    public int getIntValue(int dictId) {
        return Integer.parseInt(this.getStringValue(dictId));
    }

    public long getLongValue(int dictId) {
        return Long.parseLong(this.getStringValue(dictId));
    }

    public float getFloatValue(int dictId) {
        return Float.parseFloat(this.getStringValue(dictId));
    }

    public double getDoubleValue(int dictId) {
        return Double.parseDouble(this.getStringValue(dictId));
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return new BigDecimal(this.getStringValue(dictId));
    }

    public String getStringValue(int dictId) {
        return (String)this.get(dictId);
    }

    public byte[] getBytesValue(int dictId) {
        return this.getStringValue(dictId).getBytes(StandardCharsets.UTF_8);
    }

    private void updateMinMax(String value) {
        if (this._min == null) {
            this._min = value;
            this._max = value;
        } else {
            if (value.compareTo(this._min) < 0) {
                this._min = value;
            }
            if (value.compareTo(this._max) > 0) {
                this._max = value;
            }
        }
    }
}

