/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.inv.json;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.pinot.segment.local.io.util.VarLengthValueWriter;
import org.apache.pinot.segment.local.segment.creator.impl.inv.BitmapInvertedIndexWriter;
import org.apache.pinot.segment.local.segment.creator.impl.inv.json.BaseJsonIndexCreator;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.config.table.JsonIndexConfig;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.RoaringBitmapWriter;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class OffHeapJsonIndexCreator
extends BaseJsonIndexCreator {
    private static final int FLUSH_THRESHOLD = 100000;
    private static final String POSTING_LIST_FILE_NAME = "posting.buf";
    private static final String FINAL_POSTING_LIST_FILE_NAME = "final.posting.buf";
    private final File _postingListFile;
    private final DataOutputStream _postingListOutputStream;
    private final LongList _postingListChunkEndOffsets = new LongArrayList();
    private int _nextDocId;
    private long _postingListChunkOffset;
    private int _maxBitmapSize;
    private int _numPostingListsInLastChunk;
    private int _numPostingLists;

    public OffHeapJsonIndexCreator(File indexDir, String columnName, JsonIndexConfig jsonIndexConfig) throws IOException {
        super(indexDir, columnName, jsonIndexConfig);
        this._postingListFile = new File(this._tempDir, POSTING_LIST_FILE_NAME);
        this._postingListOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this._postingListFile)));
    }

    @Override
    void addFlattenedRecords(List<Map<String, String>> records) throws IOException {
        super.addFlattenedRecords(records);
        ++this._nextDocId;
        if (this._nextDocId % 100000 == 0) {
            this.flush();
        }
    }

    private void flush() throws IOException {
        long length = 0L;
        for (Map.Entry entry : this._postingListMap.entrySet()) {
            byte[] valueBytes = ((String)entry.getKey()).getBytes(StandardCharsets.UTF_8);
            int valueLength = valueBytes.length;
            this._maxValueLength = Integer.max(this._maxValueLength, valueLength);
            this._postingListOutputStream.writeInt(valueLength);
            this._postingListOutputStream.write(valueBytes);
            length += (long)(4 + valueLength);
            RoaringBitmap docIds = (RoaringBitmap)((RoaringBitmapWriter)entry.getValue()).get();
            int bitmapSize = docIds.serializedSizeInBytes();
            this._maxBitmapSize = Integer.max(this._maxBitmapSize, bitmapSize);
            this._postingListOutputStream.writeInt(bitmapSize);
            docIds.serialize((DataOutput)this._postingListOutputStream);
            length += (long)(4 + bitmapSize);
        }
        this._postingListChunkOffset += length;
        this._postingListChunkEndOffsets.add(this._postingListChunkOffset);
        this._numPostingListsInLastChunk = this._postingListMap.size();
        this._postingListMap.clear();
    }

    public void seal() throws IOException {
        File finalPostingListFile;
        if (this._nextDocId % 100000 != 0) {
            this.flush();
        }
        this._postingListOutputStream.close();
        byte[] valueBytesBuffer = new byte[this._maxValueLength];
        if (this._postingListChunkEndOffsets.size() == 1) {
            finalPostingListFile = this._postingListFile;
            this._numPostingLists = this._numPostingListsInLastChunk;
        } else {
            finalPostingListFile = this.createFinalPostingListFile(valueBytesBuffer);
        }
        try (PinotDataBuffer finalPostingListBuffer = PinotDataBuffer.mapFile((File)finalPostingListFile, (boolean)true, (long)0L, (long)finalPostingListFile.length(), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)"Json index final posting list");
             VarLengthValueWriter dictionaryWriter = new VarLengthValueWriter(this._dictionaryFile, this._numPostingLists);
             BitmapInvertedIndexWriter invertedIndexWriter = new BitmapInvertedIndexWriter(this._invertedIndexFile, this._numPostingLists);){
            byte[] bitmapBytesBuffer = new byte[this._maxBitmapSize];
            long offset = 0L;
            for (int i = 0; i < this._numPostingLists; ++i) {
                int valueLength = finalPostingListBuffer.getInt(offset);
                finalPostingListBuffer.copyTo(offset += 4L, valueBytesBuffer, 0, valueLength);
                dictionaryWriter.add(valueBytesBuffer, valueLength);
                int bitmapSize = finalPostingListBuffer.getInt(offset += (long)valueLength);
                finalPostingListBuffer.copyTo(offset += 4L, bitmapBytesBuffer, 0, bitmapSize);
                offset += (long)bitmapSize;
                invertedIndexWriter.add(bitmapBytesBuffer, bitmapSize);
            }
        }
        this.generateIndexFile();
    }

    private File createFinalPostingListFile(byte[] valueBytesBuffer) throws IOException {
        File finalPostingListFile = new File(this._tempDir, FINAL_POSTING_LIST_FILE_NAME);
        try (PinotDataBuffer postingListBuffer = PinotDataBuffer.mapFile((File)this._postingListFile, (boolean)true, (long)0L, (long)this._postingListFile.length(), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)"Json index posting list");){
            int numChunks = this._postingListChunkEndOffsets.size();
            ArrayList<ChunkIterator> chunkIterators = new ArrayList<ChunkIterator>(numChunks);
            long chunkEndOffset = 0L;
            for (int i = 0; i < numChunks; ++i) {
                long chunkStartOffset = chunkEndOffset;
                chunkEndOffset = this._postingListChunkEndOffsets.getLong(i);
                PinotDataBuffer chunkDataBuffer = postingListBuffer.view(chunkStartOffset, chunkEndOffset);
                chunkIterators.add(new ChunkIterator(chunkDataBuffer, i, valueBytesBuffer));
            }
            try (DataOutputStream finalPostingListOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(finalPostingListFile)));){
                PriorityQueue<PostingListEntry> priorityQueue = new PriorityQueue<PostingListEntry>(numChunks);
                for (ChunkIterator chunkIterator : chunkIterators) {
                    if (!chunkIterator.hasNext()) continue;
                    priorityQueue.offer(chunkIterator.next());
                }
                String currentValue = null;
                MutableRoaringBitmap currentDocIds = null;
                while (!priorityQueue.isEmpty()) {
                    ChunkIterator chunkIterator;
                    PostingListEntry leastEntry = (PostingListEntry)priorityQueue.poll();
                    if (currentValue == null || !currentValue.equals(leastEntry._value)) {
                        if (currentValue != null) {
                            this.writeToFinalPostingList(finalPostingListOutputStream, currentValue, currentDocIds);
                        }
                        currentValue = leastEntry._value;
                        currentDocIds = leastEntry._docIds.toMutableRoaringBitmap();
                    } else {
                        currentDocIds.or(leastEntry._docIds);
                    }
                    if (!(chunkIterator = (ChunkIterator)chunkIterators.get(leastEntry._chunkId)).hasNext()) continue;
                    priorityQueue.offer(chunkIterator.next());
                }
                if (currentValue != null) {
                    this.writeToFinalPostingList(finalPostingListOutputStream, currentValue, currentDocIds);
                }
            }
        }
        return finalPostingListFile;
    }

    private void writeToFinalPostingList(DataOutputStream finalPostingListOutputStream, String value, MutableRoaringBitmap docIds) throws IOException {
        byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
        finalPostingListOutputStream.writeInt(valueBytes.length);
        finalPostingListOutputStream.write(valueBytes);
        int bitmapSize = docIds.serializedSizeInBytes();
        this._maxBitmapSize = Integer.max(this._maxBitmapSize, bitmapSize);
        finalPostingListOutputStream.writeInt(bitmapSize);
        docIds.serialize((DataOutput)finalPostingListOutputStream);
        ++this._numPostingLists;
    }

    private static class PostingListEntry
    implements Comparable<PostingListEntry> {
        final String _value;
        final ImmutableRoaringBitmap _docIds;
        final int _chunkId;

        private PostingListEntry(String value, ImmutableRoaringBitmap docIds, int chunkId) {
            this._value = value;
            this._docIds = docIds;
            this._chunkId = chunkId;
        }

        @Override
        public int compareTo(PostingListEntry entry) {
            return this._value.compareTo(entry._value);
        }
    }

    private static class ChunkIterator
    implements Iterator<PostingListEntry> {
        final PinotDataBuffer _dataBuffer;
        final long _bufferSize;
        final int _chunkId;
        final byte[] _valueBytesBuffer;
        long _offset;

        ChunkIterator(PinotDataBuffer dataBuffer, int chunkId, byte[] valueBytesBuffer) {
            this._dataBuffer = dataBuffer;
            this._bufferSize = dataBuffer.size();
            this._chunkId = chunkId;
            this._valueBytesBuffer = valueBytesBuffer;
        }

        @Override
        public boolean hasNext() {
            return this._offset < this._bufferSize;
        }

        @Override
        public PostingListEntry next() {
            int valueLength = this._dataBuffer.getInt(this._offset);
            this._offset += 4L;
            this._dataBuffer.copyTo(this._offset, this._valueBytesBuffer, 0, valueLength);
            String value = new String(this._valueBytesBuffer, 0, valueLength, StandardCharsets.UTF_8);
            this._offset += (long)valueLength;
            int bitmapSize = this._dataBuffer.getInt(this._offset);
            this._offset += 4L;
            ImmutableRoaringBitmap docIds = new ImmutableRoaringBitmap(this._dataBuffer.toDirectByteBuffer(this._offset, bitmapSize));
            this._offset += (long)bitmapSize;
            return new PostingListEntry(value, docIds, this._chunkId);
        }
    }
}

