/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pinot.segment.local.startree.OffHeapStarTreeNode;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.startree.StarTree;
import org.apache.pinot.segment.spi.index.startree.StarTreeNode;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class OffHeapStarTree
implements StarTree {
    public static final long MAGIC_MARKER = -4981643802526953459L;
    public static final int VERSION = 1;
    private final OffHeapStarTreeNode _root;
    private final List<String> _dimensionNames;

    public OffHeapStarTree(PinotDataBuffer dataBuffer) {
        long offset = 0L;
        Preconditions.checkState((-4981643802526953459L == dataBuffer.getLong(offset) ? 1 : 0) != 0, (Object)"Invalid magic marker in star-tree data buffer");
        Preconditions.checkState((1 == dataBuffer.getInt(offset += 8L) ? 1 : 0) != 0, (Object)"Invalid version in star-tree data buffer");
        int rootNodeOffset = dataBuffer.getInt(offset += 4L);
        int numDimensions = dataBuffer.getInt(offset += 4L);
        offset += 4L;
        String[] dimensionNames = new String[numDimensions];
        for (int i = 0; i < numDimensions; ++i) {
            int dimensionId = dataBuffer.getInt(offset);
            int numBytes = dataBuffer.getInt(offset += 4L);
            byte[] bytes = new byte[numBytes];
            dataBuffer.copyTo(offset += 4L, bytes);
            offset += (long)numBytes;
            dimensionNames[dimensionId] = new String(bytes, StandardCharsets.UTF_8);
        }
        this._dimensionNames = Arrays.asList(dimensionNames);
        int numNodes = dataBuffer.getInt(offset);
        Preconditions.checkState(((offset += 4L) == (long)rootNodeOffset ? 1 : 0) != 0, (Object)"Error loading star-tree, header length mis-match");
        long bufferSize = dataBuffer.size();
        Preconditions.checkState((offset + (long)numNodes * 28L == bufferSize ? 1 : 0) != 0, (Object)"Error loading star-tree, buffer size mis-match");
        this._root = new OffHeapStarTreeNode(dataBuffer.view((long)rootNodeOffset, bufferSize), 0);
    }

    public StarTreeNode getRoot() {
        return this._root;
    }

    public List<String> getDimensionNames() {
        return this._dimensionNames;
    }

    public void printTree(Map<String, Dictionary> dictionaryMap) {
        this.printTreeHelper(dictionaryMap, this._root, 0);
    }

    private void printTreeHelper(Map<String, Dictionary> dictionaryMap, OffHeapStarTreeNode node, int level) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            stringBuilder.append("  ");
        }
        String dimensionName = "ALL";
        int dimensionId = node.getDimensionId();
        if (dimensionId != -1) {
            dimensionName = this._dimensionNames.get(dimensionId);
        }
        String dimensionValueString = "ALL";
        int dimensionValue = node.getDimensionValue();
        if (dimensionValue != -1) {
            dimensionValueString = dictionaryMap.get(dimensionName).get(dimensionValue).toString();
        }
        String childDimensionName = "null";
        int childDimensionId = node.getChildDimensionId();
        if (childDimensionId != -1) {
            childDimensionName = this._dimensionNames.get(childDimensionId);
        }
        String formattedOutput = MoreObjects.toStringHelper((Object)node).add("level", level).add("dimensionName", (Object)dimensionName).add("dimensionValue", (Object)dimensionValueString).add("childDimensionName", (Object)childDimensionName).add("startDocId", node.getStartDocId()).add("endDocId", node.getEndDocId()).add("aggregatedDocId", node.getAggregatedDocId()).add("numChildren", node.getNumChildren()).toString();
        stringBuilder.append(formattedOutput);
        System.out.println(stringBuilder.toString());
        if (!node.isLeaf()) {
            Iterator<OffHeapStarTreeNode> childrenIterator = node.getChildrenIterator();
            while (childrenIterator.hasNext()) {
                this.printTreeHelper(dictionaryMap, childrenIterator.next(), level + 1);
            }
        }
    }
}

