/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree.v2.store;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeIndexMapUtils;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeLoaderUtils;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.apache.pinot.segment.spi.store.SegmentDirectory;

public class StarTreeIndexContainer
implements Closeable {
    private final List<StarTreeV2> _starTrees;

    public StarTreeIndexContainer(SegmentDirectory.Reader segmentReader, SegmentMetadataImpl segmentMetadata, Map<String, ColumnIndexContainer> indexContainerMap) throws IOException {
        try (InputStream inputStream = segmentReader.getStarTreeIndexMap();){
            this._starTrees = StarTreeLoaderUtils.loadStarTreeV2(segmentReader.getStarTreeIndex(), StarTreeIndexMapUtils.loadFromInputStream(inputStream, segmentMetadata.getStarTreeV2MetadataList().size()), segmentMetadata, indexContainerMap);
        }
    }

    public List<StarTreeV2> getStarTrees() {
        return this._starTrees;
    }

    @Override
    public void close() throws IOException {
    }
}

