/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FSTHeader {
    public static final int FST_MAGIC = 1550218081;
    final byte _version;

    FSTHeader(byte version) {
        this._version = version;
    }

    public static FSTHeader read(InputStream in) throws IOException {
        if (in.read() != 92 || in.read() != 102 || in.read() != 115 || in.read() != 97) {
            throw new IOException("Invalid file header, probably not an FST.");
        }
        int version = in.read();
        if (version == -1) {
            throw new IOException("Truncated file, no version number.");
        }
        return new FSTHeader((byte)version);
    }

    public static void write(OutputStream os, byte version) throws IOException {
        os.write(92);
        os.write(23654);
        os.write(6055539);
        os.write(1550218081);
        os.write(version);
    }
}

