/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.pinot.segment.local.upsert.merger;

/**
 * Merges 2 records and returns the merged record.
 * Add the new value from incoming row to the existing value from numeric field. Then return the merged record.
 */
public class IncrementMerger implements PartialUpsertMerger {
  IncrementMerger() {
  }

  /**
   * Increment the new value from incoming row to the given field of previous record.
   */
  @Override
  public Object merge(Object previousValue, Object currentValue) {
    return addNumbers((Number) previousValue, (Number) currentValue);
  }

  private static Number addNumbers(Number a, Number b) {
    if (a instanceof Integer) {
      return (Integer) a + (Integer) b;
    } else if (a instanceof Long) {
      return (Long) a + (Long) b;
    } else if (a instanceof Float) {
      return (Float) a + (Float) b;
    } else {
      return (Double) a + (Double) b;
    }
  }
}
