/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.util;

import java.io.Closeable;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public final class PinotDataBitSet
implements Closeable {
    private static final int[] NUM_BITS_SET = new int[256];
    private static final int[][] NTH_BIT_SET = new int[8][256];
    private static final int[] FIRST_BIT_SET = NTH_BIT_SET[0];
    private static final int BYTE_MASK = 255;
    private final PinotDataBuffer _dataBuffer;

    public static int getNumBitsPerValue(int maxValue) {
        if (maxValue <= 1) {
            return 1;
        }
        int numBitsPerValue = 8;
        while (maxValue > 255) {
            maxValue >>>= 8;
            numBitsPerValue += 8;
        }
        return numBitsPerValue - FIRST_BIT_SET[maxValue];
    }

    public PinotDataBitSet(PinotDataBuffer dataBuffer) {
        this._dataBuffer = dataBuffer;
    }

    public int readInt(int index, int numBitsPerValue) {
        long bitOffset = (long)index * (long)numBitsPerValue;
        int byteOffset = (int)(bitOffset / 8L);
        int bitOffsetInFirstByte = (int)(bitOffset % 8L);
        int currentValue = this._dataBuffer.getByte(byteOffset) & 255 >>> bitOffsetInFirstByte;
        int numBitsLeft = numBitsPerValue - (8 - bitOffsetInFirstByte);
        if (numBitsLeft <= 0) {
            return currentValue >>> -numBitsLeft;
        }
        while (numBitsLeft > 8) {
            currentValue = currentValue << 8 | this._dataBuffer.getByte(++byteOffset) & 0xFF;
            numBitsLeft -= 8;
        }
        return currentValue << numBitsLeft | (this._dataBuffer.getByte(byteOffset + 1) & 0xFF) >>> 8 - numBitsLeft;
    }

    public void readInt(int startIndex, int numBitsPerValue, int length, int[] buffer) {
        long startBitOffset = (long)startIndex * (long)numBitsPerValue;
        int byteOffset = (int)(startBitOffset / 8L);
        int bitOffsetInFirstByte = (int)(startBitOffset % 8L);
        int currentValue = this._dataBuffer.getByte(byteOffset) & 255 >>> bitOffsetInFirstByte;
        for (int i = 0; i < length; ++i) {
            int numBitsLeft;
            if (bitOffsetInFirstByte == 8) {
                bitOffsetInFirstByte = 0;
                currentValue = this._dataBuffer.getByte(++byteOffset) & 0xFF;
            }
            if ((numBitsLeft = numBitsPerValue - (8 - bitOffsetInFirstByte)) <= 0) {
                buffer[i] = currentValue >>> -numBitsLeft;
                bitOffsetInFirstByte = 8 + numBitsLeft;
                currentValue &= 255 >>> bitOffsetInFirstByte;
                continue;
            }
            while (numBitsLeft > 8) {
                currentValue = currentValue << 8 | this._dataBuffer.getByte(++byteOffset) & 0xFF;
                numBitsLeft -= 8;
            }
            int nextByte = this._dataBuffer.getByte(++byteOffset) & 0xFF;
            buffer[i] = currentValue << numBitsLeft | nextByte >>> 8 - numBitsLeft;
            bitOffsetInFirstByte = numBitsLeft;
            currentValue = nextByte & 255 >>> bitOffsetInFirstByte;
        }
    }

    public void writeInt(int index, int numBitsPerValue, int value) {
        long bitOffset = (long)index * (long)numBitsPerValue;
        int byteOffset = (int)(bitOffset / 8L);
        int bitOffsetInFirstByte = (int)(bitOffset % 8L);
        byte firstByte = this._dataBuffer.getByte(byteOffset);
        int firstByteMask = 255 >>> bitOffsetInFirstByte;
        int numBitsLeft = numBitsPerValue - (8 - bitOffsetInFirstByte);
        if (numBitsLeft <= 0) {
            this._dataBuffer.putByte(byteOffset, (byte)(firstByte & ~(firstByteMask &= 255 << -numBitsLeft) | value << -numBitsLeft));
        } else {
            this._dataBuffer.putByte(byteOffset, (byte)(firstByte & ~firstByteMask | value >>> numBitsLeft & firstByteMask));
            while (numBitsLeft > 8) {
                this._dataBuffer.putByte(++byteOffset, (byte)(value >> (numBitsLeft -= 8)));
            }
            byte lastByte = this._dataBuffer.getByte(++byteOffset);
            this._dataBuffer.putByte(byteOffset, (byte)(lastByte & 255 >>> numBitsLeft | value << 8 - numBitsLeft));
        }
    }

    public void writeInt(int startIndex, int numBitsPerValue, int length, int[] values) {
        long startBitOffset = (long)startIndex * (long)numBitsPerValue;
        int byteOffset = (int)(startBitOffset / 8L);
        int bitOffsetInFirstByte = (int)(startBitOffset % 8L);
        int firstByte = this._dataBuffer.getByte(byteOffset);
        for (int i = 0; i < length; ++i) {
            int value = values[i];
            if (bitOffsetInFirstByte == 8) {
                bitOffsetInFirstByte = 0;
                firstByte = this._dataBuffer.getByte(++byteOffset);
            }
            int firstByteMask = 255 >>> bitOffsetInFirstByte;
            int numBitsLeft = numBitsPerValue - (8 - bitOffsetInFirstByte);
            if (numBitsLeft <= 0) {
                firstByte = firstByte & ~(firstByteMask &= 255 << -numBitsLeft) | value << -numBitsLeft;
                this._dataBuffer.putByte(byteOffset, (byte)firstByte);
                bitOffsetInFirstByte = 8 + numBitsLeft;
                continue;
            }
            this._dataBuffer.putByte(byteOffset, (byte)(firstByte & ~firstByteMask | value >>> numBitsLeft & firstByteMask));
            while (numBitsLeft > 8) {
                this._dataBuffer.putByte(++byteOffset, (byte)(value >> (numBitsLeft -= 8)));
            }
            byte lastByte = this._dataBuffer.getByte(++byteOffset);
            firstByte = lastByte & 255 >>> numBitsLeft | value << 8 - numBitsLeft;
            this._dataBuffer.putByte(byteOffset, (byte)firstByte);
            bitOffsetInFirstByte = numBitsLeft;
        }
    }

    public void setBit(int bitOffset) {
        int byteOffset = bitOffset / 8;
        int bitOffsetInByte = bitOffset % 8;
        this._dataBuffer.putByte(byteOffset, (byte)(this._dataBuffer.getByte(byteOffset) | 128 >>> bitOffsetInByte));
    }

    public void unsetBit(int bitOffset) {
        int byteOffset = bitOffset / 8;
        int bitOffsetInByte = bitOffset % 8;
        this._dataBuffer.putByte(byteOffset, (byte)(this._dataBuffer.getByte(byteOffset) & 65407 >>> bitOffsetInByte));
    }

    public int getNextSetBitOffset(int bitOffset) {
        int currentByte;
        int byteOffset = bitOffset / 8;
        int bitOffsetInFirstByte = bitOffset % 8;
        int firstByte = this._dataBuffer.getByte(byteOffset) << bitOffsetInFirstByte & 0xFF;
        if (firstByte != 0) {
            return bitOffset + FIRST_BIT_SET[firstByte];
        }
        while ((currentByte = this._dataBuffer.getByte(++byteOffset) & 0xFF) == 0) {
        }
        return byteOffset * 8 | FIRST_BIT_SET[currentByte];
    }

    public int getNextNthSetBitOffset(int bitOffset, int n) {
        int currentByte;
        int byteOffset = bitOffset / 8;
        int bitOffsetInFirstByte = bitOffset % 8;
        int firstByte = this._dataBuffer.getByte(byteOffset) << bitOffsetInFirstByte & 0xFF;
        int numBitsSet = NUM_BITS_SET[firstByte];
        if (numBitsSet >= n) {
            return bitOffset + NTH_BIT_SET[n - 1][firstByte];
        }
        while ((numBitsSet = NUM_BITS_SET[currentByte = this._dataBuffer.getByte(++byteOffset) & 0xFF]) < (n -= numBitsSet)) {
        }
        return byteOffset * 8 | NTH_BIT_SET[n - 1][currentByte];
    }

    @Override
    public void close() {
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int numBitsSet = 0;
            for (int j = 0; j < 8; ++j) {
                if ((i & 128 >>> j) == 0) continue;
                int n = i;
                NUM_BITS_SET[n] = NUM_BITS_SET[n] + 1;
                PinotDataBitSet.NTH_BIT_SET[numBitsSet][i] = j;
                ++numBitsSet;
            }
        }
    }
}

