/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.util;

import java.nio.charset.StandardCharsets;
import org.apache.pinot.segment.local.io.util.ValueReader;
import org.apache.pinot.segment.local.io.util.ValueReaderComparisons;
import org.apache.pinot.segment.local.io.util.VarLengthValueWriter;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class VarLengthValueReader
implements ValueReader {
    private final PinotDataBuffer _dataBuffer;
    private final int _numValues;
    private final int _dataSectionStartOffSet;

    public VarLengthValueReader(PinotDataBuffer dataBuffer) {
        this._dataBuffer = dataBuffer;
        this._numValues = dataBuffer.getInt(VarLengthValueWriter.NUM_VALUES_OFFSET);
        this._dataSectionStartOffSet = dataBuffer.getInt(VarLengthValueWriter.DATA_SECTION_OFFSET_POSITION);
    }

    public static boolean isVarLengthValueBuffer(PinotDataBuffer buffer) {
        if (buffer.size() < (long)(VarLengthValueWriter.HEADER_LENGTH + 4)) {
            return false;
        }
        byte[] magicBytes = VarLengthValueWriter.MAGIC_BYTES;
        int length = magicBytes.length;
        for (int i = 0; i < length; ++i) {
            if (buffer.getByte(i) == magicBytes[i]) continue;
            return false;
        }
        return buffer.getInt(VarLengthValueWriter.VERSION_OFFSET) == 1;
    }

    public int getNumValues() {
        return this._numValues;
    }

    @Override
    public int getInt(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getUnpaddedBytes(int index, int numBytesPerValue, byte[] buffer) {
        return this.getBytes(index, numBytesPerValue);
    }

    @Override
    public String getUnpaddedString(int index, int numBytesPerValue, byte[] buffer) {
        assert (buffer.length >= numBytesPerValue);
        int offsetPosition = this._dataSectionStartOffSet + 4 * index;
        int startOffset = this._dataBuffer.getInt(offsetPosition);
        int endOffset = this._dataBuffer.getInt(offsetPosition + 4);
        int length = endOffset - startOffset;
        assert (numBytesPerValue >= length);
        this._dataBuffer.copyTo((long)startOffset, buffer, 0, length);
        return new String(buffer, 0, length, StandardCharsets.UTF_8);
    }

    @Override
    public String getPaddedString(int index, int numBytesPerValue, byte[] buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes(int index, int numBytesPerValue) {
        int offsetPosition = this._dataSectionStartOffSet + 4 * index;
        int startOffset = this._dataBuffer.getInt(offsetPosition);
        int endOffset = this._dataBuffer.getInt(offsetPosition + 4);
        int length = endOffset - startOffset;
        byte[] value = new byte[length];
        this._dataBuffer.copyTo((long)startOffset, value);
        return value;
    }

    @Override
    public int compareUtf8Bytes(int index, int numBytesPerValue, byte[] bytes) {
        int offsetPosition = this._dataSectionStartOffSet + 4 * index;
        int startOffset = this._dataBuffer.getInt(offsetPosition);
        int endOffset = this._dataBuffer.getInt(offsetPosition + 4);
        int length = endOffset - startOffset;
        return ValueReaderComparisons.compareUtf8Bytes(this._dataBuffer, startOffset, length, false, bytes);
    }

    @Override
    public int compareBytes(int index, int numBytesPerValue, byte[] bytes) {
        int offsetPosition = this._dataSectionStartOffSet + 4 * index;
        int startOffset = this._dataBuffer.getInt(offsetPosition);
        int endOffset = this._dataBuffer.getInt(offsetPosition + 4);
        int length = endOffset - startOffset;
        return ValueReaderComparisons.compareBytes(this._dataBuffer, startOffset, length, bytes);
    }

    @Override
    public void close() {
    }
}

