/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.loader;

import java.io.File;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.store.SegmentLocalFSDirectory;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoader;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoaderContext;
import org.apache.pinot.segment.spi.loader.SegmentLoader;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SegmentLoader(name="default")
public class DefaultSegmentDirectoryLoader
implements SegmentDirectoryLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSegmentDirectoryLoader.class);

    public SegmentDirectory load(URI indexDir, SegmentDirectoryLoaderContext segmentLoaderContext) throws Exception {
        PinotConfiguration segmentDirectoryConfigs = segmentLoaderContext.getSegmentDirectoryConfigs();
        File directory = new File(indexDir);
        if (!directory.exists()) {
            return new SegmentLocalFSDirectory(directory);
        }
        return new SegmentLocalFSDirectory(directory, ReadMode.valueOf((String)segmentDirectoryConfigs.getProperty("readMode")));
    }

    public void delete(SegmentDirectoryLoaderContext segmentLoaderContext) throws Exception {
        File indexDir = new File(segmentLoaderContext.getTableDataDir(), segmentLoaderContext.getSegmentName());
        if (indexDir.exists()) {
            FileUtils.deleteQuietly((File)indexDir);
            LOGGER.info("Deleted segment directory {} on default tier", (Object)indexDir);
        }
    }
}

