/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.converter;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.segment.local.realtime.converter.ColumnIndicesForRealtimeTable;
import org.apache.pinot.segment.local.realtime.converter.stats.RealtimeSegmentSegmentCreationDataSource;
import org.apache.pinot.segment.local.segment.creator.TransformPipeline;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.local.segment.index.text.TextIndexConfigBuilder;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.FstIndexConfig;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.SegmentZKPropsConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class RealtimeSegmentConverter {
    private final MutableSegmentImpl _realtimeSegmentImpl;
    private final SegmentZKPropsConfig _segmentZKPropsConfig;
    private final String _outputPath;
    private final Schema _dataSchema;
    private final String _tableName;
    private final TableConfig _tableConfig;
    private final String _segmentName;
    private final ColumnIndicesForRealtimeTable _columnIndicesForRealtimeTable;
    private final boolean _nullHandlingEnabled;

    public RealtimeSegmentConverter(MutableSegmentImpl realtimeSegment, SegmentZKPropsConfig segmentZKPropsConfig, String outputPath, Schema schema, String tableName, TableConfig tableConfig, String segmentName, ColumnIndicesForRealtimeTable cdc, boolean nullHandlingEnabled) {
        this._realtimeSegmentImpl = realtimeSegment;
        this._segmentZKPropsConfig = segmentZKPropsConfig;
        this._outputPath = outputPath;
        this._columnIndicesForRealtimeTable = cdc;
        if (cdc.getSortedColumn() != null) {
            this._columnIndicesForRealtimeTable.getInvertedIndexColumns().remove(cdc.getSortedColumn());
        }
        this._dataSchema = RealtimeSegmentConverter.getUpdatedSchema(schema);
        this._tableName = tableName;
        this._tableConfig = tableConfig;
        this._segmentName = segmentName;
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    public void build(@Nullable SegmentVersion segmentVersion, ServerMetrics serverMetrics) throws Exception {
        SegmentGeneratorConfig genConfig = new SegmentGeneratorConfig(this._tableConfig, this._dataSchema);
        genConfig.setSegmentTimeValueCheck(false);
        if (this._columnIndicesForRealtimeTable.getInvertedIndexColumns() != null) {
            genConfig.setIndexOn(StandardIndexes.inverted(), IndexConfig.ENABLED, this._columnIndicesForRealtimeTable.getInvertedIndexColumns());
        }
        if (this._columnIndicesForRealtimeTable.getVarLengthDictionaryColumns() != null) {
            genConfig.setVarLengthDictionaryColumns(this._columnIndicesForRealtimeTable.getVarLengthDictionaryColumns());
        }
        if (segmentVersion != null) {
            genConfig.setSegmentVersion(segmentVersion);
        }
        genConfig.setTableName(this._tableName);
        genConfig.setOutDir(this._outputPath);
        genConfig.setSegmentName(this._segmentName);
        this.addIndexOrDefault(genConfig, StandardIndexes.text(), this._columnIndicesForRealtimeTable.getTextIndexColumns(), new TextIndexConfigBuilder(genConfig.getFSTIndexType()).build());
        this.addIndexOrDefault(genConfig, StandardIndexes.fst(), this._columnIndicesForRealtimeTable.getFstIndexColumns(), new FstIndexConfig(genConfig.getFSTIndexType()));
        SegmentPartitionConfig segmentPartitionConfig = this._realtimeSegmentImpl.getSegmentPartitionConfig();
        genConfig.setSegmentPartitionConfig(segmentPartitionConfig);
        genConfig.setNullHandlingEnabled(this._nullHandlingEnabled);
        genConfig.setSegmentZKPropsConfig(this._segmentZKPropsConfig);
        SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
        try (PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader();){
            int[] sortedDocIds = this._columnIndicesForRealtimeTable.getSortedColumn() != null ? this._realtimeSegmentImpl.getSortedDocIdIterationOrderWithSortedColumn(this._columnIndicesForRealtimeTable.getSortedColumn()) : null;
            recordReader.init(this._realtimeSegmentImpl, sortedDocIds);
            RealtimeSegmentSegmentCreationDataSource dataSource = new RealtimeSegmentSegmentCreationDataSource(this._realtimeSegmentImpl, recordReader);
            driver.init(genConfig, dataSource, TransformPipeline.getPassThroughPipeline());
            driver.build();
        }
        if (segmentPartitionConfig != null) {
            Map columnPartitionMap = segmentPartitionConfig.getColumnPartitionMap();
            for (String columnName : columnPartitionMap.keySet()) {
                int numPartitions = driver.getSegmentStats().getColumnProfileFor(columnName).getPartitions().size();
                serverMetrics.addValueToTableGauge(this._tableName, (AbstractMetrics.Gauge)ServerGauge.REALTIME_SEGMENT_NUM_PARTITIONS, (long)numPartitions);
            }
        }
    }

    private <C extends IndexConfig> void addIndexOrDefault(SegmentGeneratorConfig genConfig, IndexType<C, ?, ?> indexType, @Nullable Collection<String> columns, C defaultConfig) {
        Map config = indexType.getConfig(genConfig.getTableConfig(), genConfig.getSchema());
        if (columns != null) {
            for (String column : columns) {
                IndexConfig colConf = (IndexConfig)config.get(column);
                genConfig.setIndexOn(indexType, colConf == null ? defaultConfig : colConf, new String[]{column});
            }
        }
    }

    @VisibleForTesting
    public static Schema getUpdatedSchema(Schema original) {
        Schema newSchema = new Schema();
        for (FieldSpec fieldSpec : original.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn()) continue;
            newSchema.addField(fieldSpec);
        }
        return newSchema;
    }
}

