/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.converter.stats;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.realtime.converter.stats.MutableColumnStatistics;
import org.apache.pinot.segment.local.realtime.converter.stats.MutableNoDictionaryColStatistics;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.creator.SegmentPreIndexStatsContainer;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class RealtimeSegmentStatsContainer
implements SegmentPreIndexStatsContainer {
    private final MutableSegment _mutableSegment;
    private final Map<String, ColumnStatistics> _columnStatisticsMap = new HashMap<String, ColumnStatistics>();

    public RealtimeSegmentStatsContainer(MutableSegment mutableSegment, @Nullable int[] sortedDocIds) {
        this._mutableSegment = mutableSegment;
        for (String columnName : mutableSegment.getPhysicalColumnNames()) {
            DataSource dataSource = mutableSegment.getDataSource(columnName);
            if (dataSource.getDictionary() != null) {
                this._columnStatisticsMap.put(columnName, new MutableColumnStatistics(mutableSegment.getDataSource(columnName), sortedDocIds));
                continue;
            }
            this._columnStatisticsMap.put(columnName, new MutableNoDictionaryColStatistics(dataSource));
        }
    }

    public ColumnStatistics getColumnProfileFor(String column) {
        return this._columnStatisticsMap.get(column);
    }

    public int getTotalDocCount() {
        return this._mutableSegment.getNumDocsIndexed();
    }
}

