/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.forward;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.pinot.segment.local.io.reader.impl.FixedByteSingleValueMultiColReader;
import org.apache.pinot.segment.local.io.writer.impl.FixedByteSingleValueMultiColWriter;
import org.apache.pinot.segment.spi.index.mutable.MutableForwardIndex;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedByteSVMutableForwardIndex
implements MutableForwardIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedByteSVMutableForwardIndex.class);
    private final List<WriterWithOffset> _writers = new ArrayList<WriterWithOffset>();
    private final List<ReaderWithOffset> _readers = new CopyOnWriteArrayList<ReaderWithOffset>();
    private final boolean _dictionaryEncoded;
    private final FieldSpec.DataType _storedType;
    private final int _valueSizeInBytes;
    private final int _numRowsPerChunk;
    private final long _chunkSizeInBytes;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final String _allocationContext;
    private int _capacityInRows = 0;

    public FixedByteSVMutableForwardIndex(boolean dictionaryEncoded, FieldSpec.DataType storedType, int fixedLength, int numRowsPerChunk, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        this._dictionaryEncoded = dictionaryEncoded;
        this._storedType = storedType;
        if (!storedType.isFixedWidth()) {
            Preconditions.checkState((fixedLength > 0 ? 1 : 0) != 0, (String)"Fixed length must be provided for type: %s", (Object)storedType);
            this._valueSizeInBytes = fixedLength;
        } else {
            this._valueSizeInBytes = storedType.size();
        }
        this._numRowsPerChunk = numRowsPerChunk;
        this._chunkSizeInBytes = numRowsPerChunk * this._valueSizeInBytes;
        this._memoryManager = memoryManager;
        this._allocationContext = allocationContext;
        this.addBuffer();
    }

    public FixedByteSVMutableForwardIndex(boolean dictionaryEncoded, FieldSpec.DataType valueType, int numRowsPerChunk, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        this(dictionaryEncoded, valueType, -1, numRowsPerChunk, memoryManager, allocationContext);
    }

    public boolean isDictionaryEncoded() {
        return this._dictionaryEncoded;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getStoredType() {
        return this._storedType;
    }

    public int getLengthOfShortestElement() {
        return this._valueSizeInBytes;
    }

    public int getLengthOfLongestElement() {
        return this._valueSizeInBytes;
    }

    public int getDictId(int docId) {
        int bufferId = this.getBufferId(docId);
        return this._readers.get(bufferId).getInt(docId);
    }

    public void readDictIds(int[] docIds, int length, int[] dictIdBuffer) {
        if (this._readers.size() == 1) {
            this._readers.get(0).getReader().readIntValues(docIds, 0, 0, length, dictIdBuffer, 0);
        } else {
            for (int i = 0; i < length; ++i) {
                int docId = docIds[i];
                dictIdBuffer[i] = this._readers.get(this.getBufferId(docId)).getInt(docId);
            }
        }
    }

    public int getInt(int docId) {
        int bufferId = this.getBufferId(docId);
        return this._readers.get(bufferId).getInt(docId);
    }

    public long getLong(int docId) {
        int bufferId = this.getBufferId(docId);
        return this._readers.get(bufferId).getLong(docId);
    }

    public float getFloat(int docId) {
        int bufferId = this.getBufferId(docId);
        return this._readers.get(bufferId).getFloat(docId);
    }

    public double getDouble(int docId) {
        int bufferId = this.getBufferId(docId);
        return this._readers.get(bufferId).getDouble(docId);
    }

    public BigDecimal getBigDecimal(int docId) {
        int bufferId = this.getBufferId(docId);
        return this._readers.get(bufferId).getBigDecimal(docId);
    }

    private int getBufferId(int row) {
        return row / this._numRowsPerChunk;
    }

    public void setDictId(int docId, int dictId) {
        this.addBufferIfNeeded(docId);
        this.getWriterForRow(docId).setInt(docId, dictId);
    }

    public void setInt(int docId, int value) {
        this.addBufferIfNeeded(docId);
        this.getWriterForRow(docId).setInt(docId, value);
    }

    public void setLong(int docId, long value) {
        this.addBufferIfNeeded(docId);
        this.getWriterForRow(docId).setLong(docId, value);
    }

    public void setFloat(int docId, float value) {
        this.addBufferIfNeeded(docId);
        this.getWriterForRow(docId).setFloat(docId, value);
    }

    public void setDouble(int docId, double value) {
        this.addBufferIfNeeded(docId);
        this.getWriterForRow(docId).setDouble(docId, value);
    }

    public byte[] getBytes(int docId) {
        int bufferId = this.getBufferId(docId);
        return this._readers.get(bufferId).getBytes(docId);
    }

    public void setBytes(int docId, byte[] value) {
        Preconditions.checkArgument((value.length == this._valueSizeInBytes ? 1 : 0) != 0, (String)"Expected value size to be: %s but got: %s ", (int)this._valueSizeInBytes, (int)value.length);
        this.addBufferIfNeeded(docId);
        this.getWriterForRow(docId).setBytes(docId, value);
    }

    private WriterWithOffset getWriterForRow(int row) {
        return this._writers.get(this.getBufferId(row));
    }

    public void close() throws IOException {
        for (WriterWithOffset writer : this._writers) {
            writer.close();
        }
        for (ReaderWithOffset reader : this._readers) {
            reader.close();
        }
    }

    private void addBuffer() {
        LOGGER.info("Allocating {} bytes for: {}", (Object)this._chunkSizeInBytes, (Object)this._allocationContext);
        PinotDataBuffer buffer = this._memoryManager.allocate(this._chunkSizeInBytes, this._allocationContext);
        this._writers.add(new WriterWithOffset(new FixedByteSingleValueMultiColWriter(buffer, 1, new int[]{this._valueSizeInBytes}), this._capacityInRows));
        this._readers.add(new ReaderWithOffset(new FixedByteSingleValueMultiColReader(buffer, this._numRowsPerChunk, new int[]{this._valueSizeInBytes}), this._capacityInRows));
        this._capacityInRows += this._numRowsPerChunk;
    }

    private void addBufferIfNeeded(int row) {
        if (row >= this._capacityInRows) {
            long buffersNeeded = (row + 1 - this._capacityInRows + this._numRowsPerChunk) / this._numRowsPerChunk;
            int i = 0;
            while ((long)i < buffersNeeded) {
                this.addBuffer();
                ++i;
            }
        }
    }

    private static class ReaderWithOffset
    implements Closeable {
        final FixedByteSingleValueMultiColReader _reader;
        final int _startRowId;

        private ReaderWithOffset(FixedByteSingleValueMultiColReader reader, int startRowId) {
            this._reader = reader;
            this._startRowId = startRowId;
        }

        @Override
        public void close() throws IOException {
            this._reader.close();
        }

        public int getInt(int row) {
            return this._reader.getInt(row - this._startRowId, 0);
        }

        public long getLong(int row) {
            return this._reader.getLong(row - this._startRowId, 0);
        }

        public float getFloat(int row) {
            return this._reader.getFloat(row - this._startRowId, 0);
        }

        public double getDouble(int row) {
            return this._reader.getDouble(row - this._startRowId, 0);
        }

        public BigDecimal getBigDecimal(int row) {
            return BigDecimalUtils.deserialize((byte[])this._reader.getBytes(row - this._startRowId, 0));
        }

        public byte[] getBytes(int row) {
            return this._reader.getBytes(row - this._startRowId, 0);
        }

        public FixedByteSingleValueMultiColReader getReader() {
            return this._reader;
        }
    }

    private static class WriterWithOffset
    implements Closeable {
        final FixedByteSingleValueMultiColWriter _writer;
        final int _startRowId;

        private WriterWithOffset(FixedByteSingleValueMultiColWriter writer, int startRowId) {
            this._writer = writer;
            this._startRowId = startRowId;
        }

        @Override
        public void close() throws IOException {
            this._writer.close();
        }

        public void setInt(int row, int value) {
            this._writer.setInt(row - this._startRowId, 0, value);
        }

        public void setLong(int row, long value) {
            this._writer.setLong(row - this._startRowId, 0, value);
        }

        public void setFloat(int row, float value) {
            this._writer.setFloat(row - this._startRowId, 0, value);
        }

        public void setDouble(int row, double value) {
            this._writer.setDouble(row - this._startRowId, 0, value);
        }

        public void setBytes(int row, byte[] value) {
            this._writer.setBytes(row - this._startRowId, 0, value);
        }
    }
}

