/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.forward;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueFixedByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueUnsortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueVarByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueFixedByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueSortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueUnsortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueVarByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexType;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.ForwardIndexConfig;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class ForwardIndexCreatorFactory {
    private ForwardIndexCreatorFactory() {
    }

    public static ForwardIndexCreator createIndexCreator(IndexCreationContext context, ForwardIndexConfig indexConfig) throws Exception {
        String colName = context.getFieldSpec().getName();
        if (!context.hasDictionary()) {
            ChunkCompressionType chunkCompressionType = indexConfig.getChunkCompressionType();
            if (chunkCompressionType == null) {
                chunkCompressionType = ForwardIndexType.getDefaultCompressionType(context.getFieldSpec().getFieldType());
            }
            boolean deriveNumDocsPerChunk = indexConfig.isDeriveNumDocsPerChunk();
            int writerVersion = indexConfig.getRawIndexWriterVersion();
            if (context.getFieldSpec().isSingleValueField()) {
                return ForwardIndexCreatorFactory.getRawIndexCreatorForSVColumn(context.getIndexDir(), chunkCompressionType, colName, context.getFieldSpec().getDataType().getStoredType(), context.getTotalDocs(), context.getLengthOfLongestEntry(), deriveNumDocsPerChunk, writerVersion);
            }
            return ForwardIndexCreatorFactory.getRawIndexCreatorForMVColumn(context.getIndexDir(), chunkCompressionType, colName, context.getFieldSpec().getDataType().getStoredType(), context.getTotalDocs(), context.getMaxNumberOfMultiValueElements(), deriveNumDocsPerChunk, writerVersion, context.getMaxRowLengthInBytes());
        }
        if (context.getFieldSpec().isSingleValueField()) {
            if (context.isSorted()) {
                return new SingleValueSortedForwardIndexCreator(context.getIndexDir(), colName, context.getCardinality());
            }
            return new SingleValueUnsortedForwardIndexCreator(context.getIndexDir(), colName, context.getCardinality(), context.getTotalDocs());
        }
        return new MultiValueUnsortedForwardIndexCreator(context.getIndexDir(), colName, context.getCardinality(), context.getTotalDocs(), context.getTotalNumberOfEntries());
    }

    public static ForwardIndexCreator getRawIndexCreatorForSVColumn(File file, ChunkCompressionType compressionType, String column, FieldSpec.DataType dataType, int totalDocs, int lengthOfLongestEntry, boolean deriveNumDocsPerChunk, int writerVersion) throws IOException {
        switch (dataType.getStoredType()) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new SingleValueFixedByteRawIndexCreator(file, compressionType, column, totalDocs, dataType, writerVersion);
            }
            case BIG_DECIMAL: 
            case STRING: 
            case BYTES: {
                return new SingleValueVarByteRawIndexCreator(file, compressionType, column, totalDocs, dataType, lengthOfLongestEntry, deriveNumDocsPerChunk, writerVersion);
            }
        }
        throw new UnsupportedOperationException("Data type not supported for raw indexing: " + dataType);
    }

    public static ForwardIndexCreator getRawIndexCreatorForMVColumn(File file, ChunkCompressionType compressionType, String column, FieldSpec.DataType dataType, int totalDocs, int maxNumberOfMultiValueElements, boolean deriveNumDocsPerChunk, int writerVersion, int maxRowLengthInBytes) throws IOException {
        switch (dataType.getStoredType()) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new MultiValueFixedByteRawIndexCreator(file, compressionType, column, totalDocs, dataType, maxNumberOfMultiValueElements, deriveNumDocsPerChunk, writerVersion);
            }
            case STRING: 
            case BYTES: {
                return new MultiValueVarByteRawIndexCreator(file, compressionType, column, totalDocs, dataType, writerVersion, maxRowLengthInBytes, maxNumberOfMultiValueElements);
            }
        }
        throw new UnsupportedOperationException("Data type not supported for raw indexing: " + dataType);
    }
}

