/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.forward;

import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBitMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBitSVForwardIndexReaderV2;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedByteChunkMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedByteChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBytePower2ChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkSVForwardIndexReaderV4;
import org.apache.pinot.segment.local.segment.index.readers.sorted.SortedIndexReaderImpl;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.ForwardIndexConfig;
import org.apache.pinot.segment.spi.index.IndexReaderConstraintException;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

class ForwardIndexReaderFactory
extends IndexReaderFactory.Default<ForwardIndexConfig, ForwardIndexReader> {
    public static final ForwardIndexReaderFactory INSTANCE = new ForwardIndexReaderFactory();

    ForwardIndexReaderFactory() {
    }

    protected IndexType<ForwardIndexConfig, ForwardIndexReader, ?> getIndexType() {
        return StandardIndexes.forward();
    }

    protected ForwardIndexReader createIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata, ForwardIndexConfig indexConfig) throws IndexReaderConstraintException {
        return ForwardIndexReaderFactory.createIndexReader(dataBuffer, metadata);
    }

    public static ForwardIndexReader createIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata) {
        if (metadata.hasDictionary()) {
            if (metadata.isSingleValue()) {
                if (metadata.isSorted()) {
                    return new SortedIndexReaderImpl(dataBuffer, metadata.getCardinality());
                }
                return new FixedBitSVForwardIndexReaderV2(dataBuffer, metadata.getTotalDocs(), metadata.getBitsPerElement());
            }
            return new FixedBitMVForwardIndexReader(dataBuffer, metadata.getTotalDocs(), metadata.getTotalNumberOfEntries(), metadata.getBitsPerElement());
        }
        FieldSpec.DataType storedType = metadata.getDataType().getStoredType();
        if (metadata.isSingleValue()) {
            int version = dataBuffer.getInt(0);
            if (storedType.isFixedWidth()) {
                return version >= 4 ? new FixedBytePower2ChunkSVForwardIndexReader(dataBuffer, storedType) : new FixedByteChunkSVForwardIndexReader(dataBuffer, storedType);
            }
            if (version >= 4) {
                return new VarByteChunkSVForwardIndexReaderV4(dataBuffer, storedType);
            }
            return new VarByteChunkSVForwardIndexReader(dataBuffer, storedType);
        }
        return storedType.isFixedWidth() ? new FixedByteChunkMVForwardIndexReader(dataBuffer, storedType) : new VarByteChunkMVForwardIndexReader(dataBuffer, storedType);
    }
}

