/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.segment.local.segment.index.readers.BytesDictionary;
import org.apache.pinot.segment.local.segment.index.readers.DoubleDictionary;
import org.apache.pinot.segment.local.segment.index.readers.FloatDictionary;
import org.apache.pinot.segment.local.segment.index.readers.IntDictionary;
import org.apache.pinot.segment.local.segment.index.readers.LongDictionary;
import org.apache.pinot.segment.local.segment.index.readers.StringDictionary;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedByteChunkMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedByteChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkSVForwardIndexReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.utils.SegmentMetadataUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;

public class ColumnMinMaxValueGenerator {
    private final SegmentMetadata _segmentMetadata;
    private final SegmentDirectory.Writer _segmentWriter;
    private final ColumnMinMaxValueGeneratorMode _columnMinMaxValueGeneratorMode;
    private PropertiesConfiguration _segmentProperties;
    private boolean _minMaxValueAdded;

    public ColumnMinMaxValueGenerator(SegmentMetadata segmentMetadata, SegmentDirectory.Writer segmentWriter, ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode) {
        this._segmentMetadata = segmentMetadata;
        this._segmentWriter = segmentWriter;
        this._columnMinMaxValueGeneratorMode = columnMinMaxValueGeneratorMode;
    }

    public boolean needAddColumnMinMaxValue() {
        for (String column : this.getColumnsToAddMinMaxValue()) {
            if (!this.needAddColumnMinMaxValueForColumn(column)) continue;
            return true;
        }
        return false;
    }

    public void addColumnMinMaxValue() throws Exception {
        Preconditions.checkState((this._columnMinMaxValueGeneratorMode != ColumnMinMaxValueGeneratorMode.NONE ? 1 : 0) != 0);
        this._segmentProperties = SegmentMetadataUtils.getPropertiesConfiguration((SegmentMetadata)this._segmentMetadata);
        for (String column : this.getColumnsToAddMinMaxValue()) {
            this.addColumnMinMaxValueForColumn(column);
        }
        if (this._minMaxValueAdded) {
            SegmentMetadataUtils.savePropertiesConfiguration((PropertiesConfiguration)this._segmentProperties);
        }
    }

    private List<String> getColumnsToAddMinMaxValue() {
        Schema schema = this._segmentMetadata.getSchema();
        ArrayList<String> columnsToAddMinMaxValue = new ArrayList<String>();
        switch (this._columnMinMaxValueGeneratorMode) {
            case ALL: {
                for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
                    if (fieldSpec.isVirtualColumn()) continue;
                    columnsToAddMinMaxValue.add(fieldSpec.getName());
                }
                break;
            }
            case NON_METRIC: {
                for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
                    if (fieldSpec.isVirtualColumn() || fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) continue;
                    columnsToAddMinMaxValue.add(fieldSpec.getName());
                }
                break;
            }
            case TIME: {
                for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
                    if (fieldSpec.isVirtualColumn() || fieldSpec.getFieldType() != FieldSpec.FieldType.TIME && fieldSpec.getFieldType() != FieldSpec.FieldType.DATE_TIME) continue;
                    columnsToAddMinMaxValue.add(fieldSpec.getName());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported generator mode: " + this._columnMinMaxValueGeneratorMode);
            }
        }
        return columnsToAddMinMaxValue;
    }

    private boolean needAddColumnMinMaxValueForColumn(String columnName) {
        ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(columnName);
        return columnMetadata.getMinValue() == null && columnMetadata.getMaxValue() == null && !columnMetadata.isMinMaxValueInvalid();
    }

    /*
     * Unable to fully structure code
     */
    private void addColumnMinMaxValueForColumn(String columnName) throws Exception {
        block202: {
            columnMetadata = this._segmentMetadata.getColumnMetadataFor(columnName);
            if (columnMetadata.getMinValue() != null || columnMetadata.getMaxValue() != null) {
                return;
            }
            dataType = columnMetadata.getDataType().getStoredType();
            if (columnMetadata.hasDictionary()) {
                dictionaryBuffer = this._segmentWriter.getIndexFor(columnName, StandardIndexes.dictionary());
                length = columnMetadata.getCardinality();
                switch (1.$SwitchMap$org$apache$pinot$spi$data$FieldSpec$DataType[dataType.ordinal()]) {
                    case 1: {
                        intDictionary = new IntDictionary(dictionaryBuffer, length);
                        try {
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, intDictionary.getStringValue(0), intDictionary.getStringValue(length - 1), dataType);
                            break block202;
                        }
                        finally {
                            intDictionary.close();
                        }
                    }
                    case 2: {
                        longDictionary = new LongDictionary(dictionaryBuffer, length);
                        try {
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, longDictionary.getStringValue(0), longDictionary.getStringValue(length - 1), dataType);
                            break block202;
                        }
                        finally {
                            longDictionary.close();
                        }
                    }
                    case 3: {
                        floatDictionary = new FloatDictionary(dictionaryBuffer, length);
                        try {
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, floatDictionary.getStringValue(0), floatDictionary.getStringValue(length - 1), dataType);
                            break block202;
                        }
                        finally {
                            floatDictionary.close();
                        }
                    }
                    case 4: {
                        doubleDictionary = new DoubleDictionary(dictionaryBuffer, length);
                        try {
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, doubleDictionary.getStringValue(0), doubleDictionary.getStringValue(length - 1), dataType);
                            break block202;
                        }
                        finally {
                            doubleDictionary.close();
                        }
                    }
                    case 5: {
                        stringDictionary = new StringDictionary(dictionaryBuffer, length, columnMetadata.getColumnMaxLength());
                        try {
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, stringDictionary.getStringValue(0), stringDictionary.getStringValue(length - 1), dataType);
                            break block202;
                        }
                        finally {
                            stringDictionary.close();
                        }
                    }
                    case 6: {
                        bytesDictionary = new BytesDictionary(dictionaryBuffer, length, columnMetadata.getColumnMaxLength());
                        try {
                            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, bytesDictionary.getStringValue(0), bytesDictionary.getStringValue(length - 1), dataType);
                            break block202;
                        }
                        finally {
                            bytesDictionary.close();
                        }
                    }
                    default: {
                        throw new IllegalStateException("Unsupported data type: " + dataType + " for column: " + columnName);
                    }
                }
            }
            numDocs = columnMetadata.getTotalDocs();
            isSingleValueField = this._segmentMetadata.getSchema().getFieldSpecFor(columnName).isSingleValueField();
            forwardBuffer = this._segmentWriter.getIndexFor(columnName, StandardIndexes.forward());
            switch (1.$SwitchMap$org$apache$pinot$spi$data$FieldSpec$DataType[dataType.ordinal()]) {
                case 1: {
                    min = 0x7FFFFFFF;
                    max = -2147483648;
                    if (!isSingleValueField) ** GOTO lbl84
                    rawIndexReader = new FixedByteChunkSVForwardIndexReader(forwardBuffer, FieldSpec.DataType.INT);
                    try {
                        readerContext = rawIndexReader.createContext();
                        try {
                            for (docId = 0; docId < numDocs; ++docId) {
                                value = rawIndexReader.getInt(docId, readerContext);
                                min = Math.min(min, value);
                                max = Math.max(max, value);
                            }
                            ** GOTO lbl103
                        }
                        finally {
                            if (readerContext != null) {
                                readerContext.close();
                            }
                        }
                    }
                    finally {
                        rawIndexReader.close();
                    }
lbl84:
                    // 1 sources

                    rawIndexReader = new FixedByteChunkMVForwardIndexReader(forwardBuffer, FieldSpec.DataType.INT);
                    try {
                        readerContext = rawIndexReader.createContext();
                        try {
                            for (docId = 0; docId < numDocs; ++docId) {
                                value = rawIndexReader.getIntMV(docId, readerContext);
                                for (i = 0; i < value.length; ++i) {
                                    min = Math.min(min, value[i]);
                                    max = Math.max(max, value[i]);
                                }
                            }
                        }
                        finally {
                            if (readerContext != null) {
                                readerContext.close();
                            }
                        }
                    }
                    finally {
                        rawIndexReader.close();
                    }
lbl103:
                    // 2 sources

                    SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, String.valueOf(min), String.valueOf(max), dataType);
                    break;
                }
                case 2: {
                    min = 0x7FFFFFFFFFFFFFFFL;
                    max = -9223372036854775808L;
                    if (!isSingleValueField) ** GOTO lbl126
                    rawIndexReader = new FixedByteChunkSVForwardIndexReader(forwardBuffer, FieldSpec.DataType.LONG);
                    try {
                        readerContext = rawIndexReader.createContext();
                        try {
                            for (docId = 0; docId < numDocs; ++docId) {
                                value = rawIndexReader.getLong(docId, readerContext);
                                min = Math.min(min, value);
                                max = Math.max(max, value);
                            }
                            ** GOTO lbl145
                        }
                        finally {
                            if (readerContext != null) {
                                readerContext.close();
                            }
                        }
                    }
                    finally {
                        rawIndexReader.close();
                    }
lbl126:
                    // 1 sources

                    rawIndexReader = new FixedByteChunkMVForwardIndexReader(forwardBuffer, FieldSpec.DataType.LONG);
                    try {
                        readerContext = rawIndexReader.createContext();
                        try {
                            for (docId = 0; docId < numDocs; ++docId) {
                                value = rawIndexReader.getLongMV(docId, readerContext);
                                for (i = 0; i < value.length; ++i) {
                                    min = Math.min(min, value[i]);
                                    max = Math.max(max, value[i]);
                                }
                            }
                        }
                        finally {
                            if (readerContext != null) {
                                readerContext.close();
                            }
                        }
                    }
                    finally {
                        rawIndexReader.close();
                    }
lbl145:
                    // 2 sources

                    SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, String.valueOf(min), String.valueOf(max), dataType);
                    break;
                }
                case 3: {
                    min = 3.4028235E38f;
                    max = 1.4E-45f;
                    if (!isSingleValueField) ** GOTO lbl168
                    rawIndexReader = new FixedByteChunkSVForwardIndexReader(forwardBuffer, FieldSpec.DataType.FLOAT);
                    try {
                        readerContext = rawIndexReader.createContext();
                        try {
                            for (docId = 0; docId < numDocs; ++docId) {
                                value = rawIndexReader.getFloat(docId, readerContext);
                                min = Math.min(min, value);
                                max = Math.max(max, value);
                            }
                            ** GOTO lbl187
                        }
                        finally {
                            if (readerContext != null) {
                                readerContext.close();
                            }
                        }
                    }
                    finally {
                        rawIndexReader.close();
                    }
lbl168:
                    // 1 sources

                    rawIndexReader = new FixedByteChunkMVForwardIndexReader(forwardBuffer, FieldSpec.DataType.FLOAT);
                    try {
                        readerContext = rawIndexReader.createContext();
                        try {
                            for (docId = 0; docId < numDocs; ++docId) {
                                value = rawIndexReader.getFloatMV(docId, readerContext);
                                for (i = 0; i < value.length; ++i) {
                                    min = Math.min(min, value[i]);
                                    max = Math.max(max, value[i]);
                                }
                            }
                        }
                        finally {
                            if (readerContext != null) {
                                readerContext.close();
                            }
                        }
                    }
                    finally {
                        rawIndexReader.close();
                    }
lbl187:
                    // 2 sources

                    SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, String.valueOf(min), String.valueOf(max), dataType);
                    break;
                }
                case 4: {
                    min = 1.7976931348623157E308;
                    max = 4.9E-324;
                    if (!isSingleValueField) ** GOTO lbl210
                    rawIndexReader = new FixedByteChunkSVForwardIndexReader(forwardBuffer, FieldSpec.DataType.DOUBLE);
                    try {
                        readerContext = rawIndexReader.createContext();
                        try {
                            for (docId = 0; docId < numDocs; ++docId) {
                                value = rawIndexReader.getDouble(docId, readerContext);
                                min = Math.min(min, value);
                                max = Math.max(max, value);
                            }
                            ** GOTO lbl229
                        }
                        finally {
                            if (readerContext != null) {
                                readerContext.close();
                            }
                        }
                    }
                    finally {
                        rawIndexReader.close();
                    }
lbl210:
                    // 1 sources

                    rawIndexReader = new FixedByteChunkMVForwardIndexReader(forwardBuffer, FieldSpec.DataType.DOUBLE);
                    try {
                        readerContext = rawIndexReader.createContext();
                        try {
                            for (docId = 0; docId < numDocs; ++docId) {
                                value = rawIndexReader.getDoubleMV(docId, readerContext);
                                for (i = 0; i < value.length; ++i) {
                                    min = Math.min(min, value[i]);
                                    max = Math.max(max, value[i]);
                                }
                            }
                        }
                        finally {
                            if (readerContext != null) {
                                readerContext.close();
                            }
                        }
                    }
                    finally {
                        rawIndexReader.close();
                    }
lbl229:
                    // 2 sources

                    SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, String.valueOf(min), String.valueOf(max), dataType);
                    break;
                }
                case 5: {
                    min = null;
                    max = null;
                    if (!isSingleValueField) ** GOTO lbl254
                    rawIndexReader = new VarByteChunkSVForwardIndexReader(forwardBuffer, FieldSpec.DataType.STRING);
                    try {
                        readerContext = rawIndexReader.createContext();
                        try {
                            for (docId = 0; docId < numDocs; ++docId) {
                                value = rawIndexReader.getString(docId, readerContext);
                                if (min == null || StringUtils.compare((String)min, (String)value) > 0) {
                                    min = value;
                                }
                                if (max != null && StringUtils.compare((String)max, (String)value) >= 0) continue;
                                max = value;
                            }
                            ** GOTO lbl275
                        }
                        finally {
                            if (readerContext != null) {
                                readerContext.close();
                            }
                        }
                    }
                    finally {
                        rawIndexReader.close();
                    }
lbl254:
                    // 1 sources

                    rawIndexReader = new VarByteChunkMVForwardIndexReader(forwardBuffer, FieldSpec.DataType.STRING);
                    try {
                        readerContext = rawIndexReader.createContext();
                        try {
                            for (docId = 0; docId < numDocs; ++docId) {
                                value = rawIndexReader.getStringMV(docId, readerContext);
                                for (i = 0; i < value.length; ++i) {
                                    if (min == null || StringUtils.compare((String)min, (String)value[i]) > 0) {
                                        min = value[i];
                                    }
                                    if (max != null && StringUtils.compare((String)max, (String)value[i]) >= 0) continue;
                                    max = value[i];
                                }
                            }
                        }
                        finally {
                            if (readerContext != null) {
                                readerContext.close();
                            }
                        }
                    }
                    finally {
                        rawIndexReader.close();
                    }
lbl275:
                    // 2 sources

                    SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, min, max, dataType);
                    break;
                }
                case 6: {
                    min = null;
                    max = null;
                    if (!isSingleValueField) ** GOTO lbl300
                    rawIndexReader = new VarByteChunkSVForwardIndexReader(forwardBuffer, FieldSpec.DataType.BYTES);
                    try {
                        readerContext = rawIndexReader.createContext();
                        try {
                            for (docId = 0; docId < numDocs; ++docId) {
                                value = rawIndexReader.getBytes(docId, readerContext);
                                if (min == null || ByteArray.compare((byte[])value, (byte[])min) > 0) {
                                    min = value;
                                }
                                if (max != null && ByteArray.compare((byte[])value, (byte[])max) >= 0) continue;
                                max = value;
                            }
                            ** GOTO lbl321
                        }
                        finally {
                            if (readerContext != null) {
                                readerContext.close();
                            }
                        }
                    }
                    finally {
                        rawIndexReader.close();
                    }
lbl300:
                    // 1 sources

                    rawIndexReader = new VarByteChunkMVForwardIndexReader(forwardBuffer, FieldSpec.DataType.BYTES);
                    try {
                        readerContext = rawIndexReader.createContext();
                        try {
                            for (docId = 0; docId < numDocs; ++docId) {
                                value = rawIndexReader.getBytesMV(docId, readerContext);
                                for (i = 0; i < value.length; ++i) {
                                    if (min == null || ByteArray.compare((byte[])value[i], (byte[])min) > 0) {
                                        min = value[i];
                                    }
                                    if (max != null && ByteArray.compare((byte[])value[i], (byte[])max) >= 0) continue;
                                    max = value[i];
                                }
                            }
                        }
                        finally {
                            if (readerContext != null) {
                                readerContext.close();
                            }
                        }
                    }
                    finally {
                        rawIndexReader.close();
                    }
lbl321:
                    // 2 sources

                    SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, BytesUtils.toHexString((byte[])min), BytesUtils.toHexString(max), dataType);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported data type: " + dataType + " for column: " + columnName);
                }
            }
        }
        this._minMaxValueAdded = true;
    }
}

