/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.range;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.creator.impl.inv.BitSlicedRangeIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.RangeIndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.ConfigurableFromIndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.RangeIndexHandler;
import org.apache.pinot.segment.local.segment.index.readers.BitSlicedRangeIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.RangeIndexReaderImpl;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.AbstractIndexType;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexReaderConstraintException;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.RangeIndexConfig;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.CombinedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.reader.RangeIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class RangeIndexType
extends AbstractIndexType<RangeIndexConfig, RangeIndexReader, CombinedInvertedIndexCreator>
implements ConfigurableFromIndexLoadingConfig<RangeIndexConfig> {
    public static final String INDEX_DISPLAY_NAME = "range";

    protected RangeIndexType() {
        super("range_index");
    }

    public Class<RangeIndexConfig> getIndexConfigClass() {
        return RangeIndexConfig.class;
    }

    @Override
    public Map<String, RangeIndexConfig> fromIndexLoadingConfig(IndexLoadingConfig indexLoadingConfig) {
        int rangeVersion = indexLoadingConfig.getRangeIndexVersion();
        return indexLoadingConfig.getRangeIndexColumns().stream().collect(Collectors.toMap(Function.identity(), c -> new RangeIndexConfig(rangeVersion)));
    }

    public RangeIndexConfig getDefaultConfig() {
        return RangeIndexConfig.DISABLED;
    }

    public String getPrettyName() {
        return INDEX_DISPLAY_NAME;
    }

    public ColumnConfigDeserializer<RangeIndexConfig> createDeserializer() {
        return IndexConfigDeserializer.fromIndexes((String)this.getPrettyName(), this.getIndexConfigClass()).withExclusiveAlternative((tableConfig, schema) -> {
            if (tableConfig.getIndexingConfig() == null) {
                return Collections.emptyMap();
            }
            List rangeIndexColumns = tableConfig.getIndexingConfig().getRangeIndexColumns();
            if (rangeIndexColumns == null) {
                return Collections.emptyMap();
            }
            int rangeVersion = tableConfig.getIndexingConfig().getRangeIndexVersion();
            if (rangeVersion == 0) {
                rangeVersion = RangeIndexConfig.DEFAULT.getVersion();
            }
            HashMap<String, RangeIndexConfig> result = new HashMap<String, RangeIndexConfig>();
            for (String col : rangeIndexColumns) {
                result.put(col, new RangeIndexConfig(rangeVersion));
            }
            return result;
        });
    }

    public CombinedInvertedIndexCreator createIndexCreator(IndexCreationContext context, RangeIndexConfig indexConfig) throws IOException {
        if (indexConfig.getVersion() == 2 && context.getFieldSpec().isSingleValueField()) {
            if (context.hasDictionary()) {
                return new BitSlicedRangeIndexCreator(context.getIndexDir(), context.getFieldSpec(), context.getCardinality());
            }
            return new BitSlicedRangeIndexCreator(context.getIndexDir(), context.getFieldSpec(), context.getMinValue(), context.getMaxValue());
        }
        return new RangeIndexCreator(context.getIndexDir(), context.getFieldSpec(), context.hasDictionary() ? FieldSpec.DataType.INT : context.getFieldSpec().getDataType(), -1, -1, context.getTotalDocs(), context.getTotalNumberOfEntries());
    }

    protected IndexReaderFactory<RangeIndexReader> createReaderFactory() {
        return ReaderFactory.INSTANCE;
    }

    public static RangeIndexReader read(PinotDataBuffer dataBuffer, ColumnMetadata metadata) throws IndexReaderConstraintException {
        return ReaderFactory.read(dataBuffer, metadata);
    }

    public String getFileExtension(ColumnMetadata columnMetadata) {
        return ".bitmap.range";
    }

    public IndexHandler createIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> configsByCol, @Nullable Schema schema, @Nullable TableConfig tableConfig) {
        return new RangeIndexHandler(segmentDirectory, configsByCol, tableConfig);
    }

    protected void handleIndexSpecificCleanup(TableConfig tableConfig) {
        tableConfig.getIndexingConfig().setRangeIndexColumns(null);
    }

    private static class ReaderFactory
    extends IndexReaderFactory.Default<RangeIndexConfig, RangeIndexReader> {
        public static final ReaderFactory INSTANCE = new ReaderFactory();

        private ReaderFactory() {
        }

        protected IndexType<RangeIndexConfig, RangeIndexReader, ?> getIndexType() {
            return StandardIndexes.range();
        }

        protected RangeIndexReader createIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata, RangeIndexConfig indexConfig) throws IndexReaderConstraintException {
            return ReaderFactory.read(dataBuffer, metadata);
        }

        public static RangeIndexReader read(PinotDataBuffer dataBuffer, ColumnMetadata metadata) throws IndexReaderConstraintException {
            int version = dataBuffer.getInt(0);
            if (version == 1) {
                return new RangeIndexReaderImpl(dataBuffer);
            }
            if (version == 2) {
                return new BitSlicedRangeIndexReader(dataBuffer, metadata);
            }
            throw new IndexReaderConstraintException(metadata.getColumnName(), StandardIndexes.range(), "Unknown range index version " + version);
        }
    }
}

