/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import java.math.BigDecimal;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;

public class BigDecimalDictionary
extends BaseImmutableDictionary {
    public BigDecimalDictionary(PinotDataBuffer dataBuffer, int length, int numBytesPerValue) {
        super(dataBuffer, length, numBytesPerValue);
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.BIG_DECIMAL;
    }

    public int indexOf(BigDecimal bigDecimalValue) {
        return this.binarySearch(bigDecimalValue);
    }

    public int insertionIndexOf(String stringValue) {
        return this.binarySearch(new BigDecimal(stringValue));
    }

    @Override
    public BigDecimal getMinVal() {
        return BigDecimalUtils.deserialize((byte[])this.getBytes(0));
    }

    @Override
    public BigDecimal getMaxVal() {
        return BigDecimalUtils.deserialize((byte[])this.getBytes(this.length() - 1));
    }

    public BigDecimal get(int dictId) {
        return this.getBigDecimal(dictId);
    }

    public int getIntValue(int dictId) {
        return this.getBigDecimal(dictId).intValue();
    }

    public long getLongValue(int dictId) {
        return this.getBigDecimal(dictId).longValue();
    }

    public float getFloatValue(int dictId) {
        return this.getBigDecimal(dictId).floatValue();
    }

    public double getDoubleValue(int dictId) {
        return this.getBigDecimal(dictId).doubleValue();
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return this.getBigDecimal(dictId);
    }

    public String getStringValue(int dictId) {
        return this.getBigDecimal(dictId).toPlainString();
    }

    public byte[] getBytesValue(int dictId) {
        return this.getBytes(dictId);
    }
}

