/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.text;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.pinot.segment.local.segment.index.readers.BitmapInvertedIndexReader;
import org.apache.pinot.segment.local.utils.nativefst.FST;
import org.apache.pinot.segment.local.utils.nativefst.ImmutableFST;
import org.apache.pinot.segment.local.utils.nativefst.utils.RegexpMatcher;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeTextIndexReader
implements TextIndexReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeTextIndexReader.class);
    private final String _column;
    private final PinotDataBuffer _buffer;
    private FST _fst;
    private BitmapInvertedIndexReader _invertedIndex;

    public NativeTextIndexReader(String column, File indexDir) {
        this._column = column;
        try {
            String desc = "Native text index buffer: " + column;
            File indexFile = this.getTextIndexFile(indexDir);
            this._buffer = PinotDataBuffer.mapFile((File)indexFile, (boolean)true, (long)0L, (long)indexFile.length(), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)desc);
            this.populateIndexes();
        }
        catch (Exception e) {
            LOGGER.error("Failed to instantiate native text index reader for column {}, exception {}", (Object)column, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private File getTextIndexFile(File segmentIndexDir) {
        File file = SegmentDirectoryPaths.findNativeTextIndexIndexFile((File)segmentIndexDir, (String)this._column);
        if (file == null) {
            throw new IllegalStateException("Failed to find text index file for column: " + this._column);
        }
        return file;
    }

    private void populateIndexes() {
        int fstMagic = this._buffer.getInt(0);
        Preconditions.checkState((fstMagic == 1550218081 ? 1 : 0) != 0, (String)"Invalid native text index magic header: %s", (int)fstMagic);
        int version = this._buffer.getInt(4);
        Preconditions.checkState((version == 1 ? 1 : 0) != 0, (String)"Unsupported native text index version: %s", (int)version);
        int fstDataLength = this._buffer.getInt(8);
        long invertedIndexLength = this._buffer.getLong(12);
        int numBitMaps = this._buffer.getInt(20);
        long fstDataStartOffset = 24L;
        long fstDataEndOffset = fstDataStartOffset + (long)fstDataLength;
        ByteBuffer byteBuffer = this._buffer.toDirectByteBuffer(fstDataStartOffset, fstDataLength);
        try {
            this._fst = FST.read((InputStream)new ByteBufferInputStream(Collections.singletonList(byteBuffer)), ImmutableFST.class, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        long invertedIndexEndOffset = fstDataEndOffset + invertedIndexLength;
        this._invertedIndex = new BitmapInvertedIndexReader(this._buffer.view(fstDataEndOffset, invertedIndexEndOffset, ByteOrder.BIG_ENDIAN), numBitMaps);
    }

    public ImmutableRoaringBitmap getDictIds(String searchQuery) {
        throw new UnsupportedOperationException("");
    }

    public MutableRoaringBitmap getDocIds(String searchQuery) {
        try {
            MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
            RegexpMatcher.regexMatch(searchQuery, this._fst, dictId -> matchingDocIds.or(this._invertedIndex.getDocIds(dictId)));
            return matchingDocIds;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while running query: " + searchQuery, e);
        }
    }

    public void close() throws IOException {
        this._buffer.close();
    }
}

