/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.text;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.NativeMutableTextIndex;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneTextIndex;
import org.apache.pinot.segment.local.segment.creator.impl.text.LuceneTextIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.text.NativeTextIndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.ConfigurableFromIndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.TextIndexHandler;
import org.apache.pinot.segment.local.segment.index.readers.text.LuceneTextIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.text.NativeTextIndexReader;
import org.apache.pinot.segment.local.segment.index.text.TextIndexConfigBuilder;
import org.apache.pinot.segment.local.segment.store.TextIndexUtils;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.AbstractIndexType;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexReaderConstraintException;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.TextIndexConfig;
import org.apache.pinot.segment.spi.index.creator.TextIndexCreator;
import org.apache.pinot.segment.spi.index.mutable.MutableIndex;
import org.apache.pinot.segment.spi.index.mutable.provider.MutableIndexContext;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.FSTType;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIndexType
extends AbstractIndexType<TextIndexConfig, TextIndexReader, TextIndexCreator>
implements ConfigurableFromIndexLoadingConfig<TextIndexConfig> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TextIndexType.class);
    public static final String INDEX_DISPLAY_NAME = "text";

    protected TextIndexType() {
        super("text_index");
    }

    public Class<TextIndexConfig> getIndexConfigClass() {
        return TextIndexConfig.class;
    }

    @Override
    public Map<String, TextIndexConfig> fromIndexLoadingConfig(IndexLoadingConfig indexLoadingConfig) {
        Map<String, Map<String, String>> allColProps = indexLoadingConfig.getColumnProperties();
        return indexLoadingConfig.getTextIndexColumns().stream().collect(Collectors.toMap(Function.identity(), colName -> new TextIndexConfigBuilder(indexLoadingConfig.getFSTIndexType()).withProperties((Map)allColProps.get(colName)).build()));
    }

    public TextIndexConfig getDefaultConfig() {
        return TextIndexConfig.DISABLED;
    }

    public String getPrettyName() {
        return INDEX_DISPLAY_NAME;
    }

    public ColumnConfigDeserializer<TextIndexConfig> createDeserializer() {
        return IndexConfigDeserializer.fromIndexes((String)this.getPrettyName(), this.getIndexConfigClass()).withExclusiveAlternative((tableConfig, schema) -> {
            List fieldConfigList = tableConfig.getFieldConfigList();
            if (fieldConfigList == null) {
                return Collections.emptyMap();
            }
            HashMap<String, TextIndexConfig> result = new HashMap<String, TextIndexConfig>();
            for (FieldConfig fieldConfig : fieldConfigList) {
                if (!fieldConfig.getIndexTypes().contains(FieldConfig.IndexType.TEXT)) continue;
                String column = fieldConfig.getName();
                Map properties = fieldConfig.getProperties();
                FSTType fstType = TextIndexUtils.isFstTypeNative(properties) ? FSTType.NATIVE : FSTType.LUCENE;
                result.put(column, new TextIndexConfigBuilder(fstType).withProperties(properties).build());
            }
            return result;
        });
    }

    public TextIndexCreator createIndexCreator(IndexCreationContext context, TextIndexConfig indexConfig) throws IOException {
        Preconditions.checkState((context.getFieldSpec().getDataType().getStoredType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"Text index is currently only supported on STRING type columns");
        if (indexConfig.getFstType() == FSTType.NATIVE) {
            return new NativeTextIndexCreator(context.getFieldSpec().getName(), context.getIndexDir());
        }
        return new LuceneTextIndexCreator(context, indexConfig);
    }

    protected IndexReaderFactory<TextIndexReader> createReaderFactory() {
        return ReaderFactory.INSTANCE;
    }

    public IndexHandler createIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> configsByCol, @Nullable Schema schema, @Nullable TableConfig tableConfig) {
        return new TextIndexHandler(segmentDirectory, configsByCol, tableConfig);
    }

    public String getFileExtension(ColumnMetadata columnMetadata) {
        return ".lucene.index";
    }

    @Nullable
    public MutableIndex createMutableIndex(MutableIndexContext context, TextIndexConfig config) {
        if (config.isDisabled()) {
            return null;
        }
        if (config.getFstType() == FSTType.NATIVE) {
            return new NativeMutableTextIndex(context.getFieldSpec().getName());
        }
        if (context.getConsumerDir() == null) {
            throw new IllegalArgumentException("A consumer directory is required");
        }
        return new RealtimeLuceneTextIndex(context.getFieldSpec().getName(), context.getConsumerDir(), context.getSegmentName(), config.getStopWordsInclude(), config.getStopWordsExclude(), config.isLuceneUseCompoundFile(), config.getLuceneMaxBufferSizeMB());
    }

    private static class ReaderFactory
    implements IndexReaderFactory<TextIndexReader> {
        public static final ReaderFactory INSTANCE = new ReaderFactory();

        private ReaderFactory() {
        }

        @Nullable
        public TextIndexReader createIndexReader(SegmentDirectory.Reader segmentReader, FieldIndexConfigs fieldIndexConfigs, ColumnMetadata metadata) throws IndexReaderConstraintException {
            if (metadata.getDataType() != FieldSpec.DataType.STRING) {
                throw new IndexReaderConstraintException(metadata.getColumnName(), StandardIndexes.text(), "Text index is currently only supported on STRING type columns");
            }
            File segmentDir = segmentReader.toSegmentDirectory().getPath().toFile();
            FSTType textIndexFSTType = TextIndexUtils.getFSTTypeOfIndex(segmentDir, metadata.getColumnName());
            if (textIndexFSTType == FSTType.NATIVE) {
                return new NativeTextIndexReader(metadata.getColumnName(), segmentDir);
            }
            TextIndexConfig indexConfig = (TextIndexConfig)fieldIndexConfigs.getConfig(StandardIndexes.text());
            return new LuceneTextIndexReader(metadata.getColumnName(), segmentDir, metadata.getTotalDocs(), indexConfig);
        }
    }
}

