/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.virtualcolumn;

import org.apache.pinot.segment.local.segment.index.column.DefaultNullValueVirtualColumnProvider;
import org.apache.pinot.segment.local.segment.virtualcolumn.DocIdVirtualColumnProvider;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnContext;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnProvider;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.utils.NetUtils;

public class VirtualColumnProviderFactory {
    private VirtualColumnProviderFactory() {
    }

    public static VirtualColumnProvider buildProvider(VirtualColumnContext virtualColumnContext) {
        String virtualColumnProvider = virtualColumnContext.getFieldSpec().getVirtualColumnProvider();
        try {
            return (VirtualColumnProvider)PluginManager.get().createInstance(virtualColumnProvider);
        }
        catch (Exception e) {
            throw new IllegalStateException("Caught exception while creating instance of: " + virtualColumnProvider, e);
        }
    }

    public static void addBuiltInVirtualColumnsToSegmentSchema(Schema schema, String segmentName) {
        if (!schema.hasColumn("$docId")) {
            schema.addField((FieldSpec)new DimensionFieldSpec("$docId", FieldSpec.DataType.INT, true, DocIdVirtualColumnProvider.class));
        }
        if (!schema.hasColumn("$hostName")) {
            schema.addField((FieldSpec)new DimensionFieldSpec("$hostName", FieldSpec.DataType.STRING, true, DefaultNullValueVirtualColumnProvider.class, (Object)NetUtils.getHostnameOrAddress()));
        }
        if (!schema.hasColumn("$segmentName")) {
            schema.addField((FieldSpec)new DimensionFieldSpec("$segmentName", FieldSpec.DataType.STRING, true, DefaultNullValueVirtualColumnProvider.class, (Object)segmentName));
        }
    }
}

