/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree.v2.builder;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeIndexMapUtils;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Constants;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;

public class StarTreeIndexSeparator
implements Closeable {
    private final FileChannel _indexFileChannel;
    private final List<Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>> _indexMapList;
    private final List<StarTreeV2BuilderConfig> _builderConfigList;
    private final List<Integer> _totalDocsList;

    public StarTreeIndexSeparator(File indexMapFile, File indexFile, PropertiesConfiguration metadataProperties) throws IOException {
        this._indexMapList = this.extractIndexMap(indexMapFile, metadataProperties.getInt("startree.v2.count"));
        this._indexFileChannel = new RandomAccessFile(indexFile, "r").getChannel();
        this._builderConfigList = this.extractBuilderConfigs(metadataProperties);
        this._totalDocsList = this.extractTotalDocsList(metadataProperties);
    }

    private List<Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>> extractIndexMap(File indexMapFile, int numStarTrees) {
        List<Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>> list;
        FileInputStream inputStream = new FileInputStream(indexMapFile);
        try {
            list = StarTreeIndexMapUtils.loadFromInputStream(inputStream, numStarTrees);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)inputStream).close();
        return list;
    }

    public List<Integer> extractTotalDocsList(PropertiesConfiguration metadataProperties) {
        ArrayList<Integer> totalDocsList = new ArrayList<Integer>(this._indexMapList.size());
        for (int i = 0; i < this._indexMapList.size(); ++i) {
            Configuration metadata = metadataProperties.subset(StarTreeV2Constants.MetadataKey.getStarTreePrefix((int)i));
            totalDocsList.add(i, metadata.getInt("total.docs"));
        }
        return totalDocsList;
    }

    public List<StarTreeV2BuilderConfig> extractBuilderConfigs(PropertiesConfiguration metadataProperties) {
        ArrayList<StarTreeV2BuilderConfig> builderConfigList = new ArrayList<StarTreeV2BuilderConfig>(this._indexMapList.size());
        for (int i = 0; i < this._indexMapList.size(); ++i) {
            Configuration metadata = metadataProperties.subset(StarTreeV2Constants.MetadataKey.getStarTreePrefix((int)i));
            builderConfigList.add(i, StarTreeV2BuilderConfig.fromIndexConfig(new StarTreeIndexConfig((List)Lists.newArrayList((Object[])metadata.getStringArray("split.order")), (List)Lists.newArrayList((Object[])metadata.getStringArray("skip.star.node.creation")), (List)Lists.newArrayList((Object[])metadata.getStringArray("function.column.pairs")), metadata.getInt("max.leaf.records"))));
        }
        return builderConfigList;
    }

    public int separate(File starTreeOutputDir, StarTreeV2BuilderConfig builderConfig) throws IOException {
        int treeIndex = this._builderConfigList.indexOf(builderConfig);
        if (treeIndex == -1) {
            return -1;
        }
        this.separate(starTreeOutputDir, treeIndex);
        return this._totalDocsList.get(treeIndex);
    }

    private void separate(File starTreeOutputDir, int treeIndex) throws IOException {
        Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue> indexMap = this._indexMapList.get(treeIndex);
        FileUtils.forceMkdir((File)starTreeOutputDir);
        for (StarTreeIndexMapUtils.IndexKey key : indexMap.keySet()) {
            switch (key._indexType) {
                case STAR_TREE: {
                    File destIndexFile = new File(starTreeOutputDir, "star_tree.index");
                    this.writeIndexToFile(destIndexFile, indexMap.get(key));
                    break;
                }
                case FORWARD_INDEX: {
                    String suffix = key._column.contains("__") ? ".sv.raw.fwd" : ".sv.unsorted.fwd";
                    File destIndexFile = new File(starTreeOutputDir, key._column + suffix);
                    this.writeIndexToFile(destIndexFile, indexMap.get(key));
                    break;
                }
            }
        }
    }

    private void writeIndexToFile(File destFile, StarTreeIndexMapUtils.IndexValue value) throws IOException {
        try (FileChannel dest = new RandomAccessFile(destFile, "rw").getChannel();){
            org.apache.pinot.common.utils.FileUtils.transferBytes((FileChannel)this._indexFileChannel, (long)value._offset, (long)value._size, (FileChannel)dest);
        }
    }

    @Override
    public void close() throws IOException {
        this._indexFileChannel.close();
    }
}

