/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree.v2.store;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.spi.env.CommonsConfigurationUtils;

public class StarTreeIndexMapUtils {
    public static final IndexKey STAR_TREE_INDEX_KEY = new IndexKey(IndexType.STAR_TREE, null);
    private static final char KEY_SEPARATOR = '.';
    private static final String KEY_TEMPLATE = "%d.%s.%s.%s";
    private static final String OFFSET_SUFFIX = "OFFSET";
    private static final String SIZE_SUFFIX = "SIZE";

    private StarTreeIndexMapUtils() {
    }

    public static void storeToFile(List<List<Pair<IndexKey, IndexValue>>> indexMaps, File indexMapFile) {
        Preconditions.checkState((!indexMapFile.exists() ? 1 : 0) != 0, (Object)"Star-tree index map file already exists");
        PropertiesConfiguration configuration = CommonsConfigurationUtils.fromFile((File)indexMapFile);
        int numStarTrees = indexMaps.size();
        for (int i = 0; i < numStarTrees; ++i) {
            List<Pair<IndexKey, IndexValue>> indexMap = indexMaps.get(i);
            for (Pair<IndexKey, IndexValue> entry : indexMap) {
                IndexKey key = (IndexKey)entry.getKey();
                IndexValue value = (IndexValue)entry.getValue();
                configuration.addProperty(key.getPropertyName(i, OFFSET_SUFFIX), (Object)value._offset);
                configuration.addProperty(key.getPropertyName(i, SIZE_SUFFIX), (Object)value._size);
            }
        }
        CommonsConfigurationUtils.saveToFile((PropertiesConfiguration)configuration, (File)indexMapFile);
    }

    public static List<Map<IndexKey, IndexValue>> loadFromInputStream(InputStream indexMapInputStream, int numStarTrees) {
        ArrayList<Map<IndexKey, IndexValue>> indexMaps = new ArrayList<Map<IndexKey, IndexValue>>(numStarTrees);
        for (int i = 0; i < numStarTrees; ++i) {
            indexMaps.add(new HashMap());
        }
        PropertiesConfiguration configuration = CommonsConfigurationUtils.fromInputStream((InputStream)indexMapInputStream);
        for (String key : CommonsConfigurationUtils.getKeys((Configuration)configuration)) {
            Object[] split = StringUtils.split((String)key, (char)'.');
            int starTreeId = Integer.parseInt(split[0]);
            Map indexMap = (Map)indexMaps.get(starTreeId);
            int columnSplitEndIndex = split.length - 2;
            String column = columnSplitEndIndex == 2 ? split[1] : StringUtils.join((Object[])split, (char)'.', (int)1, (int)columnSplitEndIndex);
            IndexType indexType = IndexType.valueOf((String)split[columnSplitEndIndex]);
            IndexKey indexKey = indexType == IndexType.STAR_TREE ? STAR_TREE_INDEX_KEY : new IndexKey(IndexType.FORWARD_INDEX, column);
            IndexValue indexValue = indexMap.computeIfAbsent(indexKey, k -> new IndexValue());
            long value = configuration.getLong(key);
            if (((String)split[columnSplitEndIndex + 1]).equals(OFFSET_SUFFIX)) {
                indexValue._offset = value;
                continue;
            }
            indexValue._size = value;
        }
        return indexMaps;
    }

    public static class IndexValue
    implements Comparable<IndexValue> {
        public long _offset;
        public long _size;

        public IndexValue() {
        }

        public IndexValue(long offset, long size) {
            this._offset = offset;
            this._size = size;
        }

        @Override
        public int compareTo(@Nonnull IndexValue o) {
            return Long.compare(this._offset, o._offset);
        }
    }

    public static class IndexKey
    implements Comparable<IndexKey> {
        public final IndexType _indexType;
        public final String _column;

        public IndexKey(IndexType indexType, @Nullable String column) {
            this._indexType = indexType;
            this._column = column;
        }

        public String getPropertyName(int starTreeId, String suffix) {
            return String.format(StarTreeIndexMapUtils.KEY_TEMPLATE, new Object[]{starTreeId, this._column, this._indexType, suffix});
        }

        public int hashCode() {
            return 31 * this._indexType.hashCode() + Objects.hashCode(this._column);
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof IndexKey) {
                IndexKey that = (IndexKey)obj;
                return this._indexType == that._indexType && Objects.equals(this._column, that._column);
            }
            return false;
        }

        @Override
        public int compareTo(IndexKey other) {
            return Comparator.comparing(i -> i._column, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(i -> i._indexType).compare(this, other);
        }
    }

    public static enum IndexType {
        STAR_TREE,
        FORWARD_INDEX;

    }
}

