/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.local.function.FunctionEvaluatorFactory;
import org.apache.pinot.segment.local.utils.TableConfigUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.TimeFieldSpec;
import org.apache.pinot.spi.data.TimeGranularitySpec;
import org.apache.pinot.spi.utils.TimeUtils;

public class SchemaUtils {
    private static final Map<Character, Integer> DATETIME_PATTERN_ORDERING = new HashMap<Character, Integer>();
    public static final String MAP_KEY_COLUMN_SUFFIX = "__KEYS";
    public static final String MAP_VALUE_COLUMN_SUFFIX = "__VALUES";

    private SchemaUtils() {
    }

    public static void validate(Schema schema, List<TableConfig> tableConfigs) {
        SchemaUtils.validate(schema, tableConfigs, false);
    }

    public static void validate(Schema schema, List<TableConfig> tableConfigs, @Nullable boolean isIgnoreCase) {
        for (TableConfig tableConfig : tableConfigs) {
            SchemaUtils.validateCompatibilityWithTableConfig(schema, tableConfig);
        }
        SchemaUtils.validate(schema, isIgnoreCase);
    }

    public static void validate(Schema schema) {
        SchemaUtils.validate(schema, false);
    }

    public static void validate(Schema schema, boolean isIgnoreCase) {
        schema.validate();
        if (isIgnoreCase) {
            HashSet<String> lowerCaseColumnNames = new HashSet<String>();
            for (String column : schema.getColumnNames()) {
                Preconditions.checkState((boolean)lowerCaseColumnNames.add(column.toLowerCase()), (String)"When enable case insensitive, you can't use the same lowercase column name: %s", (Object)column.toLowerCase());
            }
        }
        HashSet<String> transformedColumns = new HashSet<String>();
        HashSet<String> argumentColumns = new HashSet<String>();
        HashSet<String> primaryKeyColumnCandidates = new HashSet<String>();
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn()) continue;
            String column = fieldSpec.getName();
            Preconditions.checkState((!StringUtils.containsWhitespace((CharSequence)column) ? 1 : 0) != 0, (String)"The column name \"%s\" should not contain blank space.", (Object)column);
            primaryKeyColumnCandidates.add(column);
            String transformFunction = fieldSpec.getTransformFunction();
            if (transformFunction != null) {
                try {
                    List<String> arguments = FunctionEvaluatorFactory.getExpressionEvaluator(fieldSpec).getArguments();
                    Preconditions.checkState((!arguments.contains(column) ? 1 : 0) != 0, (String)"The arguments of transform function %s should not contain the destination column %s", (Object)transformFunction, (Object)column);
                    transformedColumns.add(column);
                    argumentColumns.addAll(arguments);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Exception in getting arguments for transform function '" + transformFunction + "' for column '" + column + "'", e);
                }
            }
            if (fieldSpec.getFieldType().equals((Object)FieldSpec.FieldType.TIME)) {
                SchemaUtils.validateTimeFieldSpec((TimeFieldSpec)fieldSpec);
            }
            if (!fieldSpec.getFieldType().equals((Object)FieldSpec.FieldType.DATE_TIME)) continue;
            SchemaUtils.validateDateTimeFieldSpec((DateTimeFieldSpec)fieldSpec);
        }
        Preconditions.checkState((boolean)Collections.disjoint(transformedColumns, argumentColumns), (String)"Columns: %s are a result of transformations, and cannot be used as arguments to other transform functions", (Object)transformedColumns.retainAll(argumentColumns));
        if (schema.getPrimaryKeyColumns() != null) {
            for (String primaryKeyColumn : schema.getPrimaryKeyColumns()) {
                Preconditions.checkState((boolean)primaryKeyColumnCandidates.contains(primaryKeyColumn), (Object)"The primary key column must exist");
            }
        }
    }

    private static void validateCompatibilityWithTableConfig(Schema schema, TableConfig tableConfig) {
        try {
            TableConfigUtils.validate(tableConfig, schema);
        }
        catch (Exception e) {
            throw new IllegalStateException("Schema is incompatible with tableConfig with name: " + tableConfig.getTableName() + " and type: " + tableConfig.getTableType(), e);
        }
    }

    private static void validateTimeFieldSpec(TimeFieldSpec timeFieldSpec) {
        TimeGranularitySpec outgoingGranularitySpec;
        TimeGranularitySpec incomingGranularitySpec = timeFieldSpec.getIncomingGranularitySpec();
        if (!incomingGranularitySpec.equals((Object)(outgoingGranularitySpec = timeFieldSpec.getOutgoingGranularitySpec()))) {
            Preconditions.checkState((!incomingGranularitySpec.getName().equals(outgoingGranularitySpec.getName()) ? 1 : 0) != 0, (String)"Cannot convert from incoming field spec %s to outgoing field spec %s if name is the same", (Object)incomingGranularitySpec, (Object)outgoingGranularitySpec);
            Preconditions.checkState((incomingGranularitySpec.getTimeFormat().equals(TimeGranularitySpec.TimeFormat.EPOCH.toString()) && outgoingGranularitySpec.getTimeFormat().equals(TimeGranularitySpec.TimeFormat.EPOCH.toString()) ? 1 : 0) != 0, (String)"Cannot perform time conversion for time format other than EPOCH. TimeFieldSpec: %s", (Object)timeFieldSpec);
        }
    }

    private static void validateDateTimeFieldSpec(DateTimeFieldSpec dateTimeFieldSpec) {
        DateTimeGranularitySpec granularitySpec;
        Object sampleValue;
        DateTimeFormatSpec formatSpec;
        try {
            formatSpec = dateTimeFieldSpec.getFormatSpec();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid format: " + dateTimeFieldSpec.getFormat(), e);
        }
        String sdfPattern = formatSpec.getSDFPattern();
        if (sdfPattern != null) {
            int[] maxIndexes = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};
            int idx = 0;
            while (idx < sdfPattern.length()) {
                int charIndex = DATETIME_PATTERN_ORDERING.getOrDefault(Character.valueOf(sdfPattern.charAt(idx)), 7);
                maxIndexes[charIndex] = idx++;
            }
            for (idx = 0; idx < maxIndexes.length - 2; ++idx) {
                Preconditions.checkArgument((maxIndexes[idx] <= maxIndexes[idx + 1] || maxIndexes[idx + 1] == -1 ? 1 : 0) != 0, (Object)String.format("SIMPLE_DATE_FORMAT pattern %s has to be sorted by both lexicographical and datetime order", sdfPattern));
                maxIndexes[idx + 1] = Math.max(maxIndexes[idx + 1], maxIndexes[idx]);
            }
        }
        if ((sampleValue = dateTimeFieldSpec.getSampleValue()) != null) {
            long sampleTimestampValue;
            try {
                sampleTimestampValue = formatSpec.fromFormatToMillis(sampleValue.toString());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Cannot format provided sample value: %s with provided date time spec: %s", sampleValue, formatSpec));
            }
            boolean isValidTimestamp = TimeUtils.timeValueInValidRange((long)sampleTimestampValue);
            Preconditions.checkArgument((boolean)isValidTimestamp, (String)"Incorrect date time format. Converted sample value %s for date-time field spec is not in valid time-range: %s and %s", (Object)sampleTimestampValue, (Object)TimeUtils.VALID_MIN_TIME_MILLIS, (Object)TimeUtils.VALID_MAX_TIME_MILLIS);
        }
        try {
            granularitySpec = dateTimeFieldSpec.getGranularitySpec();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid granularity: " + dateTimeFieldSpec.getGranularity(), e);
        }
        Preconditions.checkNotNull((Object)granularitySpec);
    }

    static {
        char[] patternOrdering = new char[]{'y', 'M', 'd', 'H', 'm', 's', 'S'};
        for (int i = 0; i < patternOrdering.length; ++i) {
            DATETIME_PATTERN_ORDERING.put(Character.valueOf(patternOrdering[i]), i);
        }
    }
}

