/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.automaton;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Transition;
import org.apache.pinot.segment.local.utils.nativefst.automaton.TransitionComparator;

public class State
implements Serializable,
Comparable<State> {
    boolean _accept;
    Set<Transition> _transitionSet;
    int _number;

    public State() {
        this.resetTransitions();
    }

    final void resetTransitions() {
        this._transitionSet = new HashSet<Transition>();
    }

    public Set<Transition> getTransitionSet() {
        return this._transitionSet;
    }

    public void addTransition(Transition t) {
        this._transitionSet.add(t);
    }

    public void setAccept(boolean accept) {
        this._accept = accept;
    }

    public State step(char c) {
        for (Transition t : this._transitionSet) {
            if (t._min > c || c > t._max) continue;
            return t._to;
        }
        return null;
    }

    public void step(char c, Collection<State> dest) {
        for (Transition t : this._transitionSet) {
            if (t._min > c || c > t._max) continue;
            dest.add(t._to);
        }
    }

    void addEpsilon(State to) {
        if (to._accept) {
            this._accept = true;
        }
        this._transitionSet.addAll(to._transitionSet);
    }

    Transition[] getSortedTransitionArray(boolean toFirst) {
        Transition[] e = this._transitionSet.toArray(new Transition[0]);
        Arrays.sort(e, new TransitionComparator(toFirst));
        return e;
    }

    public List<Transition> getSortedTransitions(boolean toFirst) {
        return Arrays.asList(this.getSortedTransitionArray(toFirst));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("state ").append(this._number);
        if (this._accept) {
            b.append(" [accept]");
        } else {
            b.append(" [reject]");
        }
        b.append(":\n");
        for (Transition t : this._transitionSet) {
            b.append("  ").append(t.toString()).append("\n");
        }
        return b.toString();
    }

    @Override
    public int compareTo(State s) {
        return s._number - this._number;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

