/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.record.enricher.clp;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.auto.service.AutoService;
import java.io.IOException;
import org.apache.pinot.plugin.record.enricher.clp.CLPEncodingEnricher;
import org.apache.pinot.plugin.record.enricher.clp.ClpEnricherConfig;
import org.apache.pinot.spi.recordenricher.RecordEnricher;
import org.apache.pinot.spi.recordenricher.RecordEnricherFactory;
import org.apache.pinot.spi.recordenricher.RecordEnricherValidationConfig;
import org.apache.pinot.spi.utils.JsonUtils;

@AutoService(value={RecordEnricherFactory.class})
public class CLPEncodingEnricherFactory
implements RecordEnricherFactory {
    private static final String ENRICHER_TYPE = "clpEnricher";

    public String getEnricherType() {
        return ENRICHER_TYPE;
    }

    public RecordEnricher createEnricher(JsonNode enricherProps) throws IOException {
        return new CLPEncodingEnricher(enricherProps);
    }

    public void validateEnrichmentConfig(JsonNode enricherProps, RecordEnricherValidationConfig validationConfig) {
        try {
            ClpEnricherConfig clpEnricherConfig = (ClpEnricherConfig)JsonUtils.jsonNodeToObject((JsonNode)enricherProps, ClpEnricherConfig.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse clp enricher config", e);
        }
    }
}

