/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.record.enricher.function;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.plugin.record.enricher.function.CustomFunctionEnricherConfig;
import org.apache.pinot.segment.local.function.FunctionEvaluator;
import org.apache.pinot.segment.local.function.FunctionEvaluatorFactory;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.recordenricher.RecordEnricher;
import org.apache.pinot.spi.utils.JsonUtils;

public class CustomFunctionEnricher
implements RecordEnricher {
    private final Map<String, FunctionEvaluator> _fieldToFunctionEvaluator;
    private final List<String> _fieldsToExtract;

    public CustomFunctionEnricher(JsonNode enricherProps) throws IOException {
        CustomFunctionEnricherConfig config = (CustomFunctionEnricherConfig)JsonUtils.jsonNodeToObject((JsonNode)enricherProps, CustomFunctionEnricherConfig.class);
        this._fieldToFunctionEvaluator = new LinkedHashMap<String, FunctionEvaluator>();
        this._fieldsToExtract = new ArrayList<String>();
        for (Map.Entry<String, String> entry : config.getFieldToFunctionMap().entrySet()) {
            String column = entry.getKey();
            String function = entry.getValue();
            FunctionEvaluator functionEvaluator = FunctionEvaluatorFactory.getExpressionEvaluator(function);
            this._fieldToFunctionEvaluator.put(column, functionEvaluator);
            this._fieldsToExtract.addAll(functionEvaluator.getArguments());
        }
    }

    public List<String> getInputColumns() {
        return this._fieldsToExtract;
    }

    public void enrich(GenericRow record) {
        this._fieldToFunctionEvaluator.forEach((field, evaluator) -> record.putValue(field, evaluator.evaluate(record)));
    }
}

