/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import com.dynatrace.hash4j.distinctcount.UltraLogLog;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.local.utils.CustomSerDeUtils;
import org.apache.pinot.segment.local.utils.UltraLogLogUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class DistinctCountULLValueAggregator
implements ValueAggregator<Object, UltraLogLog> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    private final int _p;

    public DistinctCountULLValueAggregator(List<ExpressionContext> arguments) {
        this._p = arguments.size() == 1 ? arguments.get(0).getLiteral().getIntValue() : 12;
    }

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.DISTINCTCOUNTULL;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public UltraLogLog getInitialAggregatedValue(Object rawValue) {
        UltraLogLog initialValue;
        if (rawValue instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            initialValue = this.deserializeAggregatedValue(bytes);
        } else {
            initialValue = UltraLogLog.create((int)this._p);
            this.addObjectToSketch(rawValue, initialValue);
        }
        return initialValue;
    }

    @Override
    public UltraLogLog applyRawValue(UltraLogLog value, Object rawValue) {
        this.addObjectToSketch(rawValue, value);
        return value;
    }

    @Override
    public UltraLogLog applyAggregatedValue(UltraLogLog value, UltraLogLog aggregatedValue) {
        value.add(aggregatedValue);
        return value;
    }

    @Override
    public UltraLogLog cloneAggregatedValue(UltraLogLog value) {
        return this.deserializeAggregatedValue(this.serializeAggregatedValue(value));
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return (1 << this._p) + 1;
    }

    @Override
    public byte[] serializeAggregatedValue(UltraLogLog value) {
        return CustomSerDeUtils.ULTRA_LOG_LOG_OBJECT_SER_DE.serialize(value);
    }

    @Override
    public UltraLogLog deserializeAggregatedValue(byte[] bytes) {
        return CustomSerDeUtils.ULTRA_LOG_LOG_OBJECT_SER_DE.deserialize(bytes).downsize(this._p);
    }

    private void addObjectToSketch(Object rawValue, UltraLogLog sketch) {
        if (rawValue instanceof byte[]) {
            sketch.add(this.deserializeAggregatedValue((byte[])rawValue));
        } else if (rawValue instanceof Object[]) {
            this.addObjectsToSketch((Object[])rawValue, sketch);
        } else {
            UltraLogLogUtils.hashObject(rawValue).ifPresent(arg_0 -> ((UltraLogLog)sketch).add(arg_0));
        }
    }

    private void addObjectsToSketch(Object[] rawValues, UltraLogLog sketch) {
        for (Object rawValue : rawValues) {
            this.addObjectToSketch(rawValue, sketch);
        }
    }
}

