/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Union;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.local.utils.CustomSerDeUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class IntegerTupleSketchValueAggregator
implements ValueAggregator<byte[], Object> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    private final int _nominalEntries;
    private final IntegerSummary.Mode _mode;

    public IntegerTupleSketchValueAggregator(IntegerSummary.Mode mode) {
        this._nominalEntries = 16384;
        this._mode = mode;
    }

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.DISTINCTCOUNTTUPLESKETCH;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public Object getInitialAggregatedValue(byte[] rawValue) {
        Sketch<IntegerSummary> initialValue = this.deserializeAggregatedValue(rawValue);
        Union tupleUnion = new Union(this._nominalEntries, (SummarySetOperations)new IntegerSummarySetOperations(this._mode, this._mode));
        tupleUnion.union(initialValue);
        return tupleUnion;
    }

    private Union extractUnion(Object value) {
        if (value == null) {
            return new Union(this._nominalEntries, (SummarySetOperations)new IntegerSummarySetOperations(this._mode, this._mode));
        }
        if (value instanceof Union) {
            return (Union)value;
        }
        if (value instanceof Sketch) {
            Sketch sketch = (Sketch)value;
            Union tupleUnion = new Union(this._nominalEntries, (SummarySetOperations)new IntegerSummarySetOperations(this._mode, this._mode));
            tupleUnion.union(sketch);
            return tupleUnion;
        }
        throw new IllegalStateException("Unsupported data type for Integer Tuple Sketch aggregation: " + value.getClass().getSimpleName());
    }

    private Sketch extractSketch(Object value) {
        if (value instanceof Union) {
            return ((Union)value).getResult();
        }
        if (value instanceof Sketch) {
            return (Sketch)value;
        }
        throw new IllegalStateException("Unsupported data type for Integer Tuple Sketch aggregation: " + value.getClass().getSimpleName());
    }

    @Override
    public Object applyRawValue(Object aggregatedValue, byte[] rawValue) {
        Union tupleUnion = this.extractUnion(aggregatedValue);
        tupleUnion.union(this.deserializeAggregatedValue(rawValue));
        return tupleUnion;
    }

    @Override
    public Object applyAggregatedValue(Object value, Object aggregatedValue) {
        Union tupleUnion = this.extractUnion(aggregatedValue);
        Sketch sketch = this.extractSketch(value);
        tupleUnion.union(sketch);
        return tupleUnion;
    }

    @Override
    public Object cloneAggregatedValue(Object value) {
        return this.deserializeAggregatedValue(this.serializeAggregatedValue(value));
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        if (this._nominalEntries == 0) {
            return 8;
        }
        if (this._nominalEntries == 1) {
            return 16;
        }
        int longSizeInBytes = 8;
        int intSizeInBytes = 4;
        return this._nominalEntries * (longSizeInBytes + intSizeInBytes) + 24;
    }

    @Override
    public byte[] serializeAggregatedValue(Object value) {
        Sketch sketch = this.extractSketch(value);
        return sketch.compact().toByteArray();
    }

    @Override
    public Sketch<IntegerSummary> deserializeAggregatedValue(byte[] bytes) {
        return CustomSerDeUtils.DATA_SKETCH_INT_TUPLE_SER_DE.deserialize(bytes);
    }
}

