/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.customobject;

import javax.annotation.Nonnull;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUnion;
import org.apache.pinot.segment.local.customobject.CustomObjectAccumulator;

public class CpcSketchAccumulator
extends CustomObjectAccumulator<CpcSketch> {
    private int _lgNominalEntries = 4;
    private CpcUnion _union;

    public CpcSketchAccumulator() {
    }

    public CpcSketchAccumulator(int lgNominalEntries, int threshold) {
        super(threshold);
        this._lgNominalEntries = lgNominalEntries;
    }

    public void setLgNominalEntries(int lgNominalEntries) {
        this._lgNominalEntries = lgNominalEntries;
    }

    @Override
    @Nonnull
    public CpcSketch getResult() {
        return this.unionAll();
    }

    private CpcSketch unionAll() {
        if (this._union == null) {
            this._union = new CpcUnion(this._lgNominalEntries);
        }
        if (this.isEmpty()) {
            return this._union.getResult();
        }
        if (this.getNumInputs() == 1) {
            return (CpcSketch)this._accumulator.get(0);
        }
        for (CpcSketch accumulatedSketch : this._accumulator) {
            this._union.update(accumulatedSketch);
        }
        return this._union.getResult();
    }
}

