/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.dedup;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.dedup.PartitionDedupMetadataManager;
import org.apache.pinot.segment.local.dedup.TableDedupMetadataManager;
import org.apache.pinot.spi.config.table.DedupConfig;
import org.apache.pinot.spi.config.table.HashFunction;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

abstract class BaseTableDedupMetadataManager
implements TableDedupMetadataManager {
    protected final Map<Integer, PartitionDedupMetadataManager> _partitionMetadataManagerMap = new ConcurrentHashMap<Integer, PartitionDedupMetadataManager>();
    protected String _tableNameWithType;
    protected List<String> _primaryKeyColumns;
    protected ServerMetrics _serverMetrics;
    protected HashFunction _hashFunction;

    BaseTableDedupMetadataManager() {
    }

    @Override
    public void init(TableConfig tableConfig, Schema schema, TableDataManager tableDataManager, ServerMetrics serverMetrics) {
        this._tableNameWithType = tableConfig.getTableName();
        this._primaryKeyColumns = schema.getPrimaryKeyColumns();
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this._primaryKeyColumns) ? 1 : 0) != 0, (String)"Primary key columns must be configured for dedup enabled table: %s", (Object)this._tableNameWithType);
        this._serverMetrics = serverMetrics;
        DedupConfig dedupConfig = tableConfig.getDedupConfig();
        Preconditions.checkArgument((dedupConfig != null ? 1 : 0) != 0, (String)"Dedup must be enabled for table: %s", (Object)this._tableNameWithType);
        this._hashFunction = dedupConfig.getHashFunction();
    }

    @Override
    public PartitionDedupMetadataManager getOrCreatePartitionManager(int partitionId) {
        return this._partitionMetadataManagerMap.computeIfAbsent(partitionId, this::createPartitionDedupMetadataManager);
    }

    protected abstract PartitionDedupMetadataManager createPartitionDedupMetadataManager(Integer var1);
}

