/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.indexsegment.mutable;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.local.aggregator.ValueAggregatorFactory;
import org.apache.pinot.segment.local.dedup.PartitionDedupMetadataManager;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentConfig;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentStatsHistory;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BaseOffHeapMutableDictionary;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneIndexRefreshState;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneTextIndex;
import org.apache.pinot.segment.local.realtime.impl.nullvalue.MutableNullValueVector;
import org.apache.pinot.segment.local.segment.index.datasource.ImmutableDataSource;
import org.apache.pinot.segment.local.segment.index.datasource.MutableDataSource;
import org.apache.pinot.segment.local.segment.index.dictionary.DictionaryIndexType;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnContext;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnProvider;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnProviderFactory;
import org.apache.pinot.segment.local.upsert.ComparisonColumns;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.RecordInfo;
import org.apache.pinot.segment.local.utils.FixedIntArrayOffHeapIdMap;
import org.apache.pinot.segment.local.utils.IdMap;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.segment.local.utils.TableConfigUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.DictionaryIndexConfig;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.segment.spi.index.IndexService;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.mutable.MutableDictionary;
import org.apache.pinot.segment.spi.index.mutable.MutableForwardIndex;
import org.apache.pinot.segment.spi.index.mutable.MutableIndex;
import org.apache.pinot.segment.spi.index.mutable.MutableInvertedIndex;
import org.apache.pinot.segment.spi.index.mutable.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.segment.spi.index.mutable.provider.MutableIndexContext;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.config.table.ColumnPartitionConfig;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.ingestion.AggregationConfig;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.stream.RowMetadata;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.FixedIntArray;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.roaringbitmap.BatchIterator;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableSegmentImpl
implements MutableSegment {
    private static final String RECORD_ID_MAP = "__recordIdMap__";
    private static final int EXPECTED_COMPRESSION = 1000;
    private static final int MIN_ROWS_TO_INDEX = 1000000;
    private static final int MIN_RECORD_ID_MAP_CACHE_SIZE = 10000;
    private final Logger _logger;
    private final long _startTimeMillis = System.currentTimeMillis();
    private final ServerMetrics _serverMetrics;
    private final String _realtimeTableName;
    private final String _segmentName;
    private final Schema _schema;
    private final String _timeColumnName;
    private final int _capacity;
    private final SegmentMetadata _segmentMetadata;
    private final boolean _offHeap;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final RealtimeSegmentStatsHistory _statsHistory;
    private final String _partitionColumn;
    private final PartitionFunction _partitionFunction;
    private final int _mainPartitionId;
    private final boolean _nullHandlingEnabled;
    private final File _consumerDir;
    private final Map<String, IndexContainer> _indexContainerMap = new HashMap<String, IndexContainer>();
    private final IdMap<FixedIntArray> _recordIdMap;
    private volatile int _numDocsIndexed = 0;
    private final int _numKeyColumns;
    private final Collection<FieldSpec> _physicalFieldSpecs;
    private final Collection<DimensionFieldSpec> _physicalDimensionFieldSpecs;
    private final Collection<MetricFieldSpec> _physicalMetricFieldSpecs;
    private final Collection<String> _physicalTimeColumnNames;
    private volatile long _lastIndexedTimeMs = Long.MIN_VALUE;
    private volatile long _latestIngestionTimeMs = Long.MIN_VALUE;
    private RealtimeLuceneIndexRefreshState.RealtimeLuceneReaders _realtimeLuceneReaders;
    private final PartitionDedupMetadataManager _partitionDedupMetadataManager;
    private final PartitionUpsertMetadataManager _partitionUpsertMetadataManager;
    private final List<String> _upsertComparisonColumns;
    private final String _deleteRecordColumn;
    private final String _upsertOutOfOrderRecordColumn;
    private final boolean _upsertDropOutOfOrderRecord;
    private final ThreadSafeMutableRoaringBitmap _validDocIds;
    private final ThreadSafeMutableRoaringBitmap _queryableDocIds;

    public MutableSegmentImpl(RealtimeSegmentConfig config, @Nullable ServerMetrics serverMetrics) {
        this._serverMetrics = serverMetrics;
        this._realtimeTableName = config.getTableNameWithType();
        this._segmentName = config.getSegmentName();
        this._schema = config.getSchema();
        this._timeColumnName = config.getTimeColumnName();
        this._capacity = config.getCapacity();
        SegmentZKMetadata segmentZKMetadata = config.getSegmentZKMetadata();
        this._segmentMetadata = new SegmentMetadataImpl(TableNameBuilder.extractRawTableName((String)this._realtimeTableName), segmentZKMetadata.getSegmentName(), this._schema, segmentZKMetadata.getCreationTime()){

            public int getTotalDocs() {
                return MutableSegmentImpl.this._numDocsIndexed;
            }

            public long getLastIndexedTimestamp() {
                return MutableSegmentImpl.this._lastIndexedTimeMs;
            }

            public long getLatestIngestionTimestamp() {
                return MutableSegmentImpl.this._latestIngestionTimeMs;
            }

            public boolean isMutableSegment() {
                return true;
            }
        };
        this._offHeap = config.isOffHeap();
        this._memoryManager = config.getMemoryManager();
        this._statsHistory = config.getStatsHistory();
        this._partitionColumn = config.getPartitionColumn();
        this._partitionFunction = config.getPartitionFunction();
        this._mainPartitionId = config.getPartitionId();
        this._nullHandlingEnabled = config.isNullHandlingEnabled();
        this._consumerDir = new File(config.getConsumerDir());
        Collection allFieldSpecs = this._schema.getAllFieldSpecs();
        ArrayList<FieldSpec> physicalFieldSpecs = new ArrayList<FieldSpec>(allFieldSpecs.size());
        ArrayList<DimensionFieldSpec> physicalDimensionFieldSpecs = new ArrayList<DimensionFieldSpec>(this._schema.getDimensionNames().size());
        ArrayList<MetricFieldSpec> physicalMetricFieldSpecs = new ArrayList<MetricFieldSpec>(this._schema.getMetricNames().size());
        ArrayList<String> physicalTimeColumnNames = new ArrayList<String>();
        for (FieldSpec fieldSpec : allFieldSpecs) {
            if (fieldSpec.isVirtualColumn()) continue;
            physicalFieldSpecs.add(fieldSpec);
            FieldSpec.FieldType fieldType = fieldSpec.getFieldType();
            if (fieldType == FieldSpec.FieldType.DIMENSION) {
                physicalDimensionFieldSpecs.add((DimensionFieldSpec)fieldSpec);
                continue;
            }
            if (fieldType == FieldSpec.FieldType.METRIC) {
                physicalMetricFieldSpecs.add((MetricFieldSpec)fieldSpec);
                continue;
            }
            if (fieldType != FieldSpec.FieldType.DATE_TIME && fieldType != FieldSpec.FieldType.TIME) continue;
            physicalTimeColumnNames.add(fieldSpec.getName());
        }
        this._physicalFieldSpecs = Collections.unmodifiableCollection(physicalFieldSpecs);
        this._physicalDimensionFieldSpecs = Collections.unmodifiableCollection(physicalDimensionFieldSpecs);
        this._physicalMetricFieldSpecs = Collections.unmodifiableCollection(physicalMetricFieldSpecs);
        this._physicalTimeColumnNames = Collections.unmodifiableCollection(physicalTimeColumnNames);
        this._numKeyColumns = this._physicalDimensionFieldSpecs.size() + this._physicalTimeColumnNames.size();
        this._logger = LoggerFactory.getLogger((String)(MutableSegmentImpl.class.getName() + "_" + this._segmentName + "_" + config.getStreamName()));
        this._recordIdMap = this.enableMetricsAggregationIfPossible(config);
        Map<Object, Object> metricsAggregators = Collections.emptyMap();
        if (this._recordIdMap != null) {
            metricsAggregators = MutableSegmentImpl.getMetricsAggregators(config);
        }
        HashSet specialIndexes = Sets.newHashSet((Object[])new IndexType[]{StandardIndexes.dictionary(), StandardIndexes.nullValueVector()});
        for (FieldSpec fieldSpec : this._physicalFieldSpecs) {
            MutableDictionary dictionary;
            FieldIndexConfigs indexConfigs;
            Pair aggregatorPair;
            String column = fieldSpec.getName();
            int fixedByteSize = -1;
            FieldSpec.DataType dataType = fieldSpec.getDataType();
            FieldSpec.DataType storedType = dataType.getStoredType();
            if (!storedType.isFixedWidth() && (aggregatorPair = (Pair)metricsAggregators.get(column)) != null) {
                fixedByteSize = ((ValueAggregator)aggregatorPair.getRight()).getMaxAggregatedValueByteSize();
            }
            boolean isDictionary = !this.isNoDictionaryColumn(indexConfigs = Optional.ofNullable(config.getIndexConfigByCol().get(column)).orElse(FieldIndexConfigs.EMPTY), fieldSpec, column);
            MutableIndexContext context = MutableIndexContext.builder().withFieldSpec(fieldSpec).withMemoryManager(this._memoryManager).withDictionary(isDictionary).withCapacity(this._capacity).offHeap(this._offHeap).withSegmentName(this._segmentName).withEstimatedCardinality(this._statsHistory.getEstimatedCardinality(column)).withEstimatedColSize(this._statsHistory.getEstimatedAvgColSize(column)).withAvgNumMultiValues(this._statsHistory.getEstimatedAvgColSize(column)).withConsumerDir(this._consumerDir).withFixedLengthBytes(fixedByteSize).build();
            PartitionFunction partitionFunction = null;
            ConcurrentHashMap.KeySetView partitions = null;
            if (column.equals(this._partitionColumn)) {
                partitionFunction = this._partitionFunction;
                partitions = ConcurrentHashMap.newKeySet();
                partitions.add(this._mainPartitionId);
            }
            if (isDictionary) {
                DictionaryIndexConfig dictionaryIndexConfig = (DictionaryIndexConfig)indexConfigs.getConfig(StandardIndexes.dictionary());
                if (dictionaryIndexConfig.isDisabled()) {
                    dictionaryIndexConfig = DictionaryIndexConfig.DEFAULT;
                }
                dictionary = DictionaryIndexType.createMutableDictionary(context, dictionaryIndexConfig);
            } else {
                dictionary = null;
                if (!fieldSpec.isSingleValueField()) {
                    switch (storedType) {
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: {
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported data type: " + dataType + " for MV no-dictionary column: " + column);
                        }
                    }
                }
            }
            MutableNullValueVector nullValueVector = this.isNullable(fieldSpec) ? new MutableNullValueVector() : null;
            HashMap<IndexType, MutableIndex> mutableIndexes = new HashMap<IndexType, MutableIndex>();
            for (IndexType indexType : IndexService.getInstance().getAllIndexes()) {
                if (specialIndexes.contains(indexType)) continue;
                this.addMutableIndex(mutableIndexes, indexType, context, indexConfigs);
            }
            MutableIndex textIndex = (MutableIndex)mutableIndexes.get(StandardIndexes.text());
            if (textIndex instanceof RealtimeLuceneTextIndex) {
                if (this._realtimeLuceneReaders == null) {
                    this._realtimeLuceneReaders = new RealtimeLuceneIndexRefreshState.RealtimeLuceneReaders(this._segmentName);
                }
                this._realtimeLuceneReaders.addReader((RealtimeLuceneTextIndex)textIndex);
            }
            Pair columnAggregatorPair = (Pair)metricsAggregators.getOrDefault(column, Pair.of((Object)column, null));
            String sourceColumn = (String)columnAggregatorPair.getLeft();
            ValueAggregator valueAggregator = (ValueAggregator)columnAggregatorPair.getRight();
            this._indexContainerMap.put(column, new IndexContainer(fieldSpec, partitionFunction, partitions, new ValuesInfo(), mutableIndexes, dictionary, nullValueVector, sourceColumn, valueAggregator));
        }
        if (this._realtimeLuceneReaders != null) {
            RealtimeLuceneIndexRefreshState realtimeLuceneIndexRefreshState = RealtimeLuceneIndexRefreshState.getInstance();
            realtimeLuceneIndexRefreshState.addRealtimeReadersToQueue(this._realtimeLuceneReaders);
        }
        this._partitionDedupMetadataManager = config.getPartitionDedupMetadataManager();
        this._partitionUpsertMetadataManager = config.getPartitionUpsertMetadataManager();
        if (this._partitionUpsertMetadataManager != null) {
            Preconditions.checkState((!this.isAggregateMetricsEnabled() ? 1 : 0) != 0, (Object)"Metrics aggregation and upsert cannot be enabled together");
            List<String> upsertComparisonColumns = config.getUpsertComparisonColumns();
            this._upsertComparisonColumns = upsertComparisonColumns != null ? upsertComparisonColumns : Collections.singletonList(this._timeColumnName);
            this._deleteRecordColumn = config.getUpsertDeleteRecordColumn();
            this._upsertOutOfOrderRecordColumn = config.getUpsertOutOfOrderRecordColumn();
            this._upsertDropOutOfOrderRecord = config.isUpsertDropOutOfOrderRecord();
            this._validDocIds = new ThreadSafeMutableRoaringBitmap();
            this._queryableDocIds = this._deleteRecordColumn != null ? new ThreadSafeMutableRoaringBitmap() : null;
        } else {
            this._upsertComparisonColumns = null;
            this._deleteRecordColumn = null;
            this._validDocIds = null;
            this._queryableDocIds = null;
            this._upsertOutOfOrderRecordColumn = null;
            this._upsertDropOutOfOrderRecord = false;
        }
    }

    private boolean isNullable(FieldSpec fieldSpec) {
        return this._schema.isEnableColumnBasedNullHandling() ? fieldSpec.isNullable() : this._nullHandlingEnabled;
    }

    private <C extends IndexConfig> void addMutableIndex(Map<IndexType, MutableIndex> mutableIndexes, IndexType<C, ?, ?> indexType, MutableIndexContext context, FieldIndexConfigs indexConfigs) {
        MutableIndex mutableIndex = indexType.createMutableIndex(context, indexConfigs.getConfig(indexType));
        if (mutableIndex != null) {
            mutableIndexes.put(indexType, mutableIndex);
        }
    }

    private boolean isNoDictionaryColumn(FieldIndexConfigs indexConfigs, FieldSpec fieldSpec, String column) {
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        if (indexConfigs == null) {
            return false;
        }
        if (((DictionaryIndexConfig)indexConfigs.getConfig(StandardIndexes.dictionary())).isEnabled()) {
            return false;
        }
        if (fieldSpec instanceof DimensionFieldSpec && this.isAggregateMetricsEnabled() && (dataType == FieldSpec.DataType.STRING || dataType == FieldSpec.DataType.BYTES)) {
            this._logger.info("Aggregate metrics is enabled. Will create dictionary in consuming segment for column {} of type {}", (Object)column, (Object)dataType);
            return false;
        }
        return (fieldSpec.isSingleValueField() || fieldSpec.getDataType().isFixedWidth()) && indexConfigs.getConfig(StandardIndexes.inverted()).isDisabled();
    }

    public SegmentPartitionConfig getSegmentPartitionConfig() {
        if (this._partitionColumn != null) {
            return new SegmentPartitionConfig(Collections.singletonMap(this._partitionColumn, new ColumnPartitionConfig(this._partitionFunction.getName(), this._partitionFunction.getNumPartitions())));
        }
        return null;
    }

    @Deprecated
    public long getMinTime() {
        Long minTime = IngestionUtils.extractTimeValue(this._indexContainerMap.get((Object)this._timeColumnName)._minValue);
        if (minTime != null) {
            return minTime;
        }
        return Long.MAX_VALUE;
    }

    @Deprecated
    public long getMaxTime() {
        Long maxTime = IngestionUtils.extractTimeValue(this._indexContainerMap.get((Object)this._timeColumnName)._maxValue);
        if (maxTime != null) {
            return maxTime;
        }
        return Long.MIN_VALUE;
    }

    public boolean index(GenericRow row, @Nullable RowMetadata rowMetadata) throws IOException {
        boolean canTakeMore;
        PrimaryKey primaryKey;
        int numDocsIndexed = this._numDocsIndexed;
        if (this.isDedupEnabled() && this._partitionDedupMetadataManager.checkRecordPresentOrUpdate(primaryKey = row.getPrimaryKey(this._schema.getPrimaryKeyColumns()), (IndexSegment)this)) {
            if (this._serverMetrics != null) {
                this._serverMetrics.addMeteredTableValue(this._realtimeTableName, (AbstractMetrics.Meter)ServerMeter.REALTIME_DEDUP_DROPPED, 1L);
            }
            return true;
        }
        if (this.isUpsertEnabled()) {
            boolean isOutOfOrderRecord;
            RecordInfo recordInfo = this.getRecordInfo(row, numDocsIndexed);
            GenericRow updatedRow = this._partitionUpsertMetadataManager.updateRecord(row, recordInfo);
            boolean bl = isOutOfOrderRecord = !this._partitionUpsertMetadataManager.addRecord(this, recordInfo);
            if (this._upsertOutOfOrderRecordColumn != null) {
                updatedRow.putValue(this._upsertOutOfOrderRecordColumn, (Object)BooleanUtils.toInt((boolean)isOutOfOrderRecord));
            }
            if (!isOutOfOrderRecord || !this._upsertDropOutOfOrderRecord) {
                this.updateDictionary(updatedRow);
                this.addNewRow(numDocsIndexed, updatedRow);
                ++numDocsIndexed;
            }
            canTakeMore = numDocsIndexed < this._capacity;
        } else {
            this.updateDictionary(row);
            int docId = this.getOrCreateDocId();
            if (docId == numDocsIndexed) {
                this.addNewRow(numDocsIndexed, row);
                canTakeMore = numDocsIndexed++ < this._capacity;
            } else {
                assert (this.isAggregateMetricsEnabled());
                this.aggregateMetrics(row, docId);
                canTakeMore = true;
            }
        }
        this._numDocsIndexed = numDocsIndexed;
        this._lastIndexedTimeMs = System.currentTimeMillis();
        if (rowMetadata != null) {
            this._latestIngestionTimeMs = Math.max(this._latestIngestionTimeMs, rowMetadata.getRecordIngestionTimeMs());
        }
        return canTakeMore;
    }

    private boolean isUpsertEnabled() {
        return this._partitionUpsertMetadataManager != null;
    }

    private boolean isDedupEnabled() {
        return this._partitionDedupMetadataManager != null;
    }

    private RecordInfo getRecordInfo(GenericRow row, int docId) {
        PrimaryKey primaryKey = row.getPrimaryKey(this._schema.getPrimaryKeyColumns());
        Comparable comparisonValue = this.getComparisonValue(row);
        boolean deleteRecord = this._deleteRecordColumn != null && BooleanUtils.toBoolean((Object)row.getValue(this._deleteRecordColumn));
        return new RecordInfo(primaryKey, docId, comparisonValue, deleteRecord);
    }

    private Comparable getComparisonValue(GenericRow row) {
        int numComparisonColumns = this._upsertComparisonColumns.size();
        if (numComparisonColumns == 1) {
            return (Comparable)row.getValue(this._upsertComparisonColumns.get(0));
        }
        Comparable[] comparisonValues = new Comparable[numComparisonColumns];
        int comparableIndex = -1;
        for (int i = 0; i < numComparisonColumns; ++i) {
            String columnName = this._upsertComparisonColumns.get(i);
            if (row.isNullValue(columnName)) continue;
            Preconditions.checkState((comparableIndex == -1 ? 1 : 0) != 0, (Object)"Documents must have exactly 1 non-null comparison column value");
            comparableIndex = i;
            Object comparisonValue = row.getValue(columnName);
            Preconditions.checkState((boolean)(comparisonValue instanceof Comparable), (String)"Upsert comparison column: %s must be comparable", (Object)columnName);
            comparisonValues[i] = (Comparable)comparisonValue;
        }
        Preconditions.checkState((comparableIndex != -1 ? 1 : 0) != 0, (Object)"Documents must have exactly 1 non-null comparison column value");
        return new ComparisonColumns(comparisonValues, comparableIndex);
    }

    private void updateDictionary(GenericRow row) {
        for (Map.Entry<String, IndexContainer> entry : this._indexContainerMap.entrySet()) {
            IndexContainer indexContainer = entry.getValue();
            MutableDictionary dictionary = indexContainer._dictionary;
            if (dictionary == null) continue;
            Object value = row.getValue(entry.getKey());
            if (value == null) {
                this.recordIndexingError("DICTIONARY");
                continue;
            }
            if (indexContainer._fieldSpec.isSingleValueField()) {
                indexContainer._dictId = dictionary.index(value);
            } else {
                indexContainer._dictIds = dictionary.index((Object[])value);
            }
            indexContainer._minValue = dictionary.getMinVal();
            indexContainer._maxValue = dictionary.getMaxVal();
        }
    }

    private void addNewRow(int docId, GenericRow row) {
        block11: for (Map.Entry<String, IndexContainer> entry : this._indexContainerMap.entrySet()) {
            Object value;
            String column = entry.getKey();
            IndexContainer indexContainer = entry.getValue();
            if (indexContainer._valueAggregator != null) {
                value = row.getValue(indexContainer._sourceColumn);
                indexContainer._valuesInfo.updateSVNumValues();
                MutableIndex forwardIndex = indexContainer._mutableIndexes.get(StandardIndexes.forward());
                FieldSpec fieldSpec = indexContainer._fieldSpec;
                FieldSpec.DataType dataType = fieldSpec.getDataType();
                value = indexContainer._valueAggregator.getInitialAggregatedValue(value);
                switch (dataType.getStoredType()) {
                    case INT: {
                        forwardIndex.add((Object)((Number)value).intValue(), -1, docId);
                        continue block11;
                    }
                    case LONG: {
                        forwardIndex.add((Object)((Number)value).longValue(), -1, docId);
                        continue block11;
                    }
                    case FLOAT: {
                        forwardIndex.add((Object)Float.valueOf(((Number)value).floatValue()), -1, docId);
                        continue block11;
                    }
                    case DOUBLE: {
                        forwardIndex.add((Object)((Number)value).doubleValue(), -1, docId);
                        continue block11;
                    }
                    case BIG_DECIMAL: 
                    case BYTES: {
                        forwardIndex.add((Object)indexContainer._valueAggregator.serializeAggregatedValue(value), -1, docId);
                        continue block11;
                    }
                }
                throw new UnsupportedOperationException("Unsupported data type: " + dataType + " for aggregation: " + column);
            }
            if (indexContainer._nullValueVector != null && row.isNullValue(column)) {
                indexContainer._nullValueVector.setNull(docId);
            }
            if ((value = row.getValue(column)) == null) continue;
            FieldSpec fieldSpec = indexContainer._fieldSpec;
            FieldSpec.DataType dataType = fieldSpec.getDataType();
            if (fieldSpec.isSingleValueField()) {
                String stringValue;
                int partition;
                if (column.equals(this._partitionColumn) && (partition = this._partitionFunction.getPartition(stringValue = dataType.toString(value))) != this._mainPartitionId) {
                    if (indexContainer._partitions.add(partition)) {
                        this._logger.warn("Found new partition: {} from partition column: {}, value: {}", new Object[]{partition, column, stringValue});
                    }
                    if (this._serverMetrics != null) {
                        this._serverMetrics.addMeteredTableValue(this._realtimeTableName, (AbstractMetrics.Meter)ServerMeter.REALTIME_PARTITION_MISMATCH, 1L);
                    }
                }
                indexContainer._valuesInfo.updateSVNumValues();
                int dictId = indexContainer._dictId;
                for (Map.Entry<IndexType, MutableIndex> indexEntry : indexContainer._mutableIndexes.entrySet()) {
                    try {
                        indexEntry.getValue().add(value, dictId, docId);
                    }
                    catch (Exception e) {
                        this.recordIndexingError(indexEntry.getKey(), e);
                    }
                }
                if (dictId >= 0 || this.isAggregateMetricsEnabled() && fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) continue;
                Comparable comparable = dataType == FieldSpec.DataType.BYTES ? new ByteArray((byte[])value) : (Comparable)value;
                if (indexContainer._minValue == null) {
                    indexContainer._minValue = comparable;
                    indexContainer._maxValue = comparable;
                    continue;
                }
                if (comparable.compareTo(indexContainer._minValue) < 0) {
                    indexContainer._minValue = comparable;
                }
                if (comparable.compareTo(indexContainer._maxValue) <= 0) continue;
                indexContainer._maxValue = comparable;
                continue;
            }
            int[] dictIds = indexContainer._dictIds;
            indexContainer._valuesInfo.updateVarByteMVMaxRowLengthInBytes(value, dataType.getStoredType());
            Object[] values = (Object[])value;
            for (Map.Entry<IndexType, MutableIndex> indexEntry : indexContainer._mutableIndexes.entrySet()) {
                try {
                    indexEntry.getValue().add(values, dictIds, docId);
                }
                catch (Exception e) {
                    this.recordIndexingError(indexEntry.getKey(), e);
                }
            }
            indexContainer._valuesInfo.updateMVNumValues(values.length);
        }
    }

    private void recordIndexingError(IndexType<?, ?, ?> indexType, Exception exception) {
        this._logger.error("failed to index value with {}", indexType, (Object)exception);
        if (this._serverMetrics != null) {
            String indexMetricName = indexType.getPrettyName().toUpperCase(Locale.US);
            String metricKeyName = this._realtimeTableName + "-" + indexMetricName + "-indexingError";
            this._serverMetrics.addMeteredTableValue(metricKeyName, (AbstractMetrics.Meter)ServerMeter.INDEXING_FAILURES, 1L);
        }
    }

    private void recordIndexingError(String indexType) {
        this._logger.error("failed to index value with {}", (Object)indexType);
        if (this._serverMetrics != null) {
            String metricKeyName = this._realtimeTableName + "-" + indexType + "-indexingError";
            this._serverMetrics.addMeteredTableValue(metricKeyName, (AbstractMetrics.Meter)ServerMeter.INDEXING_FAILURES, 1L);
        }
    }

    private void aggregateMetrics(GenericRow row, int docId) {
        block17: for (MetricFieldSpec metricFieldSpec : this._physicalMetricFieldSpecs) {
            IndexContainer indexContainer = this._indexContainerMap.get(metricFieldSpec.getName());
            Object value = row.getValue(indexContainer._sourceColumn);
            MutableForwardIndex forwardIndex = (MutableForwardIndex)indexContainer._mutableIndexes.get(StandardIndexes.forward());
            FieldSpec.DataType dataType = metricFieldSpec.getDataType();
            ValueAggregator valueAggregator = indexContainer._valueAggregator;
            switch (valueAggregator.getAggregatedValueType()) {
                case DOUBLE: {
                    switch (dataType) {
                        case INT: {
                            Double oldDoubleValue = Integer.valueOf(forwardIndex.getInt(docId)).doubleValue();
                            Double newDoubleValue = valueAggregator.applyRawValue(oldDoubleValue, value);
                            forwardIndex.setInt(docId, newDoubleValue.intValue());
                            continue block17;
                        }
                        case LONG: {
                            Double oldDoubleValue = Long.valueOf(forwardIndex.getLong(docId)).doubleValue();
                            Double newDoubleValue = valueAggregator.applyRawValue(oldDoubleValue, value);
                            forwardIndex.setLong(docId, newDoubleValue.longValue());
                            continue block17;
                        }
                        case FLOAT: {
                            Double oldDoubleValue = Float.valueOf(forwardIndex.getFloat(docId)).doubleValue();
                            Double newDoubleValue = valueAggregator.applyRawValue(oldDoubleValue, value);
                            forwardIndex.setFloat(docId, newDoubleValue.floatValue());
                            continue block17;
                        }
                        case DOUBLE: {
                            Double oldDoubleValue = forwardIndex.getDouble(docId);
                            Double newDoubleValue = valueAggregator.applyRawValue(oldDoubleValue, value);
                            forwardIndex.setDouble(docId, newDoubleValue.doubleValue());
                            continue block17;
                        }
                    }
                    throw new UnsupportedOperationException(String.format("Aggregation type %s of %s not supported for %s", valueAggregator.getAggregatedValueType(), valueAggregator.getAggregationType(), dataType));
                }
                case LONG: {
                    switch (dataType) {
                        case INT: {
                            Long oldLongValue = Integer.valueOf(forwardIndex.getInt(docId)).longValue();
                            Long newLongValue = valueAggregator.applyRawValue(oldLongValue, value);
                            forwardIndex.setInt(docId, newLongValue.intValue());
                            continue block17;
                        }
                        case LONG: {
                            Long oldLongValue = forwardIndex.getLong(docId);
                            Long newLongValue = valueAggregator.applyRawValue(oldLongValue, value);
                            forwardIndex.setLong(docId, newLongValue.longValue());
                            continue block17;
                        }
                        case FLOAT: {
                            Long oldLongValue = Float.valueOf(forwardIndex.getFloat(docId)).longValue();
                            Long newLongValue = valueAggregator.applyRawValue(oldLongValue, value);
                            forwardIndex.setFloat(docId, newLongValue.floatValue());
                            continue block17;
                        }
                        case DOUBLE: {
                            Long oldLongValue = Double.valueOf(forwardIndex.getDouble(docId)).longValue();
                            Long newLongValue = valueAggregator.applyRawValue(oldLongValue, value);
                            forwardIndex.setDouble(docId, newLongValue.doubleValue());
                            continue block17;
                        }
                    }
                    throw new UnsupportedOperationException(String.format("Aggregation type %s of %s not supported for %s", valueAggregator.getAggregatedValueType(), valueAggregator.getAggregationType(), dataType));
                }
                case BYTES: {
                    Object oldValue = valueAggregator.deserializeAggregatedValue(forwardIndex.getBytes(docId));
                    Object newValue = valueAggregator.applyRawValue(oldValue, value);
                    forwardIndex.setBytes(docId, valueAggregator.serializeAggregatedValue(newValue));
                    continue block17;
                }
            }
            throw new UnsupportedOperationException(String.format("Aggregation type %s of %s not supported for %s", valueAggregator.getAggregatedValueType(), valueAggregator.getAggregationType(), dataType));
        }
    }

    public int getNumDocsIndexed() {
        return this._numDocsIndexed;
    }

    public File getConsumerDir() {
        return this._consumerDir;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public SegmentMetadata getSegmentMetadata() {
        return this._segmentMetadata;
    }

    public Set<String> getColumnNames() {
        return this._schema.getColumnNames();
    }

    public Set<String> getPhysicalColumnNames() {
        HashSet<String> physicalColumnNames = new HashSet<String>();
        for (FieldSpec fieldSpec : this._physicalFieldSpecs) {
            physicalColumnNames.add(fieldSpec.getName());
        }
        return physicalColumnNames;
    }

    public DataSource getDataSource(String column) {
        IndexContainer indexContainer = this._indexContainerMap.get(column);
        if (indexContainer != null) {
            return indexContainer.toDataSource();
        }
        FieldSpec fieldSpec = this._schema.getFieldSpecFor(column);
        Preconditions.checkState((fieldSpec != null && fieldSpec.isVirtualColumn() ? 1 : 0) != 0, (String)"Failed to find column: %s", (Object)column);
        VirtualColumnContext virtualColumnContext = new VirtualColumnContext(fieldSpec, this._numDocsIndexed);
        VirtualColumnProvider virtualColumnProvider = VirtualColumnProviderFactory.buildProvider(virtualColumnContext);
        return new ImmutableDataSource(virtualColumnProvider.buildMetadata(virtualColumnContext), virtualColumnProvider.buildColumnIndexContainer(virtualColumnContext));
    }

    public List<StarTreeV2> getStarTrees() {
        return null;
    }

    @Nullable
    public ThreadSafeMutableRoaringBitmap getValidDocIds() {
        return this._validDocIds;
    }

    @Nullable
    public ThreadSafeMutableRoaringBitmap getQueryableDocIds() {
        return this._queryableDocIds;
    }

    public GenericRow getRecord(int docId, GenericRow reuse) {
        GenericRow genericRow;
        PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader();
        try {
            recordReader.init((IndexSegment)this);
            recordReader.getRecord(docId, reuse);
            genericRow = reuse;
        }
        catch (Throwable throwable) {
            try {
                try {
                    recordReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while reading record for docId: " + docId, e);
            }
        }
        recordReader.close();
        return genericRow;
    }

    public Object getValue(int docId, String column) {
        Object object;
        PinotSegmentColumnReader columnReader = new PinotSegmentColumnReader((IndexSegment)this, column);
        try {
            object = columnReader.getValue(docId);
        }
        catch (Throwable throwable) {
            try {
                try {
                    columnReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Caught exception while reading value for docId: %d, column: %s", docId, column), e);
            }
        }
        columnReader.close();
        return object;
    }

    public void commit() {
        for (IndexContainer indexContainer : this._indexContainerMap.values()) {
            for (MutableIndex mutableIndex : indexContainer._mutableIndexes.values()) {
                mutableIndex.commit();
            }
        }
    }

    public void offload() {
        if (this._partitionUpsertMetadataManager != null) {
            this._partitionUpsertMetadataManager.removeSegment((IndexSegment)this);
        }
        if (this._partitionDedupMetadataManager != null) {
            this._partitionDedupMetadataManager.removeSegment((IndexSegment)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this._logger.info("Trying to close RealtimeSegmentImpl : {}", (Object)this._segmentName);
        if (this._offHeap && this._numDocsIndexed > 0) {
            int numSeconds = (int)((System.currentTimeMillis() - this._startTimeMillis) / 1000L);
            long totalMemBytes = this._memoryManager.getTotalAllocatedBytes();
            this._logger.info("Segment used {} bytes of memory for {} rows consumed in {} seconds", new Object[]{totalMemBytes, this._numDocsIndexed, numSeconds});
            RealtimeSegmentStatsHistory.SegmentStats segmentStats = new RealtimeSegmentStatsHistory.SegmentStats();
            for (Map.Entry<String, IndexContainer> entry : this._indexContainerMap.entrySet()) {
                String column = entry.getKey();
                BaseOffHeapMutableDictionary dictionary = (BaseOffHeapMutableDictionary)entry.getValue()._dictionary;
                if (dictionary == null) continue;
                RealtimeSegmentStatsHistory.ColumnStats columnStats = new RealtimeSegmentStatsHistory.ColumnStats();
                columnStats.setCardinality(dictionary.length());
                columnStats.setAvgColumnSize(dictionary.getAvgValueSize());
                segmentStats.setColumnStats(column, columnStats);
            }
            segmentStats.setNumRowsConsumed(this._numDocsIndexed);
            segmentStats.setNumRowsIndexed(this._numDocsIndexed);
            segmentStats.setMemUsedBytes(totalMemBytes);
            segmentStats.setNumSeconds(numSeconds);
            this._statsHistory.addSegmentStats(segmentStats);
        }
        if (this._realtimeLuceneReaders != null) {
            this._realtimeLuceneReaders.getLock().lock();
            try {
                this._realtimeLuceneReaders.setSegmentDestroyed();
                this._realtimeLuceneReaders.clearRealtimeReaderList();
            }
            finally {
                this._realtimeLuceneReaders.getLock().unlock();
            }
        }
        for (IndexContainer indexContainer : this._indexContainerMap.values()) {
            indexContainer.close();
        }
        if (this._recordIdMap != null) {
            try {
                this._recordIdMap.close();
            }
            catch (IOException e) {
                this._logger.error("Failed to close the record id map. Continuing with error.", (Throwable)e);
            }
        }
        try {
            this._memoryManager.close();
        }
        catch (IOException e) {
            this._logger.error("Failed to close the memory manager", (Throwable)e);
        }
    }

    public int[] getSortedDocIdIterationOrderWithSortedColumn(String column) {
        IndexContainer indexContainer = this._indexContainerMap.get(column);
        MutableDictionary dictionary = indexContainer._dictionary;
        int numDocsIndexed = this._numDocsIndexed;
        int numValues = dictionary.length();
        int[] dictIds = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            dictIds[i] = i;
        }
        IntArrays.quickSort((int[])dictIds, (arg_0, arg_1) -> ((MutableDictionary)dictionary).compare(arg_0, arg_1));
        MutableInvertedIndex invertedIndex = (MutableInvertedIndex)indexContainer._mutableIndexes.get(StandardIndexes.inverted());
        int[] docIds = new int[numDocsIndexed];
        int[] batch = new int[256];
        int docIdIndex = 0;
        for (int dictId : dictIds) {
            MutableRoaringBitmap bitmap = (MutableRoaringBitmap)invertedIndex.getDocIds(dictId);
            BatchIterator iterator = bitmap.getBatchIterator();
            while (iterator.hasNext()) {
                int limit = iterator.nextBatch(batch);
                System.arraycopy(batch, 0, docIds, docIdIndex, limit);
                docIdIndex += limit;
            }
        }
        Preconditions.checkState((numDocsIndexed == docIdIndex ? 1 : 0) != 0, (String)"The number of documents indexed: %s is not equal to the number of sorted documents: %s", (int)numDocsIndexed, (int)docIdIndex);
        return docIds;
    }

    private int getOrCreateDocId() {
        if (!this.isAggregateMetricsEnabled()) {
            return this._numDocsIndexed;
        }
        int i = 0;
        int[] dictIds = new int[this._numKeyColumns];
        for (FieldSpec fieldSpec : this._physicalDimensionFieldSpecs) {
            dictIds[i++] = this._indexContainerMap.get((Object)fieldSpec.getName())._dictId;
        }
        for (String string : this._physicalTimeColumnNames) {
            dictIds[i++] = this._indexContainerMap.get((Object)string)._dictId;
        }
        return this._recordIdMap.put(new FixedIntArray(dictIds));
    }

    private IdMap<FixedIntArray> enableMetricsAggregationIfPossible(RealtimeSegmentConfig config) {
        Set noDictionaryColumns = FieldIndexConfigsUtil.columnsWithIndexDisabled((IndexType)StandardIndexes.dictionary(), config.getIndexConfigByCol());
        if (!config.aggregateMetrics() && CollectionUtils.isEmpty(config.getIngestionAggregationConfigs())) {
            this._logger.info("Metrics aggregation is disabled.");
            return null;
        }
        for (FieldSpec fieldSpec : this._physicalMetricFieldSpecs) {
            String metric = fieldSpec.getName();
            if (!noDictionaryColumns.contains(metric)) {
                this._logger.warn("Metrics aggregation cannot be turned ON in presence of dictionary encoded metrics, eg: {}", (Object)metric);
                return null;
            }
            if (fieldSpec.isSingleValueField()) continue;
            this._logger.warn("Metrics aggregation cannot be turned ON in presence of multi-value metric columns, eg: {}", (Object)metric);
            return null;
        }
        for (FieldSpec fieldSpec : this._physicalDimensionFieldSpecs) {
            String dimension = fieldSpec.getName();
            if (noDictionaryColumns.contains(dimension)) {
                this._logger.warn("Metrics aggregation cannot be turned ON in presence of no-dictionary dimensions, eg: {}", (Object)dimension);
                return null;
            }
            if (fieldSpec.isSingleValueField()) continue;
            this._logger.warn("Metrics aggregation cannot be turned ON in presence of multi-value dimension columns, eg: {}", (Object)dimension);
            return null;
        }
        for (String string : this._physicalTimeColumnNames) {
            if (!noDictionaryColumns.contains(string)) continue;
            this._logger.warn("Metrics aggregation cannot be turned ON in presence of no-dictionary datetime/time columns, eg: {}", (Object)string);
            return null;
        }
        int estimatedRowsToIndex = this._statsHistory.isEmpty() ? Math.max(config.getCapacity() / 1000, 1000000) : Math.max(this._statsHistory.getEstimatedRowsToIndex(), 1000000);
        int n = Math.max(estimatedRowsToIndex / 1000, 10000);
        this._logger.info("Initializing metrics update: estimatedRowsToIndex:{}, cacheSize:{}", (Object)estimatedRowsToIndex, (Object)n);
        return new FixedIntArrayOffHeapIdMap(estimatedRowsToIndex, n, this._numKeyColumns, this._memoryManager, RECORD_ID_MAP);
    }

    private boolean isAggregateMetricsEnabled() {
        return this._recordIdMap != null;
    }

    private static Map<String, Pair<String, ValueAggregator>> getMetricsAggregators(RealtimeSegmentConfig segmentConfig) {
        if (segmentConfig.aggregateMetrics()) {
            return MutableSegmentImpl.fromAggregateMetrics(segmentConfig);
        }
        if (!CollectionUtils.isEmpty(segmentConfig.getIngestionAggregationConfigs())) {
            return MutableSegmentImpl.fromAggregationConfig(segmentConfig);
        }
        return Collections.emptyMap();
    }

    private static Map<String, Pair<String, ValueAggregator>> fromAggregateMetrics(RealtimeSegmentConfig segmentConfig) {
        Preconditions.checkState((boolean)CollectionUtils.isEmpty(segmentConfig.getIngestionAggregationConfigs()), (Object)"aggregateMetrics cannot be enabled if AggregationConfig is set");
        HashMap<String, Pair<String, ValueAggregator>> columnNameToAggregator = new HashMap<String, Pair<String, ValueAggregator>>();
        for (String metricName : segmentConfig.getSchema().getMetricNames()) {
            columnNameToAggregator.put(metricName, (Pair<String, ValueAggregator>)Pair.of((Object)metricName, (Object)ValueAggregatorFactory.getValueAggregator(AggregationFunctionType.SUM, Collections.emptyList())));
        }
        return columnNameToAggregator;
    }

    private static Map<String, Pair<String, ValueAggregator>> fromAggregationConfig(RealtimeSegmentConfig segmentConfig) {
        HashMap<String, Pair<String, ValueAggregator>> columnNameToAggregator = new HashMap<String, Pair<String, ValueAggregator>>();
        Preconditions.checkState((!segmentConfig.aggregateMetrics() ? 1 : 0) != 0, (Object)"aggregateMetrics cannot be enabled if AggregationConfig is set");
        for (AggregationConfig config : segmentConfig.getIngestionAggregationConfigs()) {
            ExpressionContext expressionContext = RequestContextUtils.getExpression((String)config.getAggregationFunction());
            Preconditions.checkState((expressionContext.getType() == ExpressionContext.Type.FUNCTION ? 1 : 0) != 0, (String)"aggregation function must be a function: %s", (Object)config);
            FunctionContext functionContext = expressionContext.getFunction();
            AggregationFunctionType functionType = AggregationFunctionType.getAggregationFunctionType((String)functionContext.getFunctionName());
            TableConfigUtils.validateIngestionAggregation(functionType);
            ExpressionContext argument = (ExpressionContext)functionContext.getArguments().get(0);
            Preconditions.checkState((argument.getType() == ExpressionContext.Type.IDENTIFIER ? 1 : 0) != 0, (String)"aggregator function argument must be a identifier: %s", (Object)config);
            columnNameToAggregator.put(config.getColumnName(), (Pair<String, ValueAggregator>)Pair.of((Object)argument.getIdentifier(), (Object)ValueAggregatorFactory.getValueAggregator(functionType, functionContext.getArguments())));
        }
        return columnNameToAggregator;
    }

    private class IndexContainer
    implements Closeable {
        final FieldSpec _fieldSpec;
        final PartitionFunction _partitionFunction;
        final Set<Integer> _partitions;
        final ValuesInfo _valuesInfo;
        final MutableDictionary _dictionary;
        final MutableNullValueVector _nullValueVector;
        final Map<IndexType, MutableIndex> _mutableIndexes;
        final String _sourceColumn;
        final ValueAggregator _valueAggregator;
        volatile Comparable _minValue;
        volatile Comparable _maxValue;
        int _dictId = Integer.MIN_VALUE;
        int[] _dictIds;

        IndexContainer(@Nullable FieldSpec fieldSpec, @Nullable PartitionFunction partitionFunction, Set<Integer> partitions, ValuesInfo valuesInfo, @Nullable Map<IndexType, MutableIndex> mutableIndexes, @Nullable MutableDictionary dictionary, @Nullable MutableNullValueVector nullValueVector, @Nullable String sourceColumn, ValueAggregator valueAggregator) {
            Preconditions.checkArgument((boolean)mutableIndexes.containsKey(StandardIndexes.forward()), (Object)"Forward index is required");
            this._fieldSpec = fieldSpec;
            this._mutableIndexes = mutableIndexes;
            this._dictionary = dictionary;
            this._nullValueVector = nullValueVector;
            this._partitionFunction = partitionFunction;
            this._partitions = partitions;
            this._valuesInfo = valuesInfo;
            this._sourceColumn = sourceColumn;
            this._valueAggregator = valueAggregator;
        }

        DataSource toDataSource() {
            return new MutableDataSource(this._fieldSpec, MutableSegmentImpl.this._numDocsIndexed, this._valuesInfo._numValues, this._valuesInfo._maxNumValuesPerMVEntry, this._dictionary == null ? -1 : this._dictionary.length(), this._partitionFunction, this._partitions, this._minValue, this._maxValue, this._mutableIndexes, this._dictionary, this._nullValueVector, this._valuesInfo._varByteMVMaxRowLengthInBytes);
        }

        @Override
        public void close() {
            String column = this._fieldSpec.getName();
            BiConsumer<IndexType, AutoCloseable> closer = (indexType, closeable) -> {
                try {
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing {} index for column: {}, continuing with error", new Object[]{indexType, column, e});
                }
            };
            this._mutableIndexes.forEach(closer::accept);
            closer.accept(StandardIndexes.dictionary(), (AutoCloseable)this._dictionary);
            closer.accept(StandardIndexes.nullValueVector(), (AutoCloseable)((Object)this._nullValueVector));
        }
    }

    private static class ValuesInfo {
        volatile int _numValues = 0;
        volatile int _maxNumValuesPerMVEntry = -1;
        volatile int _varByteMVMaxRowLengthInBytes = -1;

        private ValuesInfo() {
        }

        void updateSVNumValues() {
            ++this._numValues;
        }

        void updateMVNumValues(int numValuesInMVEntry) {
            this._numValues += numValuesInMVEntry;
            this._maxNumValuesPerMVEntry = Math.max(this._maxNumValuesPerMVEntry, numValuesInMVEntry);
        }

        void updateVarByteMVMaxRowLengthInBytes(Object entry, FieldSpec.DataType dataType) {
            if (dataType != FieldSpec.DataType.STRING && dataType != FieldSpec.DataType.BYTES) {
                return;
            }
            Object[] values = (Object[])entry;
            int rowLength = 0;
            switch (dataType) {
                case STRING: {
                    for (Object obj : values) {
                        String value = (String)obj;
                        int length = value.getBytes(StandardCharsets.UTF_8).length;
                        rowLength += length;
                    }
                    this._varByteMVMaxRowLengthInBytes = Math.max(this._varByteMVMaxRowLengthInBytes, rowLength);
                    break;
                }
                case BYTES: {
                    for (Object obj : values) {
                        ByteArray value = new ByteArray((byte[])obj);
                        int length = value.length();
                        rowLength += length;
                    }
                    this._varByteMVMaxRowLengthInBytes = Math.max(this._varByteMVMaxRowLengthInBytes, rowLength);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid type=" + dataType);
                }
            }
        }
    }
}

