/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkCompressor;

class GzipCompressor
implements ChunkCompressor {
    private final Deflater _compressor = new Deflater();

    public int compress(ByteBuffer inUncompressed, ByteBuffer outCompressed) throws IOException {
        this._compressor.reset();
        this._compressor.setInput(inUncompressed);
        this._compressor.finish();
        this._compressor.deflate(outCompressed);
        outCompressed.putInt((int)this._compressor.getBytesRead());
        int size = outCompressed.position();
        outCompressed.flip();
        return size;
    }

    public int maxCompressedSize(int uncompressedSize) {
        return uncompressedSize + (uncompressedSize >> 12) + (uncompressedSize >> 14) + (uncompressedSize >> 25) + 13 + 4;
    }

    public ChunkCompressionType compressionType() {
        return ChunkCompressionType.GZIP;
    }

    public void close() throws IOException {
        this._compressor.end();
    }
}

