/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.writer.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.io.readerwriter.RealtimeIndexOffHeapMemoryManager;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.metrics.PinotMetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MmapMemoryManager
extends RealtimeIndexOffHeapMemoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MmapMemoryManager.class);
    private static final long DEFAULT_FILE_LENGTH = 0x20000000L;
    private final String _dirPathName;
    private final String _segmentName;
    private volatile int _numFiles = 0;
    private long _availableOffset = 0x20000000L;
    private long _curFileLen = -1L;
    private final List<String> _paths = new LinkedList<String>();
    private final List<PinotDataBuffer> _memMappedBuffers = new LinkedList<PinotDataBuffer>();
    PinotDataBuffer _currentBuffer;

    @VisibleForTesting
    public static long getDefaultFileLength() {
        return 0x20000000L;
    }

    public MmapMemoryManager(String dirPathName, String segmentName, ServerMetrics serverMetrics) {
        super(serverMetrics, segmentName);
        this._dirPathName = dirPathName;
        this._segmentName = segmentName;
        File dirFile = new File(this._dirPathName);
        if (dirFile.exists()) {
            File[] segmentFiles;
            for (File file : segmentFiles = dirFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(MmapMemoryManager.this.getFilePrefix());
                }
            })) {
                if (file.delete()) {
                    LOGGER.info("Deleted old file {}", (Object)file.getAbsolutePath());
                    continue;
                }
                LOGGER.error("Cannot delete file {}", (Object)file.getAbsolutePath());
            }
        }
    }

    @VisibleForTesting
    public MmapMemoryManager(String dirPathName, String segmentName) {
        this(dirPathName, segmentName, new ServerMetrics(PinotMetricUtils.getPinotMetricsRegistry()));
    }

    private String getFilePrefix() {
        return this._segmentName + ".";
    }

    private void addFileIfNecessary(long len) {
        RandomAccessFile raf;
        if (len + this._availableOffset <= this._curFileLen) {
            return;
        }
        String thisContext = this.getFilePrefix() + this._numFiles++;
        String filePath = this._dirPathName + "/" + thisContext;
        File file = new File(filePath);
        if (file.exists()) {
            throw new RuntimeException("File " + filePath + " already exists");
        }
        file.deleteOnExit();
        try {
            raf = new RandomAccessFile(filePath, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        long fileLen = Math.max(0x20000000L, len);
        try {
            raf.setLength(fileLen);
            raf.close();
            this._currentBuffer = PinotDataBuffer.mapFile((File)file, (boolean)false, (long)0L, (long)fileLen, (ByteOrder)PinotDataBuffer.NATIVE_ORDER, (String)thisContext);
            LOGGER.info("Mapped file {} for segment {} into buffer {}", new Object[]{file.getAbsolutePath(), this._segmentName, this._currentBuffer});
            this._memMappedBuffers.add(this._currentBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this._paths.add(filePath);
        this._availableOffset = 0L;
        this._curFileLen = fileLen;
    }

    @Override
    protected PinotDataBuffer allocateInternal(long size, String columnName) {
        this.addFileIfNecessary(size);
        PinotDataBuffer buffer = this._currentBuffer.view(this._availableOffset, this._availableOffset + size);
        this._availableOffset += size;
        return buffer;
    }

    @Override
    protected void doClose() throws IOException {
        for (PinotDataBuffer buffer : this._memMappedBuffers) {
            LOGGER.info("Closing buffer {}", (Object)buffer);
            buffer.close();
        }
        for (String path : this._paths) {
            try {
                File file = new File(path);
                if (file.delete()) {
                    LOGGER.info("Deleted file {}", (Object)path);
                    continue;
                }
                throw new RuntimeException("Unable to delete file: " + file);
            }
            catch (Exception e) {
                LOGGER.warn("Exception trying to delete file {}", (Object)path, (Object)e);
            }
        }
    }
}

