/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.dictionary;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.segment.spi.index.mutable.MutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOffHeapMutableDictionary
implements MutableDictionary {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOffHeapMutableDictionary.class);
    private static final int[] PRIME_NUMBERS = new int[]{13, 127, 547, 1009, 2003, 3001, 4003, 5003, 7001, 9001, 10007, 12007, 14009, 16001, 18013, 20011, 40009, 60013, 80021, 100003, 125113, 150011, 175003, 200003, 225023, 250007, 275003, 300007, 350003, 400009, 450001, 500009, 600011, 700001, 800011, 900001, 1000003};
    private static final int[] EXPANSION_MULTIPLES = new int[]{1, 1, 2, 2, 2};
    private static final int NUM_COLUMNS = 3;
    private static boolean _heapFirst = true;
    private final int _maxItemsInOverflowHash;
    private volatile int _numEntries;
    private final int _initialRowCount;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final String _allocationContext;
    private volatile ValueToDictId _valueToDict;

    protected BaseOffHeapMutableDictionary(int estimatedCardinality, int maxOverflowHashSize, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        this._memoryManager = memoryManager;
        this._allocationContext = allocationContext;
        this._initialRowCount = this.nearestPrime(estimatedCardinality);
        this._maxItemsInOverflowHash = maxOverflowHashSize;
        this.init();
    }

    protected void init() {
        this._numEntries = 0;
        this._valueToDict = new ValueToDictId(new ArrayList<IntBuffer>(), new ConcurrentHashMap<Object, Integer>());
        if (!_heapFirst || this._maxItemsInOverflowHash == 0) {
            this.expand(this._initialRowCount, 1);
        }
    }

    public int length() {
        return this._numEntries;
    }

    public void close() throws IOException {
        this.doClose();
    }

    private int nearestPrime(int size) {
        for (int primeNumber : PRIME_NUMBERS) {
            if (primeNumber < size) continue;
            return primeNumber;
        }
        return PRIME_NUMBERS[PRIME_NUMBERS.length - 1];
    }

    private long computeBBsize(long numRows) {
        return numRows * 3L * 4L;
    }

    private int validatedNumRows(int prevNumRows, int multiple) {
        long newNumRows = (long)prevNumRows * (long)multiple;
        if (newNumRows > Integer.MAX_VALUE) {
            return prevNumRows;
        }
        if (this.computeBBsize(newNumRows) > Integer.MAX_VALUE) {
            return prevNumRows;
        }
        return (int)newNumRows;
    }

    private IntBuffer expand(int prevNumRows, int multiple) {
        IntBuffer iBuf2;
        int newNumRows = this.validatedNumRows(prevNumRows, multiple);
        int bbSize = (int)this.computeBBsize(newNumRows);
        ValueToDictId valueToDictId = this._valueToDict;
        List<IntBuffer> oldList = valueToDictId.getIBufList();
        ArrayList<IntBuffer> newList = new ArrayList<IntBuffer>(oldList.size() + 1);
        for (IntBuffer iBuf2 : oldList) {
            newList.add(iBuf2);
        }
        LOGGER.info("Allocating {} bytes for: {}", (Object)bbSize, (Object)this._allocationContext);
        PinotDataBuffer buffer = this._memoryManager.allocate((long)bbSize, this._allocationContext);
        iBuf2 = buffer.toDirectByteBuffer(0L, bbSize).asIntBuffer();
        for (int i = 0; i < iBuf2.capacity(); ++i) {
            iBuf2.put(i, -1);
        }
        newList.add(iBuf2);
        ConcurrentHashMap<Object, Integer> newOverflowMap = new ConcurrentHashMap<Object, Integer>(HashUtil.getHashMapCapacity((int)this._maxItemsInOverflowHash));
        if (this._maxItemsInOverflowHash > 0) {
            Map<Object, Integer> oldOverflowMap = valueToDictId.getOverflowMap();
            for (Map.Entry<Object, Integer> entry : oldOverflowMap.entrySet()) {
                int hashVal = entry.getKey().hashCode() & Integer.MAX_VALUE;
                int offsetInBuf = hashVal % newNumRows * 3;
                boolean done = false;
                for (int i = offsetInBuf; i < offsetInBuf + 3; ++i) {
                    if (iBuf2.get(i) != -1) continue;
                    iBuf2.put(i, entry.getValue());
                    done = true;
                    break;
                }
                if (done) continue;
                newOverflowMap.put(entry.getKey(), entry.getValue());
            }
        }
        this._valueToDict = new ValueToDictId(newList, newOverflowMap);
        return iBuf2;
    }

    private IntBuffer expand() {
        ValueToDictId valueToDictId = this._valueToDict;
        List<IntBuffer> iBufList = valueToDictId.getIBufList();
        int numBuffers = iBufList.size();
        if (numBuffers == 0) {
            return this.expand(this._initialRowCount, 1);
        }
        int lastCapacity = iBufList.get(numBuffers - 1).capacity();
        int expansionMultiple = EXPANSION_MULTIPLES[EXPANSION_MULTIPLES.length - 1];
        if (numBuffers < EXPANSION_MULTIPLES.length) {
            expansionMultiple = EXPANSION_MULTIPLES[numBuffers];
        }
        int prevNumRows = lastCapacity / 3;
        return this.expand(prevNumRows, expansionMultiple);
    }

    protected int nearestPowerOf2(int num) {
        if ((num & num - 1) == 0) {
            return num;
        }
        int power = 32 - Integer.numberOfLeadingZeros(num);
        Preconditions.checkState((power < 31 ? 1 : 0) != 0);
        return 1 << power;
    }

    protected int getDictId(Object value, byte[] serializedValue) {
        int hashVal = value.hashCode() & Integer.MAX_VALUE;
        ValueToDictId valueToDictId = this._valueToDict;
        List<IntBuffer> iBufList = valueToDictId.getIBufList();
        for (IntBuffer iBuf : iBufList) {
            int offsetInBuf;
            int modulo = iBuf.capacity() / 3;
            for (int i = offsetInBuf = hashVal % modulo * 3; i < offsetInBuf + 3; ++i) {
                int dictId = iBuf.get(i);
                if (dictId == -1 || !this.equalsValueAt(dictId, value, serializedValue)) continue;
                return dictId;
            }
        }
        if (this._maxItemsInOverflowHash == 0) {
            return -1;
        }
        Integer dictId = valueToDictId.getOverflowMap().get(value);
        if (dictId == null) {
            return -1;
        }
        return dictId;
    }

    protected int indexValue(Object value, byte[] serializedValue) {
        Integer dictId;
        int offsetInBuf;
        int i;
        int modulo;
        int hashVal = value.hashCode() & Integer.MAX_VALUE;
        int newValueDictId = this._numEntries;
        ValueToDictId valueToDictId = this._valueToDict;
        for (IntBuffer iBuf : valueToDictId.getIBufList()) {
            modulo = iBuf.capacity() / 3;
            for (i = offsetInBuf = hashVal % modulo * 3; i < offsetInBuf + 3; ++i) {
                int dictId2 = iBuf.get(i);
                if (dictId2 == -1) {
                    this.setValue(newValueDictId, value, serializedValue);
                    iBuf.put(i, newValueDictId);
                    this._numEntries = newValueDictId + 1;
                    return newValueDictId;
                }
                if (!this.equalsValueAt(dictId2, value, serializedValue)) continue;
                return dictId2;
            }
        }
        Map<Object, Integer> overflowMap = valueToDictId.getOverflowMap();
        if (this._maxItemsInOverflowHash > 0 && (dictId = overflowMap.get(value)) != null) {
            return dictId;
        }
        this.setValue(newValueDictId, value, serializedValue);
        if (this._maxItemsInOverflowHash > 0 && overflowMap.size() < this._maxItemsInOverflowHash) {
            overflowMap.put(value, newValueDictId);
            this._numEntries = newValueDictId + 1;
            return newValueDictId;
        }
        IntBuffer buf = this.expand();
        modulo = buf.capacity() / 3;
        for (i = offsetInBuf = hashVal % modulo * 3; i < offsetInBuf + 3; ++i) {
            if (buf.get(i) != -1) continue;
            buf.put(i, newValueDictId);
            this._numEntries = newValueDictId + 1;
            return newValueDictId;
        }
        overflowMap = this._valueToDict.getOverflowMap();
        overflowMap.put(value, newValueDictId);
        this._numEntries = newValueDictId + 1;
        return newValueDictId;
    }

    protected long getOffHeapMemUsed() {
        ValueToDictId valueToDictId = this._valueToDict;
        long size = 0L;
        for (IntBuffer iBuf : valueToDictId._iBufList) {
            size += (long)(iBuf.capacity() * 4);
        }
        return size;
    }

    public int getNumberOfHeapBuffersUsed() {
        ValueToDictId valueToDictId = this._valueToDict;
        return valueToDictId._iBufList.size();
    }

    public int getNumberOfOveflowValues() {
        ValueToDictId valueToDictId = this._valueToDict;
        return valueToDictId._overflowMap.size();
    }

    protected abstract void setValue(int var1, Object var2, byte[] var3);

    protected abstract boolean equalsValueAt(int var1, Object var2, byte[] var3);

    public abstract int getAvgValueSize();

    public abstract long getTotalOffHeapMemUsed();

    protected abstract void doClose() throws IOException;

    private static class ValueToDictId {
        private final List<IntBuffer> _iBufList;
        private final Map<Object, Integer> _overflowMap;

        private ValueToDictId(List<IntBuffer> iBufList, Map<Object, Integer> overflowMap) {
            this._iBufList = iBufList;
            this._overflowMap = overflowMap;
        }

        private List<IntBuffer> getIBufList() {
            return this._iBufList;
        }

        private Map<Object, Integer> getOverflowMap() {
            return this._overflowMap;
        }
    }
}

